<?php
/**
 * Created by PhpStorm.
 * User: Villatheme-Thanh
 * Date: 25-03-19
 * Time: 5:00 PM
 */

namespace WACVP\Inc\SMS;

use WACVP\Inc\Aes_Ctr;
use WACVP\Inc\Data;
use WACVP\Inc\Query_DB;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Send_SMS_Cron {

	protected static $instance = null;

	protected $query;

	protected $data;

	protected $phoneNumberUtil;

	protected $format_e164;

	protected $characters_array;

	protected $error_code;

	private function __construct() {
		if ( ! wp_next_scheduled( 'wacv_cron_send_sms' ) ) {
			wp_schedule_event( time(), 'one_minute', 'wacv_cron_send_sms' );
		}

		$this->query = Query_DB::get_instance();

//		add_action( 'init', array( $this, 'send_sms_init' ) );
		add_action( 'wacv_cron_send_sms', array( $this, 'send_sms_init' ) );
		add_action( 'admin_notices', array( $this, 'sms_balance_notice' ) );
	}

	public static function get_instance() {
		if ( null == self::$instance ) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	public function send_sms_init() {
		$this->data = Data::get_params();
		if ( floatval( $this->check_balance() ) < 0.5 ) {
			return;
		}

		if ( $this->data['sms_abd_cart_enable'] || $this->data['sms_abd_order_enable'] ) {
			$this->api_init();
			if ( $this->data['sms_abd_cart_enable'] ) {
				$this->send_sms_abd_cart();
			}
			if ( $this->data['sms_abd_order_enable'] ) {
				$this->send_sms_abd_order();
			}
		}
	}

	public function check_balance() {
		$result = 0;
		switch ( $this->data['sms_provider'] ) {
			case 'twilio':
				if ( $this->data['sms_app_id'] && $this->data['sms_app_secret'] ) {
					$url  = "https://api.twilio.com/2010-04-01/Accounts/" . $this->data['sms_app_id'] . "/Balance.json";
					$args = array(
						'headers' => array(
							'Authorization' => 'Basic ' . base64_encode( $this->data['sms_app_id'] . ':' . $this->data['sms_app_secret'] )
						)
					);

					$res = wp_remote_get( $url, $args );

					if ( wp_remote_retrieve_response_code( $res ) < 400 ) {
						$res_body = json_decode( wp_remote_retrieve_body( $res ) );
						$result   = floatval( $res_body->balance );
					}
				}
				break;
			case 'nexmo':
				$result = get_option( 'wacv_nexmo_balance' );
				break;
		};

		return $result;
	}

	public function api_init() {
		require_once WACVP_INCLUDES . 'sms/libphonenumber/autoload.php';
		$this->phoneNumberUtil = \libphonenumber\PhoneNumberUtil::getInstance();
		$this->format_e164     = \libphonenumber\PhoneNumberFormat::E164;
	}

	public function send_sms_abd_cart() {
		if ( ! empty( $this->data['sms_abd_cart'] ) ) {
			$rules = $this->data['sms_abd_cart'];
			for ( $i = 0; $i < count( $rules['send_time'] ); $i ++ ) {
				$time_to_send = current_time( 'timestamp' ) - intval( $rules['time_to_send'][ $i ] ) * Data::get_instance()->case_unit( $rules['unit'][ $i ] );

				$lists = $this->query->get_list_sms_to_send( $time_to_send, $rules['send_time'][ $i ] );

				if ( is_array( $lists ) && count( $lists ) > 0 ) {
					if ( isset( $rules['message'][ $i ] ) ) {
						foreach ( $lists as $item ) {
							if ( $item->user_id < 100000000 || $item->user_id >= 100000000 && $item->billing_phone ) {
								$this->sms_content_cart( $item, $rules['message'][ $i ], $rules['send_time'][ $i ] );
							}
						}
					}
				}
			}
		}
	}

	public function sms_content_cart( $item, $template, $time ) {
		if ( ! empty( $item->user_id ) && $template ) {
			$phone         = $item->billing_phone;
			$customer_name = $item->billing_last_name . ' ' . $item->billing_first_name;
			$country       = $item->billing_country;

			if ( $item->user_type == 'member' ) {
				$phone         = get_user_meta( $item->user_id, 'billing_phone', true );
				$country       = get_user_meta( $item->user_id, 'billing_country', true );
				$ln            = get_user_meta( $item->user_id, 'billing_last_name', true );
				$fn            = get_user_meta( $item->user_id, 'billing_first_name', true );
				$customer_name = $fn . ' ' . $ln;
			}
			if ( ! $country ) {
				return;
			}
			$acr_id            = $item->id;
			$phoneNumberObject = $this->phoneNumberUtil->parse( $phone, $country );
			$is_phone          = $this->phoneNumberUtil->isPossibleNumber( $phoneNumberObject );
			if ( $is_phone ) {
				$phone_formated = $this->phoneNumberUtil->format( $phoneNumberObject, $this->format_e164 );
				$result         = $this->send_sms( 'cart', $phone_formated, $acr_id, $template, $customer_name );
				if ( $result ) {
					$this->query->update_abd_cart_record( array( 'sms_sent' => $time ), array( 'id' => $acr_id ) );
				}
			}
		}
	}

	public function send_sms( $type, $phone, $acr_id, $template, $customer_name ) {
		$result = false;
		if ( $phone ) {

			$sent_email_id = uniqid() . $acr_id;
			$pass          = get_option( 'wacv_private_key' );
			$url_encode    = Aes_Ctr::encrypt( $acr_id . '&' . $sent_email_id, $pass, 256 );

			$link = site_url( "wacv?wacv_recover={$type}_link&valid=" ) . $url_encode;
			$link = $this->get_shorten_link( $link );

			if ( ! $link ) {
				return false;
			}

			$search  = array( '{customer_name}', '{checkout_link}' );
			$replace = array( $customer_name, $link );
			$message = str_replace( $search, $replace, $template );

			//Select sms provider
			$func   = "send_sms_by_{$this->data['sms_provider']}";
			$result = $this->$func( $phone, $message, $type, $acr_id, $sent_email_id );
		}

		return $result;
	}

	public function get_shorten_link( $long_url ) {
		if ( ! $this->data['shortlink_access_token'] ) {
			return $long_url;
		}
		$params                 = array();
		$params['access_token'] = $this->data['shortlink_access_token'];
		$params['longURL']      = $long_url; //right

		if ( WP_DEBUG ) {
			$params['longURL'] = 'http://mysite.com/wacv?wacv_recover=cart_link&valid=UQJyWF4tLF3WcLmb5GgnaDNVxJoLzYc5TGR2SQ=='; //test
		}

		$url = 'https://api-ssl.bitly.com/v3/shorten?' . http_build_query( $params );

		$exe      = wp_remote_post( $url, array() );
		$stt_code = wp_remote_retrieve_response_code( $exe );
		if ( $stt_code >= 400 ) {
			return $long_url;
		}
		$output = wp_remote_retrieve_body( $exe );

		$short_link = json_decode( $output )->data->url;

		return $short_link;
	}

	public function send_sms_abd_order() {
		if ( ! empty( $this->data['sms_abd_order'] ) ) {
			$rules = $this->data['sms_abd_order'];
			for ( $i = 0; $i < count( $rules['send_time'] ); $i ++ ) {
				$time_to_send = current_time( 'timestamp' ) - intval( $rules['time_to_send'][ $i ] ) * Data::get_instance()->case_unit( $rules['unit'][ $i ] );
				$args         = array(
					'post_type'    => 'shop_order',
					'post_status'  => $this->data['sms_order_stt'],
					'date_created' => '<' . $time_to_send,
					'meta_query'   => array(
						array(
							'key'   => 'wacv_send_reminder_sms',
							'value' => $rules['send_time'] [ $i ] - 1,
						),
						array(
							'key'   => 'wacv_reminder_unsubscribe',
							'value' => '',
						),
						array(
							'key'   => 'wacv_check_phone_number',
							'value' => '',
						),

					)
				);

				$the_query = new \WP_Query( $args );
				if ( $the_query->have_posts() ) :
					foreach ( $the_query->get_posts() as $order ) {
//					    check($order->ID);die;
						$this->sms_content_order( $order->ID, $rules['message'] [ $i ], $rules['send_time'] [ $i ] );
					}
				endif;

			}
		}
	}

	public function sms_content_order( $order_id, $template, $time ) {
		$order         = wc_get_order( $order_id );
		$phone         = $order->get_billing_phone();
		$customer_name = $order->get_formatted_billing_full_name();
		$country       = $order->get_billing_country();

		$phoneNumberObject = $this->phoneNumberUtil->parse( $phone, $country );
		$is_phone          = $this->phoneNumberUtil->isPossibleNumber( $phoneNumberObject );
		if ( $is_phone ) {
			$phone_formated = $this->phoneNumberUtil->format( $phoneNumberObject, $this->format_e164 );

			$sent = $this->send_sms( 'order', $phone_formated, $order_id, $template, $customer_name );
			if ( $sent ) {
				update_post_meta( $order_id, 'wacv_send_reminder_sms', $time );
			}
		}
	}

	public function send_sms_by_nexmo( $phone, $message, $type, $acr_id, $sent_email_id ) {
		$result = false;
		$url    = 'https://rest.nexmo.com/sms/json?' . http_build_query( [
				'api_key'    => $this->data['sms_app_id_nexmo'],
				'api_secret' => $this->data['sms_app_secret_nexmo'],
				'to'         => $phone,
				'from'       => $this->data['from_phone_nexmo'],
				'text'       => $message
			] );

		$response = wp_remote_get( $url );
		$res_code = wp_remote_retrieve_response_code( $response );

		if ( $res_code < 400 ) {
			$res        = (array) json_decode( wp_remote_retrieve_body( $response ) );
			$res_status = $res['message-count'];
			if ( $res_status ) {
				$this->query->insert_email_history( 'sms_' . $type, $acr_id, $sent_email_id );
				if ( isset( $res['messages'] ) && is_array( $res['messages'] ) ) {
					foreach ( $res['messages'] as $item ) {
						$item            = (array) $item;
						$current_balance = $item['remaining-balance'];
						update_option( 'wacv_nexmo_balance', $current_balance );
					}
				}
				$result = true;
			}
		} else {
			if ( $type == 'order' ) {
				update_post_meta( $acr_id, 'wacv_check_phone_number', 'NG' );
			} elseif ( $type == 'cart' ) {
				$this->query->update_abd_cart_record( array( 'valid_phone' => 1 ), array( 'id' => $acr_id ) );
			}
		}

		return $result;
	}

	public function send_sms_by_twilio( $phone, $message, $type, $acr_id, $sent_email_id ) {
		$result  = false;
		$url     = "https://api.twilio.com/2010-04-01/Accounts/" . $this->data['sms_app_id'] . "/Messages.json";
		$data    = array(
			'From' => $this->data['from_phone'],
			'To'   => $phone,
			'Body' => $message
		);
		$headers = array(
			'Authorization' => 'Basic ' . base64_encode( $this->data['sms_app_id'] . ':' . $this->data['sms_app_secret'] )
		);

		$response = wp_remote_post( $url, array(
			'body'    => $data,
			'headers' => $headers
		) );

		$res_code = wp_remote_retrieve_response_code( $response );

		if ( $res_code < 400 ) {
			$res        = json_decode( wp_remote_retrieve_body( $response ) );
			$res_status = $res->status;
			if ( $res_status == ( 'queued' || 'sent' ) ) {
				$this->query->insert_email_history( 'sms_' . $type, $acr_id, $sent_email_id );
				$result = true;
			}
		} else {
			if ( $type == 'order' ) {
				update_post_meta( $acr_id, 'wacv_check_phone_number', 'NG' );
			} elseif ( $type == 'cart' ) {
				$this->query->update_abd_cart_record( array( 'valid_phone' => 1 ), array( 'id' => $acr_id ) );
			}
		}

		return $result;
	}

	public function sms_balance_notice() {
		if ( $this->data['sms_abd_cart_enable'] || $this->data['sms_abd_order_enable'] ) {
			if ( floatval( $this->check_balance() ) > 0.5 ) {
				return;
			}
			?>
            <div id="message" class="notice notice-error is-dismissible">
                <p><?php _e( 'You don\'t have enough balance to send the SMS.', 'woo-abandoned-cart-recovery' ); ?></p>
            </div>
			<?php
		}
	}
}
