<?php
/**
 * Created by PhpStorm.
 * User: Villatheme-Thanh
 * Date: 08-06-19
 * Time: 2:35 PM
 */

namespace WACVP\Inc\Settings;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class SMS_Settings extends Admin_Settings {

	protected static $instance = null;

	public static function get_instance() {

		if ( null == self::$instance ) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	public function setting_page() {
		$provider = self::$data['sms_provider'];
		?>
        <div class="vi-ui bottom attached tab segment tab-admin" data-tab="sms">
            <table class="wacv-table">
				<?php $this->select_option( 'sms_provider',
					$option = array( 'twilio' => 'Twilio', 'nexmo' => 'Nexmo' ),
					__( 'SMS provider', 'woo-abandoned-cart-recovery' ) ) ?>
            </table>
            <div class="wacv-providers">
                <div class="wacv-twilio-config" <?php $this->show( $provider, 'twilio' ) ?>>
                    <table class="wacv-table">
						<?php
						$this->text_option( 'sms_app_id', __( 'App ID', 'woo-abandoned-cart-recovery' ) );
						$this->text_option( 'sms_app_secret', __( 'App token', 'woo-abandoned-cart-recovery' ) );
						$this->text_option( 'from_phone', __( 'From number', 'woo-abandoned-cart-recovery' ) );
						?>
                    </table>
                </div>
                <div class="wacv-nexmo-config" <?php $this->show( $provider, 'nexmo' ) ?>>
                    <table class="wacv-table">
						<?php
						$this->text_option( 'sms_app_id_nexmo', __( 'App ID', 'woo-abandoned-cart-recovery' ) );
						$this->text_option( 'sms_app_secret_nexmo', __( 'App token', 'woo-abandoned-cart-recovery' ) );
						$this->text_option( 'from_phone_nexmo', __( 'From number', 'woo-abandoned-cart-recovery' ) );
						?>
                    </table>
                </div>
            </div>
            <h4><?php esc_html_e( 'Bitly config', 'woo-abandoned-cart-recovery' ) ?></h4>
            <table class="wacv-table">
				<?php
				$this->text_option( 'shortlink_access_token', __( 'Access token', 'woo-abandoned-cart-recovery' ) );
				?>
                <tr>
                    <td class="col-1" valign="top">
                    </td>
                    <td class="col-2">
                        <div class="vi-ui styled accordion wacv-accor">
                            <div class="title">
                                <i class="dropdown icon"></i>
								<?php esc_html_e( 'Config guide', 'woo-abandoned-cart-recovery' ) ?>
                            </div>
                            <div class="content">
                                <ul>
                                    <li><?php _e( '1. Create a twilio\'s account at ', 'woo-abandoned-cart-recovery' ) ?>
                                        <a href="https://www.routee.net/">https://www.twilio.com</a></li>
                                    <li><?php _e( '2. Login twilio\'s account ', 'woo-abandoned-cart-recovery' ) ?></li>
                                    <li><?php _e( '3. Copy app id, app token & phone number to input fields above', 'woo-abandoned-cart-recovery' ) ?></li>
                                    <li><img width="100%" src="<?php echo WACVP_IMAGES . 'sms-guide.jpg' ?>"></li>
                                    <li><?php _e( '4. Create an bitly\'s account at ', 'woo-abandoned-cart-recovery' ) ?>
                                        <a href="https://bitly.com/">https://bitly.com/</a></li>
                                    <li><?php _e( '5. Login bitly\'s account ', 'woo-abandoned-cart-recovery' ) ?></li>
                                    <li><?php _e( '6. Go to Settings > Edit profile > Generic Access Token, enter your password & click \'Generate Token\' ', 'woo-abandoned-cart-recovery' ) ?></li>
                                    <li><?php _e( '7. Copy your access token to access token field & save settings', 'woo-abandoned-cart-recovery' ) ?></li>
                                </ul>
                            </div>
                        </div>
                    </td>
                </tr>
            </table>
            <hr>

            <h4><?php esc_html_e( 'SMS for Abandoned Cart', 'woo-abandoned-cart-recovery' ) ?></h4>
            <table class="wacv-table">
				<?php
				$this->checkbox_option( 'sms_abd_cart_enable', __( 'Enable', 'woo-abandoned-cart-recovery' ) );
				$this->send_message_rules_settings( 'sms_abd_cart' );
				?>
            </table>
            <hr>

            <h4><?php esc_html_e( 'SMS for Abandoned Order', 'woo-abandoned-cart-recovery' ) ?></h4>
            <table class="wacv-table">
				<?php
				$this->checkbox_option( 'sms_abd_order_enable', __( 'Enable', 'woo-abandoned-cart-recovery' ) );
				$order_stt = array(
					'wc-failed'    => 'Failed',
					'wc-cancelled' => 'Cancelled',
					'wc-pending'   => 'Pending payment',
					'wc-on-hold'   => "On hold",
				);
				$this->select_option( 'sms_order_stt', $order_stt, __( "Order status", 'woo-abandoned-cart-recovery' ), '', '', true );
				$this->send_message_rules_settings( 'sms_abd_order' );
				?>
            </table>
        </div>
		<?php
	}

	public function show( $provider, $current ) {
		if ( $provider == $current ) {
			echo "style='display:block;'";
		} else {
			echo "style='display:none;'";
		}
	}
}
