<?php
/**
 * Created by PhpStorm.
 * User: Villatheme-Thanh
 * Date: 23-03-19
 * Time: 2:08 PM
 */

namespace WACVP\Inc\Reports;

use WACVP\Inc\Functions;
use WACVP\Inc\Query_DB;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( '\WP_List_Table' ) ) {
	require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}

class Abandoned_Report_Table extends \WP_List_Table {

	protected static $instance = null;

//	public $per_page = 30;

	public $base_url;

	public $total_count;

	public $query;
	
	public $start;
	
	public $end;


	public function __construct() {
		parent::__construct( array(
			'singular' => 'abandoned',     //singular name of the listed records
			'plural'   => 'abandoneds',    //plural name of the listed records
			'ajax'     => true        //does this table support ajax?
		) );
		$this->query = Query_DB::get_instance();

	}

	public static function get_instance() {

		// If the single instance hasn't been set, set it now.
		if ( null == self::$instance ) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	/**
	 * It will add the bulk action function and other variable needed for the class.
	 * @since 2.5.2
	 * @see WP_List_Table::__construct()
	 */
	public function abandoned_table() {

		$class_all_customer = $class_member = $class_guest = '';
		$section            = isset( $_GET['abd_table'] ) ? sanitize_text_field( $_GET['abd_table'] ) : '';

		switch ( $section ) {
			case 'all_customer':
			case '':
				$class_all_customer = 'current';
				break;
			case 'member':
				$class_member = 'current';
				break;
			case 'guest':
				$class_guest = 'current';
				break;
		}

		?>
        <h3><?php esc_html_e( 'Abandoned Carts', 'woo-abandoned-cart-recovery' ) ?></h3>
		<?php do_action( 'wacv_notices' ) ?>
        <div class="wacv-abanoned-cart-page">
            <ul class="subsubsub">
                <li><a href="<?php echo admin_url( 'admin.php?page=wacv_sections&abd_table=all_customer' ) ?>"
                       class="<?php echo esc_html( $class_all_customer ) ?>"><?php esc_html_e( 'All', 'woo-abandoned-cart-recovery' ) ?></a>
                    |
                </li>
                <li><a href="<?php echo admin_url( 'admin.php?page=wacv_sections&abd_table=member' ) ?>"
                       class="<?php echo esc_html( $class_member ) ?>"><?php esc_html_e( 'Member', 'woo-abandoned-cart-recovery' ) ?></a>
                    |
                </li>
                <li><a href="<?php echo admin_url( 'admin.php?page=wacv_sections&abd_table=guest' ) ?>"
                       class="<?php echo esc_html( $class_guest ) ?>"><?php esc_html_e( 'Guest', 'woo-abandoned-cart-recovery' ) ?></a>
                </li>
            </ul>
			<?php
			$this->prepare_items();
			$this->show_record();
			?>
        </div>
		<?php
	}

	public function prepare_items() {
		$columns  = $this->get_columns();
		$hidden   = array();
		$sortable = $this->get_sortable_columns();

		$this->_column_headers = array( $columns, $hidden, $sortable );
		$this->process_bulk_action();
		$data = $this->get_items();

//		usort( $data, array( $this, 'usort_reorder' ) );

		$current_page = $this->get_pagenum();


		$total_items = count( $data );

		$per_page = $this->get_items_per_page( 'wacv_acr_per_page', 30 );

		$data = array_slice( $data, ( ( $current_page - 1 ) * $per_page ), $per_page );

		$this->items = $data;

		$this->set_pagination_args( array(
			'total_items' => $total_items,
			//WE have to calculate the total number of items
			'per_page'    => $per_page,
			//WE have to determine how many items to show on a page
			'total_pages' => ceil( $total_items / $per_page )
			//WE have to calculate the total number of pages
		) );
	}

	public function get_columns() {
		$columns = array(
			'checkbox'    => "<input class='wacv-check-all' type='checkbox'>",
			'date'        => __( 'Date', 'woo-abandoned-cart-recovery' ),
			'customer'    => __( 'Customer', 'woo-abandoned-cart-recovery' ),
			'cart_detail' => __( 'Cart Detail', 'woo-abandoned-cart-recovery' ),
			'stt'         => __( 'Status', 'woo-abandoned-cart-recovery' ),
			'reminder'    => __( 'Reminder logs', 'woo-abandoned-cart-recovery' ),
			'from'        => __( 'From', 'woo-abandoned-cart-recovery' )
		);

		return apply_filters( 'wcal_abandoned_orders_columns', $columns );
	}

	public function get_sortable_columns() {
		$sortable_columns = array(
			'id' => array( 'id', true ),       //true means it's already sorted
		);

		return $sortable_columns;
	}

	public function process_bulk_action() {
	}

	public function get_items() {
		if ( isset( $_GET['_wpnonce'] ) && ! wp_verify_nonce( wp_unslash( $_GET['_wpnonce'] ), 'wacv-filter' ) ) {
			return;
		}

		$this->start = Functions::get_time()['start'];
		$this->end   = Functions::get_time()['end'];

		$section     = isset( $_GET['abd_table'] ) ? sanitize_text_field( $_GET['abd_table'] ) : 'all_customer';
		$export_data = $results = array();

		switch ( $section ) {
			case 'all_customer':
				$results = $this->query->get_abd_list( 'all_customer', $this->start, $this->end );
				break;
			case 'member':
				$results = $this->query->get_abd_list( 'member', $this->start, $this->end );
				break;
			case 'guest':
				$results = $this->query->get_abd_list( 'guest', $this->start, $this->end );
				break;
		}

		$i = 0;
		foreach ( $results as $result ) {
			$user_email = $result->user_email;
			$name       = $result->user_login;
			$user_ref   = $result->user_ref;

			if ( $result->user_type == 'member' ) {
				$user_ref = get_user_meta( $result->user_id, 'wacv_user_ref', true );
			}

			if ( $result->user_type == 'guest' ) {
				$sub_name   = __( "Guest", 'woo-abandoned-cart-recovery' );
				$name       = ! empty( $result->billing_first_name ) || ! empty( $result->billing_last_name ) ? esc_html( $result->billing_first_name . ' ' . $result->billing_last_name ) : $sub_name;
				$user_email = $result->billing_email;
			}

			$cart = json_decode( $result->abandoned_cart_info );

			$line_total = $line_tax = $item_qty = 0;

			foreach ( $cart->cart as $item ) {
				$line_total += $item->line_total + $item->line_tax;
				$line_tax   += $item->line_tax;
				$item_qty   += $item->quantity;
			}

			$date_format = date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), $result->abandoned_cart_time );

			if ( $result->order_type == 1 ) {
				$stt = '<span class="wacv-recovered-stt">' . __( 'Recovered', 'woo-abandoned-cart-recovery' ) . '</span>';
			} else {
				$stt = $result->unsubscribe_link ? '<span class="wacv-unsubscribed-stt">' . __( 'Unsubscribed', 'woo-abandoned-cart-recovery' ) . '</span>' : '<span class="wacv-abandoned-stt">' . __( 'Abandoned', 'woo-abandoned-cart-recovery' ) . '</span>';
			}

			$code = ! empty( \WC_Geolocation::geolocate_ip( $result->customer_ip )['country'] ) ? \WC_Geolocation::geolocate_ip( $result->customer_ip )['country'] : '';

			$export_data[ $i ] = new \stdClass();

			$export_data[ $i ]->id                 = $result->id;
			$export_data[ $i ]->customer           = $name;
			$export_data[ $i ]->email              = $user_email;
			$export_data[ $i ]->user_ref           = $user_ref ? 'vlt-ico-messenger' : '';
			$export_data[ $i ]->total              = $line_total;
			$export_data[ $i ]->tax                = $line_tax;
			$export_data[ $i ]->item_qty           = $item_qty;
			$export_data[ $i ]->date               = $date_format;
			$export_data[ $i ]->stt                = $stt;
			$export_data[ $i ]->email_reminder     = $result->number_of_mailing;
			$export_data[ $i ]->messenger_reminder = $result->messenger_sent;
			$export_data[ $i ]->sms_reminder       = $result->sms_sent;
			$export_data[ $i ]->customer_ip        = $result->customer_ip;
			$export_data[ $i ]->country_name       = isset( WC()->countries->countries[ $code ] ) ? WC()->countries->countries[ $code ] : '';
			$export_data[ $i ]->country_flag       = $code ? "<i class='" . strtolower( $code ) . " flag'></i>" : "<img class='wacv-country-flag' src='" . WACVP_IMAGES . '_unknown.png' . "'>"; //<img class='wacv-country-flag' src='" . WACVP_FLAG . $code . ".png'>
			$export_data[ $i ]->os_platform        = $result->os_platform;
			$export_data[ $i ]->browser            = $result->browser;
			$i ++;

		}

		return ( $export_data );
	}


	public function show_record() {
		$this->display();
	}

	public function usort_reorder( $a, $b ) {
		$orderby = ( ! empty( $_REQUEST['orderby'] ) ) ? sanitize_text_field( $_REQUEST['orderby'] ) : 'id'; //If no sort, default to title
		$order   = ( ! empty( $_REQUEST['order'] ) ) ? sanitize_text_field( $_REQUEST['order'] ) : 'asc'; //If no order, default to asc
		$result  = strcmp( $a->$orderby, $b->$orderby ); //Determine sort order

		return ( $order === 'desc' ) ? $result : - $result; //Send final sort direction to usort
	}

	public function column_default( $item, $column_name ) {
		switch ( $column_name ) {
			case 'checkbox':
				$html = "<input type='checkbox' data-id='$item->id' data-time='$item->email_reminder' class='wacv-checkbox-bulk-action {$item->id}'>";

				return $html;

			case 'id':
				return $item->id;

			case 'customer':
				return "<div class='wacv-customer-info'>$item->customer</div><div class='wacv-customer-info'>$item->email</div><div class='$item->user_ref wacv-messenger-subscribe wacv-customer-info'></div>";

			case 'cart_detail':
				$unit = $item->item_qty > 1 ? __( 'items', 'woo-abandoned-cart-recovery' ) : __( 'item', 'woo-abandoned-cart-recovery' );
				$out  = "<a href='javascript:void(0)' class='wacv-get-abd-cart-detail $item->id' data-id='$item->id'>" . wc_price( $item->total ) . " ({$item->item_qty} {$unit})<i class='icon'></i></a>";

				return $out;

			case 'date':
				return $item->date;

			case 'stt':
				return $item->stt;

			case 'reminder':
				$reminder = "<table class='wacv-email-reminder-group' >";
				$reminder .= "<tr class='wacv-get-logs $item->id' data-id='$item->id'>";
				$reminder .= "<td style='position: absolute; left:-10px;'><i class='wacv-loading icon'></i><span class='wacv-email-reminder-popup $item->id'></span></td>";
				$reminder .= "<td style='text-align: right'><span class='wacv-reminder-number {$item->id}'>$item->email_reminder</span><span class='wacv-reminder-icon vlt-ico-mail3' data-id='$item->id'> </span></td>";
				$reminder .= "<td style='text-align: left'><span class='wacv-reminder-number'>$item->messenger_reminder</span><span class='wacv-reminder-icon vlt-ico-messenger' data-id='$item->id'> </span>";
				$reminder .= "<td style='text-align: left'><span class='wacv-reminder-number'>$item->sms_reminder</span><i class='wacv-reminder-icon mobile alternate icon' data-id='$item->id'> </i></td></tr></table>";

				return $reminder;

			case 'from':
				$from = "<div class='wacv-from'>{$item->country_flag}<div class='wacv-from-detail'><p>{$item->country_name}</p><p>{$item->customer_ip}</p></div><span style='margin-left: 5px'>{$item->os_platform}</span></div>"; //<p>{$item->browser}</p>

				return $from;

			default:
				return;
		}

	}

//	public function bulk_actions( $which = '' ) {
//		echo '<div>ddddd</div>';
//		die;
//	}

	public function column_cb( $item ) {
		return sprintf(
			'<input type="checkbox" name="%1$s[]" value="%2$s" />',
			'wacv_abandoned_id',
			$item->id  //$abd_id
		);
	}

	public function extra_tablenav( $which ) {
		if ( $which == 'top' ) {
			if ( isset( $_GET['_wpnonce'] ) && ! wp_verify_nonce( wp_unslash( $_GET['_wpnonce'] ), 'wacv-filter' ) ) {
				return;
			}
			$button   = 'submit';
			$selected = isset( $_GET['wacv_time_range'] ) ? sanitize_text_field( $_GET['wacv_time_range'] ) : get_option( 'wacv_time_range' );
			update_option( 'wacv_time_range', $selected );
			?>
            <form method="get" id="wacv-abandoned-cart" action="#">
                <input type="hidden" name="page" value="wacv_sections">
				<?php wc_get_template(
					'html-date-picker.php',
					array( 'start' => $this->start, 'end' => $this->end, 'button' => $button, 'selected' => $selected ),
					'', WACVP_TEMPLATES ) ?>
            </form>
            <div class="wacv-send-email-manual-group">
                <select name="wacv-template" class="wacv-template  vlt-none-shadow vlt-height-32">
					<?php $templates = ( Functions::get_email_template() );
					foreach ( $templates as $temp ) {
						echo "<option value='{$temp['id']}'>{$temp['value']}</option>";
					}
					?>
                </select>

                <button type="button" name="action" value="wacv_send_email_manual"
                        class="wacv-send-email-manual vlt-button vlt-height-32 vlt-border ">
					<?php _e( 'Send abandoned cart email', 'woo-abandoned-cart-recovery' ) ?>
                </button>
            </div>
			<?php
		}
	}
}


