<?php
/**
 * Created by PhpStorm.
 * User: Villatheme-Thanh
 * Date: 20-03-19
 * Time: 9:35 AM
 */

namespace WACVP\Inc\Execute;

use WACVP\Inc\Query_DB;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Guest {

	protected static $instance = null;

	public $query;

	private function __construct() {

		$this->query = Query_DB::get_instance();

		add_action( 'wp_ajax_nopriv_wacv_ajax', array( $this, 'wacv_ajax' ) );

		add_action( 'wp_ajax_wacv_ajax', array( $this, 'wacv_ajax' ) );

		add_action( 'woocommerce_after_checkout_billing_form', array( $this, 'enqueue_file' ) );

		add_filter( 'woocommerce_checkout_fields', array( $this, 'guest_checkout_fields' ) );

	}

	public static function get_instance() {

		// If the single instance hasn't been set, set it now.
		if ( null == self::$instance ) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	public function enqueue_file() {
		wp_enqueue_script( WACVP_SLUG . '-get-guest-info', WACVP_JS . 'get-guest-info.js', array( 'jquery' ), '', true );
		wp_localize_script( WACVP_SLUG . '-get-guest-info', 'wacv_localize', array( 'ajax_url' => admin_url( 'admin-ajax.php?action=wacv_ajax' ) ) );
	}

	public function wacv_ajax() {

		if ( isset( $_POST['param'] ) && $_POST['param'] == 'get_info' ) {
			if ( ! is_user_logged_in() ) {
				global $woocommerce;
				if ( session_id() == '' ) {
					session_start();
				}
//				WC()->initialize_session();
				WC()->session->set_customer_session_cookie( true );

				$guest_info = array();
				$patterns   = array(
					'billing_first_name',
					'billing_last_name',
					'billing_company',
					'billing_address_1',
					'billing_address_2',
					'billing_city',
					'billing_state',
					'billing_postcode',
					'billing_country',
					'billing_phone',
					'billing_email',
					'order_notes',
					'shipping_first_name',
					'shipping_last_name',
					'shipping_company',
					'shipping_address_1',
					'shipping_address_2',
					'shipping_city',
					'shipping_state',
					'shipping_postcode',
					'shipping_country',
					'ship_to_billing',
					'user_ref'
				);
				foreach ( $_POST as $key => $value ) {
					if ( in_array( $key, $patterns ) && $_POST[ $key ] != '' ) {
						$guest_info[ $key ] = sanitize_text_field( $_POST[ $key ] );
					}
				}

				$this->query::set_session( 'guest_info', $guest_info );

				$email_address = $this->query::get_session( 'guest_info' )['billing_email'];
				$email_address = $email_address ? $email_address : $guest_info['billing_email'];
				$user_ref      = $this->query::get_session( 'guest_info' )['user_ref'];
				$user_ref      = $user_ref ? $user_ref : $guest_info['user_ref'];


				if ( is_email( $email_address ) || ! empty( $user_ref ) ) {

					if ( $this->query::get_session( 'user_id' ) ) {
						$user_id      = $this->query::get_session( 'user_id' );
						$update_guest = $this->query->update_guest_info( $user_id, $guest_info );
						$cookie_cond  = $update_guest ? true : false;
					} else {
						$user_id = $this->query->insert_guest_info( $guest_info );
					}

					$this->query::set_session( 'user_id', $user_id );

					if ( $email_address ) {
						$guests = $this->query->get_guest_info_rows( $email_address );
						if ( $guests ) {
							foreach ( $guests as $guest ) {
								if ( count( $this->query->get_guest_same_email( $guest->id, 0 ) ) ) {
									if ( $guest->id == $user_id ) {
										continue;
									}
									$this->query->update_abd_cart_record(
										array( 'cart_ignored' => 1 ),
										array( 'user_id' => $guest->id, 'user_type' => 'guest' )
									);
								}
							}
						}
					}

					if ( ! empty( $user_id ) ) {

						$current_time = current_time( 'timestamp' );

						$results = $this->query->get_abd_cart_records( $user_id, 'guest' ); //select record with cart_ignore = 0

						if ( function_exists( 'WC' ) ) {
							$cart['cart'] = WC()->session->cart;
						} else {
							$cart['cart'] = $woocommerce->session->cart;
						}

						$updated_cart_info = json_encode( $cart );

						$get_cookie = WC()->session->get_session_cookie();

						if ( count( $results ) == 0 ) {

							if ( '' != $get_cookie[0] ) { //'on' == $track_guest_user_cart_from_cart && bat option cho phep ghi lai cart voi guest

								$results = $this->query->get_abd_guest_cart_record_like_session_id( $get_cookie[0] );

								if ( 0 == count( $results ) ) {
									if ( '[]' != $updated_cart_info && '{"cart":[]}' != $updated_cart_info ) {
										$insert_id = $this->query->insert_abd_cart_record( array(
											'user_id'             => $user_id,
											'abandoned_cart_info' => $updated_cart_info,
											'abandoned_cart_time' => $current_time,
											'user_type'           => 'guest',
											'session_id'          => $get_cookie[0]
										) );

										$this->query::set_session( 'wacv_cart_record_id', $insert_id );
									}
								} else {
									$this->query->update_abd_cart_record(
										array(
											'user_id'             => $user_id,
											'abandoned_cart_info' => $updated_cart_info,
											'abandoned_cart_time' => $current_time
										),
										array( 'session_id' => $get_cookie[0], 'cart_ignored' => 0 )
									);

									$row = $this->query->get_abd_cart_records( $user_id, 'guest' );
									if ( count( $row ) ) {
										$this->query::set_session( 'wacv_cart_record_id', $row[0]->id );
									}
								}
							}
						}

						$this->query->update_cart_log( array( 'user_id' => $user_id ), array( 'user_id' => $get_cookie[0] ) );
					}
				}
//				\WC_AJAX:: get_refreshed_fragments();
//				WC()->session->save_data();
			} else {
				if ( isset( $_POST['user_ref'] ) ) {
					$user_ref        = sanitize_text_field( $_POST['user_ref'] );
					$user_id         = get_current_user_id();
					$update_usermeta = update_user_meta( $user_id, 'wacv_user_ref', $user_ref );
					$guest_info      = array( 'user_ref' => $user_ref );
					$this->query::set_session( 'guest_info', $guest_info );
					$cookie_cond = $update_usermeta ? true : false;
				}
			}
//			if ( $cookie_cond ) {
//				setcookie( 'wacv_messenger_checkbox', DAY_IN_SECONDS );
//			}
		}

		wp_die();
	}


	public function guest_checkout_fields( $fields ) {
		$guest_info = $this->query::get_session( 'guest_info' );
		if ( isset( $guest_info ) ) {
			if ( ! empty( $guest_info['billing_email'] ) ) {
				$_POST['billing_email'] = esc_html( $guest_info['billing_email'] );
			}
			if ( ! empty( $guest_info['billing_first_name'] ) ) {
				$_POST['billing_first_name'] = esc_html( $guest_info['billing_first_name'] );
			}
			if ( ! empty( $guest_info['billing_last_name'] ) ) {
				$_POST['billing_last_name'] = esc_html( $guest_info['billing_last_name'] );
			}
			if ( ! empty( $guest_info['billing_phone'] ) ) {
				$_POST['billing_phone'] = esc_html( $guest_info['billing_phone'] );
			}
			if ( ! empty( $guest_info['billing_address_1'] ) ) {
				$_POST['billing_address_1'] = esc_html( $guest_info['billing_address_1'] );
			}
			if ( ! empty( $guest_info['billing_city'] ) ) {
				$_POST['billing_city'] = esc_html( $guest_info['billing_city'] );
			}
		}

		return $fields;
	}
}

