'use strict';
jQuery(document).ready(function ($) {

    const wacvGetInfor = {
        atcButton: '',

        init: function () {
            this.showPopup();
            this.chooseAction();
        },

        showPopup: function () {
            $('.single_add_to_cart_button, .ajax_add_to_cart').on('click', function (e) {
                if ($(this).hasClass('disabled')) {
                    return;
                }
                if (!window.getCookie('wacv_get_email')) {
                    e.stopImmediatePropagation();
                    e.preventDefault();
                    wacvGetInfor.atcButton = $(this);
                    $('#wacv-modal').fadeIn(300);
                    window.connectFB.run();
                }
            });
        },

        chooseAction: function () {
            $('.wacv-add-to-cart-btn').on('click', function () {
                wacvGetInfor.confirmOptIn();
                let email = $('.wacv-popup-input-email').val();
                if (emailIsValid(email)) {
                    wacvGetInfor.importEmail();
                } else if (!window.cbStt) {
                    $('.wacv-email-invalid-notice').show();
                }
            });

            $('.wacv-close-popup').on('click', function () { //, .wacv-modal-get-email
                window.setCookie('wacv_get_email', true, wacv_php_js.dismissDelay);//wacv_php_js.dismissDelay
                $('#wacv-modal').fadeOut(200);
                wacvGetInfor.addToCart();
            });
        },

        confirmOptIn: function () {
            if (window.cbStt) {
                window.confirmOptin.run();
                // this.importUserRef();
                wacvGetInfor.addToCart();
            }
        },

        addToCart: function () {
            if ($('.wbs-ajax-add-to-cart').length) {
                boostSaleATC();
            } else {
                ajax_add_to_cart(this.atcButton);
            }
        },

        importEmail: function () {
            var email = $('.wacv-popup-input-email').val();
            var data = {billing_email: email, action: 'wacv_ajax', param: 'get_info'};
            $.ajax({
                url: wacv_php_js.ajax_url,
                data: data,
                type: "post",
                success: function (res) {
                    // console.log(res);
                    $('#wacv-modal').fadeOut(200);
                    window.setCookie('wacv_get_email', true, 24 * 60 * 60);
                    wacvGetInfor.addToCart();
                },
                error: function (res) {
                    // console.log(res);
                }
            });
        },


    };

    wacvGetInfor.init();


    function emailIsValid(email) {
        return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email)
    }

    function ajax_add_to_cart(el) {
        var $form = el.closest('form.cart'), id = el.val(), data;

        if ($form.length > 0) {
            data = {
                action: 'woocommerce_ajax_add_to_cart',
                product_id: $form.find('input[name=product_id]').val() || id,
                'add-to-cart': $form.find('input[name=product_id]').val() || id,
                product_sku: '',
                quantity: $form.find('input[name=quantity]').val(),
                variation_id: $form.find('input[name=variation_id]').val() || 0,
            };
        } else {
            data = {
                action: 'woocommerce_ajax_add_to_cart',
                product_id: el.attr('data-product_id'),
                'add-to-cart': el.attr('data-product_id'),
                product_sku: '',
                quantity: el.attr('data-quantity'),
                variation_id: 0,
            };
        }

        $(document.body).trigger('adding_to_cart', [el, data]);
        $.ajax({
            type: 'post',
            url: wacv_php_js.ajax_url,
            data: data,
            beforeSend: function (response) {
                el.removeClass('added').addClass('loading');
            },
            complete: function (response) {
                el.addClass('added').removeClass('loading');
            },
            success: function (response) {
                // console.log(response);
                if (response.error && response.product_url) {
                    window.location = response.product_url;
                    return;
                } else {
                    $(document.body).trigger('added_to_cart', [response.fragments, response.cart_hash, el]);
                    if (wacv_php_js.redirect === 'to_cart_page') {
                        window.location.replace(wacv_php_js.cartPage);
                    } else if (wacv_php_js.redirect === 'to_checkout_page') {
                        window.location.replace(wacv_php_js.checkoutPage);
                    }
                }
            },
        });
        return false;
    }

    function boostSaleATC() {
        var button = $('.wbs-ajax-add-to-cart');
        var variation = button.closest('.cart').find('[name="variation_id"]');
        if (variation.length > 0) {
            if (parseInt(variation.val()) < 1 || !variation.val()) {
                return;
            }
        }
        button.addClass('loading');
        var form_data = button.closest('.cart').serialize();
        button.closest('form').find('.added_to_cart').remove();
        $.ajax({
            type: 'POST',
            data: 'action=wbs_ajax_add_to_cart&' + form_data,
            url: wacv_php_js.ajax_url,
            success: function (response) {
                if (response) {
                    if (response.html) {
                        var wbs_notices = $('.wbs-add-to-cart-notices-ajax').html();
                        $('.wbs-add-to-cart-notices-ajax').html(wbs_notices + response.html);
                    }
                    if (response.hasOwnProperty('variation_image_url') && response.variation_image_url) {
                        $('#wbs-content-upsells').find('.wbs-p-image').find('img').attr('src', response.variation_image_url);
                    }
                    if (response.hasOwnProperty('total') && response.total) {
                        $('#wbs-content-upsells').find('.wbs-current_total_cart').html(response.total);
                    }
                }
                button.after(' <a href="' + wacv_php_js.cartPage + '" class="added_to_cart wc-forward" title="' +
                    wacv_php_js.i18n_view_cart + '">' + wacv_php_js.i18n_view_cart + '</a>');
                refresh_cart_fragment();
                button.removeClass('loading');
                button.addClass('added');
            },
            error: function (html) {
                button.removeClass('loading');
            }
        });
    }

    function refresh_cart_fragment() {
        $(document.body).trigger('wc_fragment_refresh');
    }

});
