<?php

/**
 * Fired when the plugin is uninstalled.
 *
 * @since    1.0
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' )){
	exit;
}

//Deletes database table and all it's data on uninstall
global $wpdb;

$cart_table = $wpdb->prefix . "cartbounty_pro";
$product_table = $wpdb->prefix . "cartbounty_pro_products";
$product_coupons = $wpdb->prefix . "cartbounty_pro_coupons";
$email_table = $wpdb->prefix . "cartbounty_pro_emails";
$message_table = $wpdb->prefix . "cartbounty_pro_messages";
$notification_table = $wpdb->prefix . "cartbounty_pro_notifications";

$wpdb->query( "DROP TABLE IF EXISTS $cart_table" );
$wpdb->query( "DROP TABLE IF EXISTS $product_table" );
$wpdb->query( "DROP TABLE IF EXISTS $product_coupons" );
$wpdb->query( "DROP TABLE IF EXISTS $email_table" );
$wpdb->query( "DROP TABLE IF EXISTS $message_table" );
$wpdb->query( "DROP TABLE IF EXISTS $notification_table" );

//Removing Custom options created with the plugin
delete_option( 'cartbounty_pro_main_settings' );
delete_option( 'cartbounty_pro_misc_settings' );
delete_option( 'cartbounty_pro_mailchimp_settings' );
delete_option( 'cartbounty_pro_mailchimp_coupon' );
delete_option( 'cartbounty_pro_mailchimp_exclusions' );
delete_option( 'cartbounty_pro_activecampaign_settings' );
delete_option( 'cartbounty_pro_activecampaign_coupon' );
delete_option( 'cartbounty_pro_activecampaign_exclusions' );
delete_option( 'cartbounty_pro_getresponse_settings' );
delete_option( 'cartbounty_pro_getresponse_coupon' );
delete_option( 'cartbounty_pro_getresponse_exclusions' );
delete_option( 'cartbounty_pro_bulkgate_settings' );
delete_option( 'cartbounty_pro_bulkgate_steps' );
delete_option( 'cartbounty_pro_bulkgate_tcpa_gdpr' );
delete_option( 'cartbounty_pro_bulkgate_sends' );
delete_option( 'cartbounty_pro_bulkgate_clicks' );
delete_option( 'cartbounty_pro_bulkgate_exclusions' );
delete_option( 'cartbounty_pro_automation_settings' );
delete_option( 'cartbounty_pro_automation_steps' );
delete_option( 'cartbounty_pro_automation_sends' );
delete_option( 'cartbounty_pro_automation_opens' );
delete_option( 'cartbounty_pro_automation_clicks' );
delete_option( 'cartbounty_pro_automation_exclusions' );
delete_option( 'cartbounty_pro_push_notification_settings' );
delete_option( 'cartbounty_pro_push_notification_steps' );
delete_option( 'cartbounty_pro_push_notification_sends' );
delete_option( 'cartbounty_pro_push_notification_sends_failed' );
delete_option( 'cartbounty_pro_push_notification_clicks' );
delete_option( 'cartbounty_pro_push_notification_vapid_keys' );
delete_option( 'cartbounty_pro_push_notification_exclusions' );
delete_option( 'cartbounty_pro_exit_intent_settings' );
delete_option( 'cartbounty_pro_exit_intent_coupon' );
delete_option( 'cartbounty_pro_early_capture_settings' );
delete_option( 'cartbounty_pro_early_capture_coupon' );
delete_option( 'cartbounty_pro_tab_notification_settings' );
delete_option( 'cartbounty_pro_webhook_url' );
delete_option( 'cartbounty_pro_webhook_coupon' );
delete_option( 'cartbounty_pro_webhook_exclusions' );
delete_option( 'cartbounty_pro_submitted_notices' );
delete_option( 'cartbounty_pro_submitted_warnings' );
delete_option( 'cartbounty_pro_report_settings' );

delete_metadata( 'user', 0, 'cartbounty_pro_carts_per_page', '', true );
delete_metadata( 'user', 0, 'cartbounty_pro_expired_notice', '', true );