<?php
/**
 * The template for displaying CartBounty Pro Push notification permission request
 *
 * This template can be overridden by copying it to 
 * yourtheme/templates/cartbounty-pro-push-notification-request.php or
 * yourtheme/cartbounty-pro-push-notification-request.php

 * Please do not change the ID "cartbounty-pro-push-notification-request".
 * If changed, the abandoned cart will not be captured
 *
 * If a new CartBounty Pro version is released with an updated template file, you
 * may need to replace the old template file with the new one to maintain compatibility.
 * 
 * @package    CartBounty Pro - Save and recover abandoned carts for WooCommerce/Templates
 * @author     Streamline.lv
 * @version    9.10
 */

if (!defined( 'ABSPATH' )) exit; //Don't allow direct access
?>

<div id="cartbounty-pro-push-notification-permission" class="<?php echo esc_attr( $this->notification_permission_style() ); ?>">
	<div id="cartbounty-pro-push-notification-permission-container" style="background-color:<?php echo esc_attr( $args['main_color'] ); ?>">
		<div id="cartbounty-pro-push-notification-permission-close">
			<?php echo apply_filters( 'cartbounty_pro_push_notification_permission_close_html', sprintf('<svg><line x1="1" y1="11" x2="11" y2="1" stroke="%s" stroke-width="2"/><line x1="1" y1="1" x2="11" y2="11" stroke="%s" stroke-width="2"/></svg>', esc_attr( $args['inverse_color'] ), esc_attr( $args['inverse_color'] ) ) ); ?>
		</div>
		<div id="cartbounty-pro-push-notification-permission-content">
			<?php do_action('cartbounty_pro_push_notification_permission_start'); ?>
			<div id="cartbounty-pro-push-notification-permission-content-l">
				<?php echo wp_kses_post( apply_filters( 'cartbounty_pro_push_notification_permission_image_html', sprintf('<img src="%s"/>', esc_url( $args['image_url'] ) ) ) ); ?>
			</div>
			<div id="cartbounty-pro-push-notification-permission-content-r">
				<?php echo wp_kses_post( apply_filters( 'cartbounty_pro_push_notification_permission_title_html', sprintf(
					'<h2 style="color: %s">%s</h2>', esc_attr( $args['inverse_color'] ), $args['heading'] ) ) ); ?>
				<?php do_action('cartbounty_pro_push_notification_permission_after_title'); ?>
				<?php echo wp_kses_post( apply_filters( 'cartbounty_pro_push_notification_permission_description_html', sprintf(
					'<p style="color: %s">%s</p>', esc_attr( $args['inverse_color'] ), $args['content'] ) ) ); ?>
			</div>
			<div id="cartbounty-pro-push-notification-permission-content-buttons">
				<?php echo wp_kses_post( apply_filters( 'cartbounty_pro_push_notification_permission_button_html', sprintf( '<button type="button" id="cartbounty-pro-push-notification-permission-submit" class="button" style="background-color: %s; color: %s">%s</button>', esc_attr__( $args['inverse_color'] ), esc_attr__( $args['main_color'] ), esc_html__( 'Continue', 'woo-save-abandoned-carts' ) ) ) ); ?>
				<a id="cartbounty-pro-push-notification-permission-request-deny" href="#" title="<?php echo esc_html__( 'Maybe later', 'woo-save-abandoned-carts' ); ?>"><?php echo esc_html__( 'Maybe later', 'woo-save-abandoned-carts' ); ?></a>
			</div>
			<?php do_action('cartbounty_pro_push_notification_permission_end'); ?>
		</div>
	</div>
	<div id="cartbounty-pro-push-notification-permission-backdrop" style="background-color:<?php echo esc_attr( $args['inverse_color'] ); ?>; opacity: 0;"></div>
</div>