<?php
/**
 * The template for displaying CartBounty Pro Exit Intent form
 *
 * This template can be overridden by copying it to 
 * yourtheme/templates/cartbounty-pro-exit-intent.php or
 * yourtheme/cartbounty-pro-exit-intent.php

 * Please do not change the ID "cartbounty-pro-exit-intent-email" or "cartbounty-pro-exit-intent-phone".
 * If changed, the abandoned cart will not be captured
 *
 * If a new CartBounty Pro version is released with an updated template file, you
 * may need to replace the old template file with the new one to maintain compatibility.
 * 
 * @package    CartBounty Pro - Save and recover abandoned carts for WooCommerce/Templates
 * @author     Streamline.lv
 * @version    10.4
 */

if (!defined( 'ABSPATH' )){ //Don't allow direct access
	exit;
}?>

<div id="cartbounty-pro-exit-intent-form" class="<?php echo esc_attr( $this->exit_intent_style() ) . " " . esc_attr( $args['type'] ); ?>">
	<div id="cartbounty-pro-exit-intent-form-container" style="background-color:<?php echo esc_attr( $args['main_color'] ); ?>">
		<div id="cartbounty-pro-exit-intent-close">
			<?php echo apply_filters( 'cartbounty_pro_exit_intent_close_html', sprintf('<svg><line x1="1" y1="11" x2="11" y2="1" stroke="%s" stroke-width="2"/><line x1="1" y1="1" x2="11" y2="11" stroke="%s" stroke-width="2"/></svg>', esc_attr( $args['inverse_color'] ), esc_attr( $args['inverse_color'] ) ) ); ?>
		</div>
		<div id="cartbounty-pro-exit-intent-form-content">
			<?php do_action('cartbounty_pro_exit_intent_start'); ?>
			<div id="cartbounty-pro-exit-intent-form-content-l">
				<?php echo wp_kses_post( apply_filters( 'cartbounty_pro_exit_intent_image_html', sprintf('<img src="%s" title="%s" alt="%s"/>', esc_url( $args['image_url'] ), esc_attr( $args['title'] ), esc_attr( $args['alt'] ) ) ) ); ?>
			</div>
			<div id="cartbounty-pro-exit-intent-form-content-r">
				<?php echo wp_kses_post( apply_filters( 'cartbounty_pro_exit_intent_title_html', sprintf(
					'<h2 style="color: %s">%s</h2>', esc_attr( $args['inverse_color'] ), $args['heading'] ) ) ); ?>
				<?php do_action('cartbounty_pro_exit_intent_after_title'); ?>
				<?php echo wp_kses_post( apply_filters( 'cartbounty_pro_exit_intent_description_html', sprintf(
					'<p style="color: %s">%s</p>', esc_attr( $args['inverse_color'] ), $args['content'] ) ) );?>
				<form>
					<?php do_action('cartbounty_pro_exit_intent_before_form_fields'); ?>
					<?php if($args['type'] == 'phone-and-email'):
						echo apply_filters( 'cartbounty_pro_exit_intent_field_html', '<input type="email" id="cartbounty-pro-exit-intent-email" required placeholder="'. esc_attr__('Enter your email', 'woo-save-abandoned-carts') .'">' );
						echo apply_filters( 'cartbounty_pro_exit_intent_field_html', '<p class="cartbounty-pro-international"><input type="tel" id="cartbounty-pro-exit-intent-phone" required placeholder="'. esc_attr__('Your phone', 'woo-save-abandoned-carts') .'"></p>' );
					elseif($args['type'] == 'phone'):
						echo apply_filters( 'cartbounty_pro_exit_intent_field_html', '<p class="cartbounty-pro-international"><input type="tel" id="cartbounty-pro-exit-intent-phone" required placeholder="'. esc_attr__('Your phone', 'woo-save-abandoned-carts') .'"></p>' );
					else: 
						echo apply_filters( 'cartbounty_pro_exit_intent_field_html', '<input type="email" id="cartbounty-pro-exit-intent-email" required placeholder="'. esc_attr__('Enter your email', 'woo-save-abandoned-carts') .'">' );
					endif;?>
					
					<?php echo wp_kses_post( apply_filters( 'cartbounty_pro_exit_intent_button_html', sprintf('<button type="submit" name="cartbounty-pro-exit-intent-submit" id="cartbounty-pro-exit-intent-submit" class="button" value="submit" style="background-color: %s; color: %s">%s</button>', esc_attr__( $args['inverse_color'] ), esc_attr__( $args['main_color'] ), esc_html__('Save', 'woo-save-abandoned-carts') ) ) ); ?>
					<?php if( $args['consent_enabled'] ){
							echo wp_kses_post( apply_filters( 'cartbounty_pro_exit_intent_consent', sprintf(
							'<p id="cartbounty-pro-exit-intent-consent" style="color: %s">%s</p>', esc_attr( $args['inverse_color'] ), $args['tools_consent'] ) ) );
					}?>
				</form>
			</div>
			<?php do_action('cartbounty_pro_exit_intent_end'); ?>
		</div>
	</div>
	<div id="cartbounty-pro-exit-intent-form-backdrop" style="background-color:<?php echo esc_attr( $args['inverse_color'] ); ?>; opacity: 0;"></div>
</div>