﻿<?php
/**
 * The template for displaying CartBounty Pro Early capture form
 *
 * This template can be overridden by copying it to 
 * yourtheme/templates/cartbounty-pro-early-capture.php or
 * yourtheme/cartbounty-pro-early-capture.php

 * Please do not change the ID "cartbounty-pro-early-capture-email" or "cartbounty-pro-early-capture-phone".
 * If changed, the abandoned cart will not be captured
 *
 * If a new CartBounty Pro version is released with an updated template file, you
 * may need to replace the old template file with the new one to maintain compatibility.
 * 
 * @package    CartBounty Pro - Save and recover abandoned carts for WooCommerce/Templates
 * @author     Streamline.lv
 * @version    10.4
 */

if (!defined( 'ABSPATH' )){ //Don't allow direct access
	exit;
}?>

<div id="cartbounty-pro-early-capture-form" class="<?php echo esc_attr( $args['style'] ); ?>">
	<div id="cartbounty-pro-early-capture-form-content" style="background-color:<?php echo esc_attr( $args['main_color'] ); ?>">
		<div class="cartbounty-pro-triangle" style="color:<?php echo esc_attr( $args['main_color'] ); ?>">▲</div>
		<div id="cartbounty-pro-early-capture-form-content-top">
			<?php 
			$label = 'cartbounty-pro-early-capture-email';
			if($args['type'] == 'phone'){
				$label = 'cartbounty-pro-early-capture-phone';
			}
			echo wp_kses_post( apply_filters( 'cartbounty_pro_early_capture_label_html', sprintf('<label for="%s" style="color: %s">%s</label>', esc_attr( $label ), esc_attr( $args['inverse_color'] ), $args['heading'] ) ) );
			?><span id="cartbounty-pro-early-capture-close">
				<?php echo apply_filters( 'cartbounty_pro_early_capture_close_html', sprintf('<svg><line x1="1" y1="11" x2="11" y2="1" stroke="%s" stroke-width="2"/><line x1="1" y1="1" x2="11" y2="11" stroke="%s" stroke-width="2"/></svg>', esc_attr( $args['inverse_color'] ), esc_attr( $args['inverse_color'] ) ) ); ?>
			</span>
			<?php do_action('cartbounty_pro_early_capture_after_title'); ?>
		</div>
		<form onsubmit="return false">
			<?php do_action('cartbounty_pro_early_capture_before_form_fields'); ?>
			<?php if($args['type'] == 'phone'):
				echo apply_filters( 'cartbounty_pro_early_capture_field_html', '<p class="cartbounty-pro-international"><input type="tel" id="cartbounty-pro-early-capture-phone" required placeholder="'. esc_attr__('Your phone', 'woo-save-abandoned-carts') .'"></p>');
			else:
				echo apply_filters( 'cartbounty_pro_early_capture_field_html', '<input type="email" id="cartbounty-pro-early-capture-email" required placeholder="'. esc_attr__('Enter your email', 'woo-save-abandoned-carts') .'">');
			endif;
			echo  apply_filters( 'cartbounty_pro_early_capture_button_html', sprintf('<button type="submit" name="cartbounty-pro-early-capture-submit" id="cartbounty-pro-early-capture-submit" class="button" value="submit" style="background-color: %1$s; color: %2$s"><div class="cartbounty-pro-ec-loader"><div style="background-color: %2$s;"></div><div style="background-color: %2$s;"></div><div style="background-color: %2$s;"></div><div style="background-color: %2$s;"></div></div><em>%3$s</em><svg style="fill: %2$s;" viewBox="0 0 37.51 34.8"><path d="M22.05,32a5.92,5.92,0,0,1-9.16,1.12L1.18,18.28a4,4,0,0,1,0-5.67l1.89-1.9a4,4,0,0,1,5.67,0L17,20.93,28.62,1.79a3.71,3.71,0,0,1,5.5-1l1.55,1.25A4.91,4.91,0,0,1,36.76,8.5Z"/></svg></button>', esc_attr( $args['inverse_color'] ), esc_attr( $args['main_color'] ), esc_html__('Save', 'woo-save-abandoned-carts') ) );?>
			<?php if($args['consent_enabled']){
				echo wp_kses_post( apply_filters( 'cartbounty_pro_early_capture_consent', sprintf(
				'<p id="cartbounty-pro-early-capture-consent" style="color: %s">%s</p>', esc_attr( $args['inverse_color'] ), $args['tools_consent'] ) ) );
			}?>
		</form>
	</div>
	<div id="cartbounty-pro-early-capture-form-backdrop" style="background-color:<?php echo esc_attr( $args['inverse_color'] ); ?>;"></div>
</div>