(function($){
	'use strict';
	 
	jQuery(document).ready(function(){
		var check_empty_cart = cartbounty_tn.check_cart;
		var page_title = document.title;
		var message = cartbounty_tn.message;
		var interval = cartbounty_tn.interval;
		var flicker_event = null;
		var new_favicon = cartbounty_tn.favicon;
		var favicons = getFavicons();

		checkTab();
		
		document.addEventListener('visibilitychange', function(event){
			checkTab();
		});

		function checkTab(){ //Checking is Browser tab is active or not
			var isPageActive = !document.hidden;
			var product_count = cartbounty_tn.product_count; //Products in the shopping cart
			
			if(check_empty_cart){
				
				if(product_count == 0){
					return;
				}
			}

			if(!isPageActive){
				flicker();

			}else{
				document.title = page_title;
				restoreFavicons();
				clearInterval(flicker_event);
			}
		}

		function flicker(){ //Change Browser tab content according to provided Interval speed
			flicker_event = setInterval(function(){

				if(document.title === message){
					document.title = page_title;
					restoreFavicons();

				}else{
					document.title = message;
					changeFavicons();
				}
			}, interval);
		}

		function increaseCount(){ //Increase product count inside shopping cart
			cartbounty_tn.product_count = parseInt(cartbounty_tn.product_count) + 1; //Updating product count in cart data variable once Add to Cart button is pressed
		}

		function checkEmptyCart(){ //Check if cart is empty in case product removed from cart
			var data = {
				action:	"check_empty_cart"
			}
			
			jQuery.post(cartbounty_co.ajaxurl, data,
			function(response){

				if(response.data == 'true'){
					cartbounty_tn.product_count = 0;
				}
			}); 
		}

		function getFavicons(){ //Build an array of original favicons defined by "rel" attribute
			
			if(!cartbounty_tn.favicon_enabled ){
				return;
			}

			var favicons = [];
			var nodeList = document.getElementsByTagName("link");
			var favicon_relationship = cartbounty_tn.favicon_relationship.split(',');

			for (var i = 0; i < nodeList.length; i++){ //Going through all link tags

				for (var j = favicon_relationship.length - 1; j >= 0; j--) { //Going through all relationship attributes we have defined

					if( (nodeList[i].getAttribute("rel") == favicon_relationship[j].trim()) ){ //If we find that link tag element has relationship we are looking for (default - icon or favicon), we add element to Favicons array including original link to icon image
						favicons.push([
							nodeList[i],
							nodeList[i].getAttribute("href")
						] );
					}
				}
			}

			return favicons;
		}

		function changeFavicons(){ //Replace original favicon images with the new one
			
			if(!cartbounty_tn.favicon_enabled ){
				return;
			}

			for (var i = favicons.length - 1; i >= 0; i--) {
				favicons[i][0].setAttribute( 'href', new_favicon );
			}
		}

		function restoreFavicons(){ //Restore back original favicon images

			if(!cartbounty_tn.favicon_enabled ){
				return;
			}

			for (var i = favicons.length - 1; i >= 0; i--) {
				favicons[i][0].setAttribute( 'href', favicons[i][1] );
			}
		}

		jQuery(document).on('added_to_cart', increaseCount );
		jQuery(document).on('removed_from_cart', checkEmptyCart );
	});

})(jQuery);