self.addEventListener('install', event => {
	self.skipWaiting()
})

self.addEventListener('notificationclick', event => {
	const url = event.notification.data.url;
	event.notification.close();
	event.waitUntil(openWindow(url));
})

self.addEventListener('push', async (event) => {
	event.waitUntil(getContent(event).then(data => {
		const title = data.title
		const options = data.options
		self.registration.showNotification(title, options)
		return Promise.resolve()
	}).catch(err => {
		console.log('Error receiving push notification', err);
	}))
})

const getContent = async (event) => {
	if (!event.data) {
		return Promise.reject('No payload was sent in the push message');
	}
	const data = event.data.json()
	return Promise.resolve(data)
}

const openWindow = (url) => {
	clients.openWindow(url)
	return Promise.resolve()
}