<?php
/**
 * The TranslatePress class.
 *
 * Takes care of synamic content translations for TranslatePress
 *
 *
 * @since      10.1.2
 * @package    CartBounty Pro - Save and recover abandoned carts for WooCommerce
 * @subpackage CartBounty Pro - Save and recover abandoned carts for WooCommerce/includes
 * @author     Streamline.lv
 */
class CartBounty_Pro_TranslatePress{

	/**
	 * Method checks if TranslatePress is active
	 *
	 * @since    10.1.2
	 * @return   boolean
	 */
	function is_trp_active(){
		$result = false;

		if( function_exists( 'trp_translate' ) ){
			$result = true;
		}

		return $result;
	}

	/**
	 * Method added to provide compatibility with TranslatePress
	 *
	 * @since    10.1.2
	 * @return   String
	 * @param    String   $locale     WordPress language
	 */
	function maybe_translate_trp( $string ){

		if( $this->is_trp_active() ){
			$string = trp_translate( $string, get_locale(), $prevent_over_translation = false );
		}

		return $string;
	}

	/**
	 * Method provided by TranslatePress documentation helping retrieve language specific URL's
	 *
	 * @since    10.1.2
	 * @return   string
	 * @param    string     $language   	User's language code, e.g. 'de_DE'
	 * @param    string     $url   		    URL
	 */
	function get_trp_language_specific_url( $url, $language = '' ){
		
		if( class_exists( 'TRP_Translate_Press' ) ){
			$trp = TRP_Translate_Press::get_trp_instance();
			$url_converter = $trp->get_component( 'url_converter' );
			$url = esc_url( $url_converter->get_url_for_language( $language, $url, '' ) );
		}

		return $url;
	}
}