<?php
/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0
 * @package    CartBounty Pro - Save and recover abandoned carts for WooCommerce
 * @subpackage CartBounty Pro - Save and recover abandoned carts for WooCommerce/includes
 * @author     Streamline.lv
 */
class CartBounty_Pro_Deactivator{

	/**
	 * Deactivation function
	 *
	 * @since    1.1
	 */
	public static function deactivate() {
		$admin = new CartBounty_Pro_Admin( CARTBOUNTY_PRO_PLUGIN_NAME_SLUG, CARTBOUNTY_PRO_VERSION_NUMBER );
		$hooks = array(
			'cartbounty_pro_sync_hook',
			'cartbounty_pro_notification_sendout_hook',
			'cartbounty_pro_remove_empty_carts_hook',
			'cartbounty_pro_delete_anonymous_carts_hook',
			'cartbounty_pro_delete_coupons_hook',
		);

		foreach( $hooks as $key => $hook ){

			if( $admin->action_scheduler_enabled() ){ //If WooCommerce Action scheduler library exists
				as_unschedule_action( $hook, array(), CARTBOUNTY_PRO ); //Deactivating scheduled Action Scheduler actions

			}else{ //Fallback to WP Cron and clear these events
				wp_clear_scheduled_hook( $hook ); //Deactivating scheduled WP Cron actions
			}
		}

		$admin->delete_cartbounty_transient( 'getresponse_api_times_failed' );
		$admin->delete_cartbounty_transient( 'getresponse_api_invalid_until' );
		$admin->delete_cartbounty_transient( 'getresponse_valid_fingerprint' );
		$admin->delete_cartbounty_transient( 'getresponse_invalid_fingerprint' );
		$admin->delete_cartbounty_transient( 'mailchimp_api_times_failed' );
		$admin->delete_cartbounty_transient( 'mailchimp_api_invalid_until' );
		$admin->delete_cartbounty_transient( 'mailchimp_valid_fingerprint' );
		$admin->delete_cartbounty_transient( 'mailchimp_invalid_fingerprint' );
		$admin->delete_cartbounty_transient( 'webhook_api_times_failed' );
		$admin->delete_cartbounty_transient( 'webhook_api_invalid_until' );
		$admin->delete_cartbounty_transient( 'webhook_valid_fingerprint' );
		$admin->delete_cartbounty_transient( 'webhook_invalid_fingerprint' );
		$admin->delete_cartbounty_transient( 'bulkgate_api_times_failed' );
		$admin->delete_cartbounty_transient( 'bulkgate_api_invalid_until' );
		$admin->delete_cartbounty_transient( 'bulkgate_valid_fingerprint' );
		$admin->delete_cartbounty_transient( 'bulkgate_invalid_fingerprint' );
		$admin->delete_cartbounty_transient( 'activecampaign_api_times_failed' );
		$admin->delete_cartbounty_transient( 'activecampaign_api_invalid_until' );
		$admin->delete_cartbounty_transient( 'activecampaign_valid_fingerprint' );
		$admin->delete_cartbounty_transient( 'activecampaign_invalid_fingerprint' );
		$admin->delete_cartbounty_transient( 'activecampaign_external_store_id' );
		$admin->delete_cartbounty_transient( 'license_request_sent' );
		$admin->delete_cartbounty_transient( 'free_version_table_exists' );
	}
}