<?php
/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0
 * @package    CartBounty Pro - Save and recover abandoned carts for WooCommerce
 * @subpackage CartBounty Pro - Save and recover abandoned carts for WooCommerce/includes
 * @author     Streamline.lv
 */
 
class CartBounty_Pro_Activator{

	/**
	 * Creating table in the database
	 *
	 * @since    1.3
	 */
	public static function activate() {
		
		//Deactivating CartBounty plugin
		require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		deactivate_plugins('woo-save-abandoned-carts/cartbounty-abandoned-carts.php');
		
		/**
		* Creating table
		*/
		global $wpdb;
		
		$cart_table = $wpdb->prefix . CARTBOUNTY_PRO_TABLE_NAME;
		$old_cart_table = $wpdb->prefix . "captured_wc_fields_pro";
		$charset_collate = $wpdb->get_charset_collate();

		$sql = "CREATE TABLE $cart_table (
			id BIGINT(20) NOT NULL AUTO_INCREMENT,
			name VARCHAR(60),
			surname VARCHAR(60),
			email VARCHAR(100),
			phone VARCHAR(20),
			email_consent TINYINT DEFAULT 0,
			phone_consent TINYINT DEFAULT 0,
			location VARCHAR(100),
			cart_contents LONGTEXT,
			cart_hash CHAR(32) DEFAULT NULL,
			cart_meta LONGTEXT DEFAULT NULL,
			cart_total DECIMAL(10,2),
			currency VARCHAR(10),
			time DATETIME DEFAULT '0000-00-00 00:00:00',
			session_id VARCHAR(60),
			language VARCHAR(25),
			other_fields LONGTEXT,
			ip_address VARCHAR(100),
			mail_sent TINYINT NOT NULL DEFAULT 0,
			mc_synced TINYINT NOT NULL DEFAULT 0,
			mc_coupon_synced DATETIME DEFAULT '0000-00-00 00:00:00',
			mc_excluded TINYINT DEFAULT 0,
			last_synced DATETIME DEFAULT '0000-00-00 00:00:00',
			ac_last_synced DATETIME DEFAULT '0000-00-00 00:00:00',
			ac_contact_id INT DEFAULT 0,
			ac_customer_id INT DEFAULT 0,
			ac_cart_id INT DEFAULT 0,
			ac_excluded TINYINT DEFAULT 0,
			gr_last_synced DATETIME DEFAULT '0000-00-00 00:00:00',
			gr_contact_id VARCHAR(60),
			gr_cart_id VARCHAR(60),
			gr_excluded TINYINT DEFAULT 0,
			wp_unsubscribed TINYINT DEFAULT 0,
			wp_steps_completed INT(3) DEFAULT 0,
			wp_last_sent DATETIME DEFAULT '0000-00-00 00:00:00',
			wp_complete TINYINT DEFAULT 0,
			wp_excluded TINYINT DEFAULT 0,
			sms_unsubscribed TINYINT DEFAULT 0,
			sms_steps_completed INT(3) DEFAULT 0,
			sms_last_sent DATETIME DEFAULT '0000-00-00 00:00:00',
			sms_complete TINYINT DEFAULT 0,
			sms_excluded TINYINT DEFAULT 0,
			wh_last_synced DATETIME DEFAULT '0000-00-00 00:00:00',
			wh_excluded TINYINT DEFAULT 0,
			pn_subscription LONGTEXT,
			pn_steps_completed INT(3) DEFAULT 0,
			pn_last_sent DATETIME DEFAULT '0000-00-00 00:00:00',
			pn_complete TINYINT DEFAULT 0,
			pn_excluded TINYINT DEFAULT 0,
			coupons LONGTEXT,
			refferals LONGTEXT,
			paused TINYINT DEFAULT 0,
			restarts INT DEFAULT 0,
			type VARCHAR(10) DEFAULT 0,
			wc_order_id BIGINT(20) DEFAULT 0,
			saved_via VARCHAR(10),
			anonymized TINYINT DEFAULT 0,
			PRIMARY KEY (id)
		) $charset_collate;";

		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		dbDelta( $sql );
		
		/**
		* Resets table Auto increment index to 1
		*/
		$sql = "ALTER TABLE $cart_table AUTO_INCREMENT = 1";
		dbDelta( $sql );

		$admin = new CartBounty_Pro_Admin( CARTBOUNTY_PRO_PLUGIN_NAME_SLUG, CARTBOUNTY_PRO_VERSION_NUMBER );

		//Automatically import carts from the Free version on plugin activation / update
		$admin->import_carts();

		//Making sure that automated coupon deletion is enabled by default
		add_option( 'cartbounty_pro_main_settings', 
			array(
				'delete_coupons' 			=> 1, //Making sure that automated coupon deletion is enabled by default
				'magic_login_first_click' 	=> 1, //Making sure that Magic login on only first message click is enabled by default
			)
		);

		/**
		 * Since version 9.4.3
		 * This code will be removed in later versions
		 */
		if(get_option('cartbounty_pro_automation_sent_emails')){
			update_option('cartbounty_pro_automation_sends', get_option('cartbounty_pro_automation_sent_emails'));
			delete_option('cartbounty_pro_automation_sent_emails');
		}

		$misc_settings = $admin->get_settings( 'misc_settings' );

		if ( $misc_settings['wpml_strings_registered'] ){ //In order to automatically register new strings if we update CartBounty
			$misc_settings['wpml_strings_registered'] = false;
			update_option( 'cartbounty_pro_misc_settings', $misc_settings );
		}

		/**
		 * Since version 9.9.3
		 * Transferring time to milliseconds
		 * This code will be removed in later versions
		 */
		function transfer_time_to_milliseconds(){
			$admin = new CartBounty_Pro_Admin( CARTBOUNTY_PRO_PLUGIN_NAME_SLUG, CARTBOUNTY_PRO_VERSION_NUMBER );
			$misc_settings = $admin->get_settings( 'misc_settings' );

			//Since version 10.9.1
			//This code will be removed in later versions
			//Updating typo error
			if( isset( $misc_settings['converted_minutes_to_miliseconds'] ) ){
				$misc_settings['converted_minutes_to_milliseconds'] = true;
				unset( $misc_settings['converted_minutes_to_miliseconds'] );
				update_option( 'cartbounty_pro_misc_settings', $misc_settings );
				return;
			}

			if( CARTBOUNTY_PRO_VERSION_NUMBER == $misc_settings['version_number'] || empty( $misc_settings['version_number'] ) ){ //If this is a fresh install or plugin activation
				$misc_settings['converted_minutes_to_milliseconds'] = true;
				update_option( 'cartbounty_pro_misc_settings', $misc_settings ); //setting this variable as we do not require to convert minutes to milliseconds for new installs or activations
				return;
			}

			if( $misc_settings['converted_minutes_to_milliseconds'] ) return;

			$wordpress_steps = get_option( 'cartbounty_pro_automation_steps' );
			$bulkgate_steps = get_option( 'cartbounty_pro_bulkgate_steps' );
			$mailchimp_coupon = get_option( 'cartbounty_pro_mailchimp_coupon' );
			$getresponse_coupon = get_option( 'cartbounty_pro_getresponse_coupon' );
			$activecampaign_coupon = get_option( 'cartbounty_pro_activecampaign_coupon' );
			$webhook_coupon = get_option( 'cartbounty_pro_webhook_coupon' );
			$notification_frequency = get_option( 'cartbounty_pro_notification_frequency' );
			$tab_notification_interval = get_option( 'cartbounty_pro_tab_notification_interval' );

			//Converting WordPres recovery time intervals
			if( $wordpress_steps ){

				if( is_array( $wordpress_steps ) && !empty( $wordpress_steps ) ){
					foreach( $wordpress_steps as $key => $step ){
						
						if( isset( $wordpress_steps[$key]['interval'] ) ){
							$wordpress_steps[$key]['interval'] = $admin->convert_minutes_to_milliseconds( $step['interval'] );
						}

						if( isset( $wordpress_steps[$key]['coupon_expiry'] ) ){
							$wordpress_steps[$key]['coupon_expiry'] = $admin->convert_minutes_to_milliseconds( $step['coupon_expiry'] );
						}
					}
					update_option( 'cartbounty_pro_automation_steps', $wordpress_steps );
				}
			}

			//Converting BulkGate recovery time intervals
			if( $bulkgate_steps ){

				if( is_array( $bulkgate_steps ) && !empty( $bulkgate_steps ) ){
					foreach( $bulkgate_steps as $key => $step ) {

						if( isset( $bulkgate_steps[$key]['interval'] ) ){
							$bulkgate_steps[$key]['interval'] = $admin->convert_minutes_to_milliseconds( $step['interval'] );
						}

						if( isset( $bulkgate_steps[$key]['coupon_expiry'] ) ){
							$bulkgate_steps[$key]['coupon_expiry'] = $admin->convert_minutes_to_milliseconds( $step['coupon_expiry'] );
						}
					}
					update_option( 'cartbounty_pro_bulkgate_steps', $bulkgate_steps );
				}
			}

			//Converting coupon expiry data
			$recovery_coupon_data = array(
				'cartbounty_pro_mailchimp_coupon'		=> $mailchimp_coupon,
				'cartbounty_pro_getresponse_coupon'		=> $getresponse_coupon,
				'cartbounty_pro_activecampaign_coupon'	=> $activecampaign_coupon,
				'cartbounty_pro_webhook_coupon'			=> $webhook_coupon
			);

			foreach( $recovery_coupon_data as $key => $coupon ) {

				if( !empty( $coupon ) ){

					if( isset( $coupon['coupon_expiry'] ) ){
						$coupon['coupon_expiry'] = $admin->convert_minutes_to_milliseconds( $coupon['coupon_expiry'] );
						update_option( $key, $coupon );
					}
				}
			}

			//Converting Notification time interval
			if( !empty( $notification_frequency ) ){

				if( isset( $notification_frequency['hours'] ) ){
					$notification_frequency['interval'] = $admin->convert_minutes_to_milliseconds( $notification_frequency['hours'] );
					update_option( 'cartbounty_pro_notification_frequency', $notification_frequency );
				}
			}

			//Converting Tab notification time interval
			if( !empty( $tab_notification_interval ) ){

				if( isset( $tab_notification_interval['miliseconds'] ) ){
					$tab_notification_interval['interval'] = $tab_notification_interval['miliseconds'];
					update_option( 'cartbounty_pro_tab_notification_interval', $tab_notification_interval );
				}
			}

			$misc_settings['converted_minutes_to_milliseconds'] = true;
			update_option( 'cartbounty_pro_misc_settings', $misc_settings );

			/**
			 * Since version 9.9.3
			 * Due to moving to a different time interval add_custom_wp_cron_intervals() functions
			 */
			if( wp_next_scheduled( 'cartbounty_pro_remove_empty_carts_hook' ) ){
				wp_clear_scheduled_hook( 'cartbounty_pro_remove_empty_carts_hook' );
			}

			if( wp_next_scheduled( 'cartbounty_pro_delete_coupons_hook' ) ){
				wp_clear_scheduled_hook( 'cartbounty_pro_delete_coupons_hook' );
			}

		}

		transfer_time_to_milliseconds();

		/**
		 * Since version 10.0
		 * This code will be removed in later versions
		 */
		if( get_option( 'cartbounty_pro_review_submitted' ) ){
			update_option( 'cartbounty_pro_submitted_notices', array( 'review' => 1 ) );
			delete_option( 'cartbounty_pro_review_submitted' );
		}
		/* End of this temporary block */

		/**
		 * Since version 10.1
		 * Transferring deprecated multiple sepparate options into a acouple single options.
		 * This code will be removed in later versions
		 */
		function transfer_deprecated_options(){
			//Transferring general settings options
			if( get_option( 'cartbounty_pro_license_key' ) || get_option( 'cartbounty_pro_delete_coupons' ) ){ //If deprecated options detected
				$recaptcha_status = false;
				$recaptcha_site_key = '';
				$recaptcha_secret_key = '';
				$recaptcha = get_option( 'cartbounty_pro_recaptcha' );
				$delete_anonymous_carts = get_option( 'cartbounty_pro_delete_anonymous_carts' );
				$notification_frequency = get_option( 'cartbounty_pro_notification_frequency' );

				if( isset( $recaptcha['status'] ) ){
					$recaptcha_status = $recaptcha['status'];
				}

				if( isset( $recaptcha['site_key'] ) ){
					$recaptcha_site_key = $recaptcha['site_key'];
				}

				if( isset( $recaptcha['secret_key'] ) ){
					$recaptcha_secret_key = $recaptcha['secret_key'];
				}

				if( isset( $delete_anonymous_carts['interval'] ) ){
					$delete_anonymous_carts = $delete_anonymous_carts['interval'];
				}
				
				if( isset( $notification_frequency['interval'] ) ){
					$notification_frequency = $notification_frequency['interval'];
				}

				$existing_settings = array(
					'license_key' 				=> get_option( 'cartbounty_pro_license_key' ),
					'exclude_anonymous_carts' 	=> get_option( 'cartbounty_pro_exclude_anonymous_carts' ),
					'allowed_countries' 		=> get_option( 'cartbounty_pro_allowed_countries' ),
					'delete_anonymous_carts' 	=> $delete_anonymous_carts,
					'excluded_emails_phones' 	=> get_option( 'cartbounty_pro_excluded_emails_phones' ),
					'notification_email' 		=> get_option( 'cartbounty_pro_notification_email' ),
					'notification_frequency' 	=> $notification_frequency,
					'exclude_recovered' 		=> get_option( 'cartbounty_pro_exclude_recovered' ),
					'recaptcha' 				=> array(
						'status' 					=> $recaptcha_status,
						'site_key' 					=> $recaptcha_site_key,
						'secret_key' 				=> $recaptcha_secret_key,
					),
					'order_recovery'			=> get_option( 'cartbounty_pro_order_recovery' ),
					'order_statuses'			=> get_option( 'cartbounty_pro_order_statuses' ),
					'international_phone'		=> get_option( 'cartbounty_pro_international_phone' ),
					'phone_consent'				=> get_option( 'cartbounty_pro_phone_consent' ),
					'checkout_consent'			=> get_option( 'cartbounty_pro_phone_checkout_consent' ),
					'tools_consent'				=> get_option( 'cartbounty_pro_phone_tools_consent' ),
					'lift_email'				=> get_option( 'cartbounty_pro_lift_email' ),
					'lift_phone'				=> get_option( 'cartbounty_pro_lift_phone' ),
					'hide_images'				=> get_option( 'cartbounty_pro_hide_images' ),
					'delete_coupons'			=> get_option( 'cartbounty_pro_delete_coupons' ),
					'logging_status'			=> get_option( 'cartbounty_pro_logging_status' ),
				);

				update_option( 'cartbounty_pro_main_settings', $existing_settings );
			}

			//Transferring Exit Intent options
			if( get_option( 'cartbounty_pro_exit_intent_type' ) ){ //If deprecated option detected
				$existing_settings = array(
					'status' 			=> get_option( 'cartbounty_pro_exit_intent_status' ),
					'mobile_status' 	=> get_option( 'cartbounty_pro_exit_intent_mobile_status' ),
					'test_mode' 		=> get_option( 'cartbounty_pro_exit_intent_test_mode' ),
					'style' 			=> get_option( 'cartbounty_pro_exit_intent_type' ),
					'heading' 			=> get_option( 'cartbounty_pro_exit_intent_heading' ),
					'content' 			=> get_option( 'cartbounty_pro_exit_intent_content' ),
					'main_color' 		=> get_option( 'cartbounty_pro_exit_intent_main_color' ),
					'inverse_color' 	=> get_option( 'cartbounty_pro_exit_intent_inverse_color' ),
					'image' 			=> get_option( 'cartbounty_pro_exit_intent_image' ),
					'field_type' 		=> get_option( 'cartbounty_pro_exit_intent_field_type' ),
				);

				update_option( 'cartbounty_pro_exit_intent_settings', $existing_settings );
			}

			//Transferring Early Capture options
			if( get_option( 'cartbounty_pro_early_capture_type' ) ){ //If deprecated option detected
				$existing_settings = array(
					'status' 			=> get_option( 'cartbounty_pro_early_capture_status' ),
					'mandatory' 		=> get_option( 'cartbounty_pro_early_capture_mandatory' ),
					'field_type' 		=> get_option( 'cartbounty_pro_early_capture_field_type' ),
					'heading' 			=> get_option( 'cartbounty_pro_early_capture_heading' ),
					'style' 			=> get_option( 'cartbounty_pro_early_capture_type' ),
					'main_color' 		=> get_option( 'cartbounty_pro_early_capture_main_color' ),
					'inverse_color' 	=> get_option( 'cartbounty_pro_early_capture_inverse_color' ),
					'test_mode' 		=> get_option( 'cartbounty_pro_early_capture_test_mode' ),
				);

				update_option( 'cartbounty_pro_early_capture_settings', $existing_settings );
			}
			
			//Transferring Tab Notification options
			if( get_option( 'cartbounty_pro_tab_notification_status' ) || get_option( 'cartbounty_pro_tab_notification_message' ) || get_option( 'cartbounty_pro_tab_notification_favicon' ) ){ //If deprecated option detected
				$tn_interval = get_option( 'cartbounty_pro_tab_notification_interval' );

				if( isset( $tn_interval['interval'] ) ){
					$tn_interval = $tn_interval['interval'];
				}

				$existing_settings = array(
					'status' 			=> get_option( 'cartbounty_pro_tab_notification_status' ),
					'check_cart' 		=> get_option( 'cartbounty_pro_tab_notification_check_cart' ),
					'interval' 			=> $tn_interval,
					'content' 			=> get_option( 'cartbounty_pro_tab_notification_message' ),
					'favicon' 			=> get_option( 'cartbounty_pro_tab_notification_favicon_status' ),
					'favicon_image' 	=> get_option( 'cartbounty_pro_tab_notification_favicon' ),
					'test_mode' 		=> get_option( 'cartbounty_pro_tab_notification_test_mode' ),
				);

				update_option( 'cartbounty_pro_tab_notification_settings', $existing_settings );
			}

			//Transferring reports fields
			if( get_option( 'cartbounty_pro_active_quick_stats' ) ){ //If deprecated option detected
				$existing_settings = array(
					'quick_stats' 			=> get_option( 'cartbounty_pro_active_quick_stats' ),
					'charts' 				=> get_option( 'cartbounty_pro_active_charts' ),
					'chart_type' 			=> get_option( 'cartbounty_pro_chart_type' ),
					'top_product_count' 	=> 5,
				);

				update_option( 'cartbounty_pro_report_settings', $existing_settings );
			}

			//Transferring WordPress recovery fields
			if( get_option( 'cartbounty_pro_automation_from_name' ) || get_option( 'cartbounty_pro_automation_from_email' ) || get_option( 'cartbounty_pro_automation_reply_email' ) ){ //If deprecated option detected
				$existing_settings = array(
					'from_name' 			=> get_option( 'cartbounty_pro_automation_from_name' ),
					'from_email' 			=> get_option( 'cartbounty_pro_automation_from_email' ),
					'reply_email' 			=> get_option( 'cartbounty_pro_automation_reply_email' ),
				);

				update_option( 'cartbounty_pro_automation_settings', $existing_settings );
			}

			//Transferring GetResponse recovery fields
			if( get_option( 'cartbounty_pro_getresponse_key' ) ){ //If deprecated option detected
				$store_id = get_option( 'cartbounty_pro_getresponse_store_id' );
				$list_id = get_option( 'cartbounty_pro_getresponse_list_id' );

				if( isset( $store_id['store_id'] ) ){
					$store_id = $store_id['store_id'];
				}

				if( isset( $list_id['list_id'] ) ){
					$list_id = $list_id['list_id'];
				}

				$existing_settings = array(
					'key' 						=> get_option( 'cartbounty_pro_getresponse_key' ),
					'store_id' 					=> $store_id,
					'list_id' 					=> $list_id,
					'custom_fields' 			=> get_option( 'cartbounty_pro_getresponse_custom_fields' ),
					'product_table_support' 	=> get_option( 'cartbounty_pro_product_table_supports_getresponse' ),
				);

				update_option( 'cartbounty_pro_getresponse_settings', $existing_settings );
			}

			//Transferring ActiveCampaign recovery fields
			if( get_option( 'cartbounty_pro_activecampaign_key' ) || get_option( 'cartbounty_pro_activecampaign_url' ) ){ //If deprecated option detected
				$existing_settings = array(
					'key' 					=> get_option( 'cartbounty_pro_activecampaign_key' ),
					'url' 					=> get_option( 'cartbounty_pro_activecampaign_url' ),
					'store_id' 				=> get_option( 'cartbounty_pro_activecampaign_store_id' ),
					'external_store_id' 	=> get_option( 'cartbounty_pro_activecampaign_external_store_id' ),
					'automation_id' 		=> get_option( 'cartbounty_pro_activecampaign_automation_id' ),
					'custom_fields' 		=> get_option( 'cartbounty_pro_activecampaign_custom_fields' ),
				);

				update_option( 'cartbounty_pro_activecampaign_settings', $existing_settings );
			}

			//Transferring MailChimp recovery fields
			if( get_option( 'cartbounty_pro_mailchimp_key' ) || get_option( 'cartbounty_pro_mailchimp_list_id' ) || get_option( 'cartbounty_pro_mailchimp_store_id' ) ){ //If deprecated option detected
				$list_id = get_option( 'cartbounty_pro_mailchimp_list_id' );

				if( isset( $list_id['list_id'] ) ){
					$list_id = $list_id['list_id'];
				}

				$existing_settings = array(
					'key' 							=> get_option( 'cartbounty_pro_mailchimp_key' ),
					'list_id' 						=> $list_id,
					'store_id' 						=> get_option( 'cartbounty_pro_mailchimp_store_id' ),
					'merge_fields_created' 			=> get_option( 'cartbounty_pro_mailchimp_merge_fields_created' ),
					'first_sync_done' 				=> get_option( 'cartbounty_pro_first_mailchimp_sync' ),
					'product_create_batch_id' 		=> get_option( 'cartbounty_pro_last_product_create_batch_id' ),
					'product_update_batch_id' 		=> get_option( 'cartbounty_pro_last_product_update_batch_id' ),
					'promo_rule_create_batch_id' 	=> get_option( 'cartbounty_pro_last_promo_rule_create_batch_id' ),
					'promo_code_create_batch_id' 	=> get_option( 'cartbounty_pro_last_promo_code_create_batch_id' ),
					'promo_rule_update_batch_id' 	=> get_option( 'cartbounty_pro_last_promo_rule_update_batch_id' ),
					'promo_code_update_batch_id' 	=> get_option( 'cartbounty_pro_last_promo_code_update_batch_id' ),
					'merge_field_create_batch_id' 	=> get_option( 'cartbounty_pro_last_merge_field_create_batch_id' ),
					'merge_field_update_batch_id' 	=> get_option( 'cartbounty_pro_last_merge_field_update_batch_id' ),
					'merge_field_delete_batch_id' 	=> get_option( 'cartbounty_pro_last_merge_field_delete_batch_id' ),
					'cart_batch_id' 				=> get_option( 'cartbounty_pro_last_cart_batch_id' ),
					'cart_delete_batch_id' 			=> get_option( 'cartbounty_pro_last_cart_delete_batch_id' ),
				);

				update_option( 'cartbounty_pro_mailchimp_settings', $existing_settings );
			}

			//Transferring notices
			if( get_option( 'cartbounty_pro_mc_setup' ) || get_option( 'cartbounty_pro_ac_setup' ) || get_option( 'cartbounty_pro_gr_setup' ) || get_option( 'cartbounty_pro_cron_warning' ) ){ //If deprecated option detected
				$existing_settings = array(
					'mc_setup' 			=> get_option( 'cartbounty_pro_mc_setup' ),
					'ac_setup' 			=> get_option( 'cartbounty_pro_ac_setup' ),
					'gr_setup' 			=> get_option( 'cartbounty_pro_gr_setup' ),
					'cron_warning' 		=> get_option( 'cartbounty_pro_cron_warning' ),
				);

				update_option( 'cartbounty_pro_submitted_warnings', $existing_settings );
			}

			//Transferring misc settings
			if( get_option( 'cartbounty_pro_license_saved_key' ) || get_option( 'cartbounty_pro_version_number' ) || get_option( 'cartbounty_pro_license_code' ) ){ //If deprecated option detected
				$existing_settings = array(
					'saved_license' 					=> get_option( 'cartbounty_pro_license_saved_key' ),
					'license_code' 						=> get_option( 'cartbounty_pro_license_code' ),
					'version_number' 					=> get_option( 'cartbounty_pro_version_number' ),
					'recoverable_carts' 				=> get_option( 'cartbounty_pro_recoverable_cart_count' ),
					'anonymous_carts' 					=> get_option( 'cartbounty_pro_anonymous_cart_count' ),
					'recovered_carts' 					=> get_option( 'cartbounty_pro_recovered_cart_count' ),
					'times_review_declined' 			=> get_option( 'cartbounty_pro_times_review_declined' ),
					'product_table_exists' 				=> get_option( 'cartbounty_pro_product_table_exists' ),
					'coupon_table_exists' 				=> get_option( 'cartbounty_pro_coupon_table_exists' ),
					'message_table_exists' 				=> get_option( 'cartbounty_pro_message_table_exists' ),
					'email_table_exists' 				=> get_option( 'cartbounty_pro_email_table_exists' ),
					'push_notification_table_exists' 	=> get_option( 'cartbounty_pro_push_notification_table_exists' ),
					'carts_imported' 					=> get_option( 'cartbounty_pro_carts_imported' ),
					'type_column_updated' 				=> get_option( 'cartbounty_pro_type_column_updated' ),
					'wpml_strings_registered' 			=> get_option( 'cartbounty_pro_wpml_strings_registered' ),
					'converted_minutes_to_milliseconds' => get_option( 'cartbounty_pro_converted_minutes_to_miliseconds' ),
					'update_last_checked' 				=> get_option( 'cartbounty_pro_update_last_checked' ),
				);

				update_option( 'cartbounty_pro_misc_settings', $existing_settings );
			}
			
			//Deleting options that will no longer be required
			delete_option( 'cartbounty_pro_license_key' );
			delete_option( 'cartbounty_pro_exclude_anonymous_carts' );
			delete_option( 'cartbounty_pro_allowed_countries' );
			delete_option( 'cartbounty_pro_delete_anonymous_carts' );
			delete_option( 'cartbounty_pro_excluded_emails_phones' );
			delete_option( 'cartbounty_pro_notification_email' );
			delete_option( 'cartbounty_pro_notification_frequency' );
			delete_option( 'cartbounty_pro_exclude_recovered' );
			delete_option( 'cartbounty_pro_recaptcha' );
			delete_option( 'cartbounty_pro_order_recovery' );
			delete_option( 'cartbounty_pro_order_statuses' );
			delete_option( 'cartbounty_pro_international_phone' );
			delete_option( 'cartbounty_pro_phone_consent' );
			delete_option( 'cartbounty_pro_phone_checkout_consent' );
			delete_option( 'cartbounty_pro_phone_tools_consent' );
			delete_option( 'cartbounty_pro_lift_email' );
			delete_option( 'cartbounty_pro_lift_phone' );
			delete_option( 'cartbounty_pro_hide_images' );
			delete_option( 'cartbounty_pro_delete_coupons' );
			delete_option( 'cartbounty_pro_logging_status' );
			delete_option( 'cartbounty_pro_exit_intent_status' );
			delete_option( 'cartbounty_pro_exit_intent_mobile_status' );
			delete_option( 'cartbounty_pro_exit_intent_test_mode' );
			delete_option( 'cartbounty_pro_exit_intent_type' );
			delete_option( 'cartbounty_pro_exit_intent_heading' );
			delete_option( 'cartbounty_pro_exit_intent_content' );
			delete_option( 'cartbounty_pro_exit_intent_main_color' );
			delete_option( 'cartbounty_pro_exit_intent_inverse_color' );
			delete_option( 'cartbounty_pro_exit_intent_image' );
			delete_option( 'cartbounty_pro_exit_intent_field_type' );
			delete_option( 'cartbounty_pro_early_capture_status' );
			delete_option( 'cartbounty_pro_early_capture_mandatory' );
			delete_option( 'cartbounty_pro_early_capture_field_type' );
			delete_option( 'cartbounty_pro_early_capture_heading' );
			delete_option( 'cartbounty_pro_early_capture_type' );
			delete_option( 'cartbounty_pro_early_capture_main_color' );
			delete_option( 'cartbounty_pro_early_capture_inverse_color' );
			delete_option( 'cartbounty_pro_early_capture_test_mode' );
			delete_option( 'cartbounty_pro_activecampaign_key' );
			delete_option( 'cartbounty_pro_activecampaign_url' );
			delete_option( 'cartbounty_pro_activecampaign_store_id' );
			delete_option( 'cartbounty_pro_activecampaign_external_store_id' );
			delete_option( 'cartbounty_pro_activecampaign_automation_id' );
			delete_option( 'cartbounty_pro_activecampaign_custom_fields' );
			delete_option( 'cartbounty_pro_getresponse_key' );
			delete_option( 'cartbounty_pro_getresponse_store_id' );
			delete_option( 'cartbounty_pro_getresponse_list_id' );
			delete_option( 'cartbounty_pro_getresponse_custom_fields' );
			delete_option( 'cartbounty_pro_product_table_supports_getresponse' );
			delete_option( 'cartbounty_pro_automation_from_name' );
			delete_option( 'cartbounty_pro_automation_from_email' );
			delete_option( 'cartbounty_pro_automation_reply_email' );
			delete_option( 'cartbounty_pro_active_quick_stats' );
			delete_option( 'cartbounty_pro_active_charts' );
			delete_option( 'cartbounty_pro_chart_type' );
			delete_option( 'cartbounty_pro_top_product_count' );
			delete_option( 'cartbounty_pro_tab_notification_status' );
			delete_option( 'cartbounty_pro_tab_notification_check_cart' );
			delete_option( 'cartbounty_pro_tab_notification_interval' );
			delete_option( 'cartbounty_pro_tab_notification_message' );
			delete_option( 'cartbounty_pro_tab_notification_favicon_status' );
			delete_option( 'cartbounty_pro_tab_notification_favicon' );
			delete_option( 'cartbounty_pro_tab_notification_test_mode' );
			delete_option( 'cartbounty_pro_license_saved_key' );
			delete_option( 'cartbounty_pro_license_code' );
			delete_option( 'cartbounty_pro_version_number' );
			delete_option( 'cartbounty_pro_recoverable_cart_count' );
			delete_option( 'cartbounty_pro_anonymous_cart_count' );
			delete_option( 'cartbounty_pro_recovered_cart_count' );
			delete_option( 'cartbounty_pro_times_review_declined' );
			delete_option( 'cartbounty_pro_product_table_exists' );
			delete_option( 'cartbounty_pro_coupon_table_exists' );
			delete_option( 'cartbounty_pro_message_table_exists' );
			delete_option( 'cartbounty_pro_email_table_exists' );
			delete_option( 'cartbounty_pro_push_notification_table_exists' );
			delete_option( 'cartbounty_pro_carts_imported' );
			delete_option( 'cartbounty_pro_type_column_updated' );
			delete_option( 'cartbounty_pro_wpml_strings_registered' );
			delete_option( 'cartbounty_pro_converted_minutes_to_miliseconds' );
			delete_option( 'cartbounty_pro_update_last_checked' );
			delete_option( 'cartbounty_pro_update_link' );
			delete_option( 'cartbounty_pro_mc_setup' );
			delete_option( 'cartbounty_pro_ac_setup' );
			delete_option( 'cartbounty_pro_gr_setup' );
			delete_option( 'cartbounty_pro_cron_warning' );
			delete_option( 'cartbounty_pro_mailchimp_key' );
			delete_option( 'cartbounty_pro_mailchimp_list_id' );
			delete_option( 'cartbounty_pro_mailchimp_store_id' );
			delete_option( 'cartbounty_pro_mailchimp_merge_fields_created' );
			delete_option( 'cartbounty_pro_first_mailchimp_sync' );
			delete_option( 'cartbounty_pro_last_product_create_batch_id' );
			delete_option( 'cartbounty_pro_last_product_update_batch_id' );
			delete_option( 'cartbounty_pro_last_promo_rule_create_batch_id' );
			delete_option( 'cartbounty_pro_last_promo_code_create_batch_id' );
			delete_option( 'cartbounty_pro_last_promo_rule_update_batch_id' );
			delete_option( 'cartbounty_pro_last_promo_code_update_batch_id' );
			delete_option( 'cartbounty_pro_last_merge_field_create_batch_id' );
			delete_option( 'cartbounty_pro_last_merge_field_update_batch_id' );
			delete_option( 'cartbounty_pro_last_merge_field_delete_batch_id' );
			delete_option( 'cartbounty_pro_last_cart_batch_id' );
			delete_option( 'cartbounty_pro_last_cart_delete_batch_id' );
		}

		transfer_deprecated_options();
		/* End of this temporary block */
	}
}