<?php

/**
 * Plugin Name: CartBounty Pro - Save and recover abandoned carts for WooCommerce
 * Plugin URI: https://www.cartbounty.com
 * Description: Save abandoned carts by instantly capturing WooCommerce checkout form before submission.
 * Version: 10.9.1
 * Text Domain: woo-save-abandoned-carts
 * Author: Streamline.lv
 * Author URI: http://www.majas-lapu-izstrade.lv/en
 * Requires at least: 4.6
 * Requires PHP: 7.3
 * Requires Plugins: woocommerce
 * License: GPLv3
 * License URI: https://www.gnu.org/licenses/gpl-3.0.html
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) die;

//Defining constants
if (!defined('CARTBOUNTY_PRO_VERSION_NUMBER')) define( 'CARTBOUNTY_PRO_VERSION_NUMBER', '10.9.1' );
if (!defined('CARTBOUNTY_PRO_PLUGIN_NAME')) define( 'CARTBOUNTY_PRO_PLUGIN_NAME', 'CartBounty Pro - Save and recover abandoned carts for WooCommerce' );
if (!defined('CARTBOUNTY_PRO')) define( 'CARTBOUNTY_PRO', 'cartbounty_pro' );
if (!defined('CARTBOUNTY_PRO_PLUGIN_NAME_SLUG')) define( 'CARTBOUNTY_PRO_PLUGIN_NAME_SLUG', 'cartbounty-pro' );
if (!defined('CARTBOUNTY_PRO_FILENAME')) define( 'CARTBOUNTY_PRO_FILENAME', __FILE__ );
if (!defined('CARTBOUNTY_PRO_BASENAME')) define( 'CARTBOUNTY_PRO_BASENAME', plugin_basename( __FILE__ ) );
if (!defined('CARTBOUNTY_TABLE_NAME')) define( 'CARTBOUNTY_TABLE_NAME', 'cartbounty' );
if (!defined('CARTBOUNTY_PRO_TABLE_NAME')) define( 'CARTBOUNTY_PRO_TABLE_NAME', 'cartbounty_pro' );
if (!defined('CARTBOUNTY_PRO_TABLE_NAME_PRODUCTS')) define( 'CARTBOUNTY_PRO_TABLE_NAME_PRODUCTS', 'cartbounty_pro_products' );
if (!defined('CARTBOUNTY_PRO_TABLE_NAME_COUPONS')) define( 'CARTBOUNTY_PRO_TABLE_NAME_COUPONS', 'cartbounty_pro_coupons' );
if (!defined('CARTBOUNTY_PRO_TABLE_NAME_EMAILS')) define( 'CARTBOUNTY_PRO_TABLE_NAME_EMAILS', 'cartbounty_pro_emails' );
if (!defined('CARTBOUNTY_PRO_TABLE_NAME_MESSAGES')) define( 'CARTBOUNTY_PRO_TABLE_NAME_MESSAGES', 'cartbounty_pro_messages' );
if (!defined('CARTBOUNTY_PRO_TABLE_NAME_NOTIFICATIONS')) define( 'CARTBOUNTY_PRO_TABLE_NAME_NOTIFICATIONS', 'cartbounty_pro_notifications' );
if (!defined('CARTBOUNTY_PRO_TEXT_DOMAIN')) define( 'CARTBOUNTY_PRO_TEXT_DOMAIN', 'woo-save-abandoned-carts' ); //No longer used since v9.2.3. Will be removed in future releases
if (!defined('CARTBOUNTY_PRO_ABBREVIATION')) define( 'CARTBOUNTY_PRO_ABBREVIATION', 'CartBounty Pro' );
if (!defined('CARTBOUNTY_PRO_SHORT')) define( 'CARTBOUNTY_PRO_SHORT', 'CartBounty' );
if (!defined('CARTBOUNTY_PRO_NEW_NOTICE')) define( 'CARTBOUNTY_PRO_NEW_NOTICE', 240 ); //Defining time in minutes how long New status is shown in the table
if (!defined('CARTBOUNTY_PRO_MAX_SYNC_PERIOD')) define( 'CARTBOUNTY_PRO_MAX_SYNC_PERIOD', 100 ); //Defining maximum period in days that is up for recovery. We do not want to remind about very old abandoned carts
if (!defined('CARTBOUNTY_PRO_MAX_STEPS')) define( 'CARTBOUNTY_PRO_MAX_STEPS', 4 ); //Temporary block since version 10.9. Will be removed in future versions
if (!defined('CARTBOUNTY_PRO_ANONYMIZATION_PERIOD')) define( 'CARTBOUNTY_PRO_ANONYMIZATION_PERIOD', 180 ); //Defining default abandoned cart personal data anonymization period in days. Default 180 days
if (!defined('CARTBOUNTY_PRO_SECRET_KEY')) define( 'CARTBOUNTY_PRO_SECRET_KEY', 'v8rG0N2vs6.38Bv3l750xwpy5Gbv1.sd5te' ); //This is the Secret Key for License Verification Requests
if (!defined('CARTBOUNTY_PRO_LICENSE_SERVER_URL')) define('CARTBOUNTY_PRO_LICENSE_SERVER_URL', 'https://www.cartbounty.com/' ); //This is the URL where API query request will be sent to.
if (!defined('CARTBOUNTY_PRO_LICENSE_SERVER_URL_2')) define('CARTBOUNTY_PRO_LICENSE_SERVER_URL_2', 'https://www.cartbounty.eu/cartbounty-license-handler.php' );
if (!defined('CARTBOUNTY_PRO_REPOSITORY_URL')) define('CARTBOUNTY_PRO_REPOSITORY_URL', 'wp-content/wp-update-server/?action=get_metadata&slug=woo-save-abandoned-carts-pro' );
if (!defined('CARTBOUNTY_PRO_LICENSE_RENEWAL_LINK')) define('CARTBOUNTY_PRO_LICENSE_RENEWAL_LINK', 'https://www.cartbounty.com/renew' ); //This is the URL where users can renew their licenses
if (!defined('CARTBOUNTY_PRO_FEATURE_LINK')) define('CARTBOUNTY_PRO_FEATURE_LINK', 'https://www.cartbounty.com/contact/' ); //This is the URL where users can provide new ideas and suggestions
if (!defined('CARTBOUNTY_PRO_SUPPORT_LINK')) define('CARTBOUNTY_PRO_SUPPORT_LINK', 'https://www.cartbounty.com/get-premium-support/' ); //This is the URL where users can get support
if (!defined('CARTBOUNTY_PRO_MAILCHIMP_LINK')) define('CARTBOUNTY_PRO_MAILCHIMP_LINK', 'http://eepurl.com/hHjfrX' );
if (!defined('CARTBOUNTY_PRO_MAILCHIMP_SETUP_TUTORIAL_LINK')) define('CARTBOUNTY_PRO_MAILCHIMP_SETUP_TUTORIAL_LINK', 'https://youtu.be/_uhlSJyzXlE' ); //Video how to link CartBounty Pro plugin with MailChimp
if (!defined('CARTBOUNTY_PRO_ACTIVECAMPAIGN_SETUP_TUTORIAL_LINK')) define('CARTBOUNTY_PRO_ACTIVECAMPAIGN_SETUP_TUTORIAL_LINK', 'https://youtu.be/p27bMZns-cw' ); //Video how to link CartBounty Pro plugin with ActiveCampaign
if (!defined('CARTBOUNTY_PRO_MAILCHIMP_SETUP_AUTOMATION_LINK')) define('CARTBOUNTY_PRO_MAILCHIMP_SETUP_AUTOMATION_LINK', 'https://admin.mailchimp.com/campaigns/#/create-campaign/explore/abandonedCart' ); //Link on where to create abandoned cart recovery automation process in MailChimp
if (!defined('CARTBOUNTY_PRO_MAILCHIMP_API_LINK')) define('CARTBOUNTY_PRO_MAILCHIMP_API_LINK', 'https://mailchimp.com/help/about-api-keys/' ); //How to get MailChimp API key
if (!defined('CARTBOUNTY_PRO_ACTIVECAMPAIGN_API_TUTORIAL')) define('CARTBOUNTY_PRO_ACTIVECAMPAIGN_API_TUTORIAL', 'https://help.activecampaign.com/hc/en-us/articles/207317590-Getting-started-with-the-API#how-to-obtain-your-activecampaign-api-url-and-key?_r=5347LGDC' ); //ActiveCampaign post on how to get API key and URL
if (!defined('CARTBOUNTY_PRO_ACTIVECAMPAIGN_TRIAL_LINK')) define('CARTBOUNTY_PRO_ACTIVECAMPAIGN_TRIAL_LINK', 'https://www.activecampaign.com/?_r=5347LGDC' ); //ActiveCampaign trial link
if (!defined('CARTBOUNTY_PRO_GETRESPONSE_TRIAL_LINK')) define('CARTBOUNTY_PRO_GETRESPONSE_TRIAL_LINK', 'https://www.getresponse.com/features/marketing-automation?a=vPJGRchyVX&c=integrate_cartbounty' ); //GetResponse free trial link
if (!defined('CARTBOUNTY_PRO_GETRESPONSE_SETUP_LINK')) define('CARTBOUNTY_PRO_GETRESPONSE_SETUP_LINK', 'https://www.getresponse.com/help/ecommerce/working-with-ecommerce-data/how-can-i-include-abandoned-cart-information-in-a-message.html?a=vPJGRchyVX&c=setup_notice' ); //GetResponse post on how to setup abandoned cart automation
if (!defined('CARTBOUNTY_PRO_GETRESPONSE_API_LINK')) define('CARTBOUNTY_PRO_GETRESPONSE_API_LINK', 'https://www.getresponse.com/help/integrations-and-api/where-do-i-find-the-api-key.html?a=vPJGRchyVX&c=find_api_key' ); //GetResponse post on how to get API key
if ( !defined('CARTBOUNTY_PRO_LICENSE_ENCRYPTION_KEY')) define('CARTBOUNTY_PRO_LICENSE_ENCRYPTION_KEY', '21u439od63027c5a027c235df04T54b10a70b2924Pf19634a139Q584d674a1802' );
if (!defined('CARTBOUNTY_PRO_LICENSE_CODE')) define('CARTBOUNTY_PRO_LICENSE_CODE', 2769008017626 );
if (!defined('CARTBOUNTY_PRO_EXPIRED_LICENSE_CODE')) define('CARTBOUNTY_PRO_EXPIRED_LICENSE_CODE', 6491621731553 );
if (!defined('CARTBOUNTY_PRO_ENCRYPTION_KEY')) define('CARTBOUNTY_PRO_ENCRYPTION_KEY', 'SgVkYp3s6v9y$B&E)H+MbQeThWmZq4t7' ); //Defines encryption key used for creating checkout URL hash part of the link
if (!defined('CARTBOUNTY_PRO_REVIEW_LINK')) define('CARTBOUNTY_PRO_REVIEW_LINK', 'https://wordpress.org/support/plugin/woo-save-abandoned-carts/reviews/#new-post' );
if (!defined('RECAPTCHA_SITE')) define('RECAPTCHA_SITE', 'https://www.google.com/recaptcha' );
if (!defined('RECAPTCHA_SITE_API')) define('RECAPTCHA_SITE_API', 'https://www.google.com/recaptcha/api/siteverify' );
if (!defined('RECAPTCHA_DEMO_LINK')) define('RECAPTCHA_DEMO_LINK', 'https://recaptcha-demo.appspot.com/recaptcha-v3-request-scores.php' );
if (!defined('CARTBOUNTY_PRO_LOGO_70_LINK')) define('CARTBOUNTY_PRO_LOGO_70_LINK', 'https://www.cartbounty.com/wp-content/wp-update-server/package-assets/icons/cartbounty-pro-70x70.svg' );
if (!defined('CARTBOUNTY_PRO_BULKGATE_TRIAL_LINK')) define('CARTBOUNTY_PRO_BULKGATE_TRIAL_LINK', 'https://portal.bulkgate.com/join/55713/en/solutions/sms-gateway' );
if (!defined('CARTBOUNTY_PRO_BULKGATE_SENDER_ID_PROFILE_LINK')) define('CARTBOUNTY_PRO_BULKGATE_SENDER_ID_PROFILE_LINK', 'https://help.bulkgate.com/docs/en/sender-id-profile.html' );
if (!defined('CARTBOUNTY_PRO_BULKGATE_SENDER_ID_MOBILE_CONNECT_LINK')) define('CARTBOUNTY_PRO_BULKGATE_SENDER_ID_MOBILE_CONNECT_LINK', 'https://help.bulkgate.com/docs/en/mobile-connect-install.html' );
if (!defined('CARTBOUNTY_PRO_MAKE_LINK')) define('CARTBOUNTY_PRO_MAKE_LINK', 'https://www.make.com/en?pc=cartbounty' );
if (!defined('CARTBOUNTY_PRO_PABBLY_LINK')) define('CARTBOUNTY_PRO_PABBLY_LINK', 'https://payments.pabbly.com/api/affurl/RVYZ07kQyUZ0Z1HUKZ1m/xciq3ahCAzNG3CSo?target=9Z2AHyhSldo6KI1Fn' );
	

//Registering custom options
register_setting( 'cartbounty-pro-settings-group', 'cartbounty_pro_main_settings' );
register_setting( 'cartbounty-pro-mailchimp-settings', 'cartbounty_pro_mailchimp_settings' );
register_setting( 'cartbounty-pro-mailchimp-settings', 'cartbounty_pro_mailchimp_coupon' );
register_setting( 'cartbounty-pro-mailchimp-settings', 'cartbounty_pro_mailchimp_exclusions' );
register_setting( 'cartbounty-pro-settings-exit-intent', 'cartbounty_pro_exit_intent_settings' );
register_setting( 'cartbounty-pro-settings-exit-intent', 'cartbounty_pro_exit_intent_coupon' );
register_setting( 'cartbounty-pro-early-capture-settings', 'cartbounty_pro_early_capture_settings' );
register_setting( 'cartbounty-pro-early-capture-settings', 'cartbounty_pro_early_capture_coupon' );
register_setting( 'cartbounty-pro-tab-notification-settings', 'cartbounty_pro_tab_notification_settings' );
register_setting( 'cartbounty-pro-activecampaign-settings', 'cartbounty_pro_activecampaign_settings' );
register_setting( 'cartbounty-pro-activecampaign-settings', 'cartbounty_pro_activecampaign_coupon' );
register_setting( 'cartbounty-pro-activecampaign-settings', 'cartbounty_pro_activecampaign_exclusions' );
register_setting( 'cartbounty-pro-getresponse-settings', 'cartbounty_pro_getresponse_settings' );
register_setting( 'cartbounty-pro-getresponse-settings', 'cartbounty_pro_getresponse_coupon' );
register_setting( 'cartbounty-pro-getresponse-settings', 'cartbounty_pro_getresponse_exclusions' );
register_setting( 'cartbounty-pro-wordpress-settings', 'cartbounty_pro_automation_settings' );
register_setting( 'cartbounty-pro-wordpress-settings', 'cartbounty_pro_automation_steps' );
register_setting( 'cartbounty-pro-wordpress-settings', 'cartbounty_pro_automation_exclusions' );
register_setting( 'cartbounty-pro-bulkgate-settings', 'cartbounty_pro_bulkgate_settings' );
register_setting( 'cartbounty-pro-bulkgate-settings', 'cartbounty_pro_bulkgate_steps' );
register_setting( 'cartbounty-pro-bulkgate-settings', 'cartbounty_pro_bulkgate_exclusions' );
register_setting( 'cartbounty-pro-push-notification-settings', 'cartbounty_pro_push_notification_steps' );
register_setting( 'cartbounty-pro-push-notification-settings', 'cartbounty_pro_push_notification_settings' );
register_setting( 'cartbounty-pro-push-notification-settings', 'cartbounty_pro_push_notification_exclusions' );
register_setting( 'cartbounty-pro-webhook-settings', 'cartbounty_pro_webhook_url' );
register_setting( 'cartbounty-pro-webhook-settings', 'cartbounty_pro_webhook_coupon' );
register_setting( 'cartbounty-pro-webhook-settings', 'cartbounty_pro_webhook_exclusions' );

/**
 * The code that runs during plugin activation.
 * Updating Database tables on each version change
 *
 * @since    1.0
 */
function activate_cartbounty_pro() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-cartbounty-pro-activator.php';
	CartBounty_Pro_Activator::activate();
	$admin = new CartBounty_Pro_Admin( CARTBOUNTY_PRO_PLUGIN_NAME_SLUG, CARTBOUNTY_PRO_VERSION_NUMBER );
	$misc_settings = $admin->get_settings( 'misc_settings' );

	if( $misc_settings['product_table_exists'] ){
		require_once plugin_dir_path( __FILE__ ) . 'admin/class-cartbounty-pro-admin.php';
		CartBounty_Pro_Admin::create_product_table();
	}

	if( $misc_settings['coupon_table_exists'] ){
		require_once plugin_dir_path( __FILE__ ) . 'includes/class-cartbounty-pro-mailchimp.php';
		CartBounty_Pro_Mailchimp::create_coupon_table();
	}

	if( $misc_settings['email_table_exists'] ){
		require_once plugin_dir_path( __FILE__ ) . 'includes/class-cartbounty-pro-wordpress.php';
		CartBounty_Pro_WordPress::create_email_table();
	}

	if( $misc_settings['push_notification_table_exists'] ){
		require_once plugin_dir_path( __FILE__ ) . 'includes/class-cartbounty-pro-push-notifications.php';
		CartBounty_Pro_Push_Notification::create_notification_table();
	}

	if( $misc_settings['message_table_exists'] ){
		require_once plugin_dir_path( __FILE__ ) . 'includes/class-cartbounty-pro-bulkgate.php';
		CartBounty_Pro_BulkGate::create_message_table();
	}
}

/**
 * The code that runs during plugin deactivation.
 *
 * @since    1.0
 */
function deactivate_cartbounty_pro() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-cartbounty-pro-deactivator.php';
	CartBounty_Pro_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_cartbounty_pro' );
register_deactivation_hook( __FILE__, 'deactivate_cartbounty_pro' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-cartbounty-pro.php';

/**
 * Begins execution of the plugin.
 *
 * @since    1.0
 */
function run_cartbounty_pro() {
	$plugin = new CartBounty_Pro();
	$plugin->run();
}

run_cartbounty_pro();