<?php
/**
 * Init wooPriceHistorySyncronize
 * http://www.aa-team.com
 * ======================
 *
 * @author		Andrei Dinca, AA-Team
 * @version		1.0
 */
if( !class_exists('wooPriceHistorySyncronize') ){
	
	class wooPriceHistorySyncronize
	{
		/**
		 * wooPriceHistory
		 *
		 * @var db
		 */
		private $db = null;
		private $price_update = null;
	
		/**
		 * @params main class object
		 */
		public function __construct()
		{
			global $wooPriceHistory, $wpdb;
			
			$this->db = $wpdb;
			
			require_once( $wooPriceHistory->cfg['paths']['scripts_dir_path'] . '/prices_update/prices.class.php' );
			$this->price_update = new wooPriceHistoryPricesUpdates( $wooPriceHistory );
			
			foreach ($this->getAllWooProducts() as $key => $value) {
				$product = $value['ID'];
				 
				$lowesPrice = get_post_meta($product, '_regular_price', true);
				$lowesPrice = trim($lowesPrice) != "" && trim(get_post_meta($product, '_sale_price', true)) != "" ? get_post_meta($product, '_sale_price', true) : $lowesPrice;
				
				if( trim($lowesPrice) != "" && (int) $product > 0 ){
					$this->price_update->update_product_price( (int)$product, $lowesPrice );
				}
				
				echo 'Update for product: ' . $product . ' DONE! <br />' . PHP_EOL; 
			}
		}
		
		private function getAllWooProducts()
		{
			return $this->db->get_results( "SELECT ID FROM " . ($this->db->prefix) . "posts where 1=1 and post_type='product' and  post_status='publish'", ARRAY_A );
		}
	}
}