<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

if (!class_exists('wooPriceHistoryPriceEvolutionProductTab')) {
	
	class wooPriceHistoryPriceEvolutionProductTab 
	{
		
		private $tab_data = false;
		const VERSION = "1.0";
	
		private $tab_title;
		private $db_table;
	
		public function __construct() 
		{
			global $wpdb, $wooPriceHistory;
			$this->db_table = $wpdb->prefix . 'price_evolution';
			$this->tab_title = __('Price History', 'woo-price-history');
			add_action( 'init', array( $this, 'init' ));
		}
	
		public function init() 
		{
			
			// frontend stuff
			add_action('woocommerce_product_tabs',	   array($this, 'custom_product_tabs'),	   25);  // in between the attributes and reviews panels
		}
	
		/**
		 * Write the custom tab on the product view page.  In WooCommerce these are
		 * handled by templates.
		 */
		public function custom_product_tabs( $tabs = array() ) 
		{
			global $product, $wooPriceHistory;
	
			if($this->product_has_custom_tabs($product)) {
	
				$priority = 15;
				foreach($this->tab_data as $tab) {
	
					$tabs[$tab['id']] = array(
						'title'    => $this->tab_title,
						'priority' => $priority,
						'callback' => array($this, 'product_price_tab')
					);
				}
			}
	
			return $tabs;
		}
	
		function product_price_tab( $tab )
		{
			global $product; 
			if($this->product_has_custom_tabs($product)) {
				echo $this->tab_data[0]['content'];
			}
		 
		}
	
		/**
		 * Lazy-load the product_tabs meta data, and return true if it exists,
		 * false otherwise
		 *
		 * @return true if there is custom tab data, false otherwise
		 */
		private function product_has_custom_tabs($product) 
		{ 
			global $wpdb, $wooPriceHistory;
			if( (int) $product->get_id() > 0 ){
				$product = (int) $wpdb->get_var("SELECT product_id FROM " . $this->db_table . " WHERE 1=1 and product_id='" . ( $product->get_id() ) . "'");
				if( $product > 0 ){
				
					$this->tab_data[] = array(
						'id' => $wooPriceHistory->alias . '_price_history',
						'content' => $this->price_evolution_base_html( $product )
					);
				}
			}
	
			// tab must at least have a title to exist
			return !empty($this->tab_data) && !empty($this->tab_data[0]) && !empty($this->tab_data[0]['content']);
		}
	
		/**
		 * Adds a new tab to the Product Data postbox in the admin product interface
		 */
		public function product_write_panel_tab()
		{
			echo "<li><a style=\"color:#555555;line-height:16px;padding:9px;text-shadow:0 1px 1px #FFFFFF;\" href=\"#product_tabs\">". $this->tab_title ."</a></li>";
		}
		
		public function price_evolution_base_html( $product )
		{
			global $wpdb, $wooPriceHistory;
			
			$html = array();
		
			$html[] = '<link rel="stylesheet" type="text/css" href="//fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i" />';
			$html[] = '<link rel="stylesheet" type="text/css" href="' . ( $wooPriceHistory->cfg['paths']["design_dir_url"] ) . '/price-history.css" />';
			$html[] = '<script type="text/javascript" src="https://www.google.com/jsapi"></script>';
			$html[] = '<script type="text/javascript">google.load("visualization", "1", {packages:["corechart"]});</script>';
	
			ob_start();
			require_once( $wooPriceHistory->cfg['paths']["design_dir_path"] . '/content.html' );
			$output = ob_get_contents();
			ob_end_clean();
			
			// replace last 5 price changes
			$last_5_changes = $wpdb->get_results("SELECT * FROM " . $this->db_table . " WHERE 1=1 and product_id='" . ( $product ) . "' order by added_date desc limit 5", ARRAY_A);
			if( $last_5_changes && count($last_5_changes) > 0 ){
				$__tmp_html = '';
				foreach ($last_5_changes as $key => $value) {
					
					$__tmp_html .= '<tr>
						<td>
							' . ( date( "F j, Y, g:i a", strtotime($value['added_date']) ) ) . '
						</td>
						<td class="rightAlign">
							<span class="">' . ( wc_price($value['price'])) . '</span>
						</td>
					</tr>';
				}
			}
			$output = str_replace("{last_5_price_changes}", $__tmp_html, $output);
			
			// replace summary reports
			
			// current price 
			$lowesPrice = get_post_meta($product, '_regular_price', true);
			$lowesPrice = trim($lowesPrice) != "" && trim(get_post_meta($product, '_sale_price', true)) != "" ? get_post_meta($product, '_sale_price', true) : $lowesPrice;
			
			$__tmp_html = '
				<tr>
					<td>' . __('Current', 'woo-price-history') . '</td>
					<td>' . ( wc_price( $lowesPrice ) ) . '</td>
					<td>' . ( date( "M j, Y" ) ) . '</td>
				</tr>';
					
			// Max price
			$max_price = $wpdb->get_row("SELECT * FROM " . $this->db_table . " WHERE 1=1 and product_id='" . ( $product ) . "' order by price desc", ARRAY_A);
			if( $max_price ){
				$__tmp_html .= '
					<tr class="highest_price">
						<td>' . __('Highest', 'woo-price-history') . '<sup>*</sup></td>
						<td>' . ( wc_price( $max_price['price'] ) ) . '</td>
						<td>' . ( date( "M j, Y", strtotime($max_price['added_date']) ) ) . '</td>
					</tr>';
			}
			
			// Min price
			$min_price = $wpdb->get_row("SELECT * FROM " . $this->db_table . " WHERE 1=1 and product_id='" . ( $product ) . "' order by price asc", ARRAY_A);
			if( $min_price ){
				$__tmp_html .= '
					<tr class="lowest_price">
						<td>' . __('Lowest', 'woo-price-history') . '<sup>*</sup></td>
						<td>' . ( wc_price( $min_price['price'] ) ) . '</td>
						<td>' . ( date( "M j, Y", strtotime($min_price['added_date']) ) ) . '</td>
					</tr>';
			}
			
			// Average price
			$arv_price = $wpdb->get_var("SELECT avg(price) as average_price FROM " . $this->db_table . " WHERE 1=1 and product_id='" . ( $product ) . "'");
			if( $arv_price > 0 ){
				$__tmp_html .= '
					<tr>
						<td>' . __('Average', 'woo-price-history') . '</td>
						<td>' . ( wc_price( $arv_price ) ) . '</td>
						<td> </td>
					</tr>';
			}
			$output = str_replace("{price_history_summary}", $__tmp_html, $output);
			
			// replace the product preview
			$image = get_the_post_thumbnail( $product, apply_filters( 'single_product_large_thumbnail_size', 'shop_single' ) );
			$product_preview = $image;
			$product_preview .= '<h4>Current Price:</h4><p class="price"> ' . ( wc_price( $lowesPrice ) ) . '</p>'; 
			$output = str_replace("{product_preview}", $product_preview, $output);
			
			// replace the product id
			$output = str_replace("{prod_id}", $product, $output);
			
			
			$output = str_replace("{currency}", get_woocommerce_currency_symbol(), $output);
			
			
			$output = str_replace("{content_h1}", __('Enter Your Email &amp; We`ll Notify You via E-Mail When This Product Goes On Sale!', 'woo-price-history'), $output);
			$output = str_replace("{content_p}", __('We have a Free Price Alert Service that will help you Save Money while Shopping Online on our Website!', 'woo-price-history'), $output);
			$output = str_replace("{content_h2_first}", __('Set Alert for Price lower than:', 'woo-price-history'), $output);
			$output = str_replace("{content_h2_second}", __('Enter your email address to continue:', 'woo-price-history'), $output);
			$output = str_replace("{placeholder_1}", __('Example: 25', 'woo-price-history'), $output);
			$output = str_replace("{placeholder_2}", __('Enter Your Email Address Here', 'woo-price-history'), $output);
			$output = str_replace("{gdpr_text}", __('I agree with storing my email address to send notifications related to lowering the price of the following product.', 'woo-price-history'), $output);
			$output = str_replace("{button_1}", __('Create Price Alert', 'woo-price-history'), $output);
			$output = str_replace("{db_removal}", __('Request e-mail removal', 'woo-price-history'), $output);
			$output = str_replace("{db_removal_2}", __('*fill out your email address in the input above before clicking on this button', 'woo-price-history'), $output);
			$output = str_replace("{notify_text}", __('Notify me when the price changes?', 'woo-price-history'), $output);
			$output = str_replace("{notify_link_text}", __('Setup Price Drop Alert', 'woo-price-history'), $output);
			$output = str_replace("{content_h3_first}", __('Price History:', 'woo-price-history'), $output);
			$output = str_replace("{content_h3_second}", __('Last 5 price changes:', 'woo-price-history'), $output);
			$output = str_replace("{last_month}", __('Last month', 'woo-price-history'), $output);
			$output = str_replace("{last_three_months}", __('Last 3 months', 'woo-price-history'), $output);
			$output = str_replace("{last_six_months}", __('Last 6 months', 'woo-price-history'), $output);
			$output = str_replace("{last_nine_months}", __('Last 9 months', 'woo-price-history'), $output);
			$output = str_replace("{type}", __('Type', 'woo-price-history'), $output);
			$output = str_replace("{price}", __('Price', 'woo-price-history'), $output);
			$output = str_replace("{date}", __('Date', 'woo-price-history'), $output);
			$output = str_replace("{when}", __('When', 'woo-price-history'), $output);
			
			
			
			
			
			// concatenate the template output to the main html content
			$html[] = $output;
			
			$html[] = '<script type="text/javascript" src="' . ( $wooPriceHistory->cfg['paths']["design_dir_url"] ) . '/price.app.js"></script>';
			$html[] = '<script type="text/javascript">priceHistory.setAjaxurl( "' . ( admin_url('admin-ajax.php') ) . '" );</script>';
			
			return implode("\n", $html);
		} 
	}
	
	/**
	 * instantiate class
	 */
	new wooPriceHistoryPriceEvolutionProductTab();

}

