<?php
/*
* Define class wooPriceHistoryMainInterface
* Make sure you skip down to the end of this file, as there are a few
* lines of code that are very important.
*/
!defined('ABSPATH') and exit;
if (class_exists('wooPriceHistoryMainInterface') != true) {
    class wooPriceHistoryMainInterface
    {
        /*
        * Some required plugin information
        */
        const VERSION = '1.0';

        /*
        * Store some helpers config
        */
		public $the_plugin = null;

		private $module_folder = '';
		private $price_update = null;
		private $db_table;

		static protected $_instance;

        /*
        * Required __construct() function that initalizes the AA-Team Framework
        */
        public function __construct()
        {
        	global $wooPriceHistory;
			
        	$this->the_plugin = $wooPriceHistory;
			$this->module_folder = $this->the_plugin->cfg['paths']['plugin_dir_url'] . 'modules/config/';
			
			add_action( 'save_post', array( $this, 'post_save' ) );
			
			require_once( $this->the_plugin->cfg['paths']['scripts_dir_path'] . '/prices_update/prices.class.php' );
			$this->price_update = new wooPriceHistoryPricesUpdates( $this->the_plugin );
			
			require_once( 'product-tabs.php' );
			
			$this->db_table = $this->the_plugin->db->prefix . 'price_evolution';
			
			// ajax optimize helper
			add_action('wp_ajax_wooPriceHistoryAjax', array( &$this, 'request' ));
			add_action('wp_ajax_nopriv_wooPriceHistoryAjax', array( &$this, 'request' ));
			
			add_action( 'woocommerce_before_single_product', array( &$this, 'extra_price_html_hook' ));
			
			if (is_admin()) {
	            add_action('admin_menu', array( &$this, 'adminMenu' ));
			}
        }
		
		/**
	    * Hooks
	    */
	    static public function adminMenu()
	    {
	       self::getInstance()
	    		->_registerAdminPages();
	    }

	    /**
	    * Register plug-in module admin pages and menus
	    */
		protected function _registerAdminPages()
    	{
    		add_submenu_page(
    			$this->the_plugin->alias,
    			$this->the_plugin->alias . " " . __('Alert Subscribers', 'woo-price-history'),
	            __('Alert Subscribers', 'woo-price-history'),
	            'manage_options',
	            'admin.php?page=' . $this->the_plugin->alias . "_alertSubscribers",
	            array($this, 'display_index_page')
	        );

			return $this;
		}

		public function display_index_page()
		{
			$this->printBaseInterface();
		}
		
		/*
		* printBaseInterface, method
		* --------------------------
		*
		* this will add the base DOM code for you options interface
		*/
		private function printBaseInterface()
		{
			global $wpdb;
?>
		<script type="text/javascript" src="<?php echo $this->module_folder;?>app.class.js" ></script>
		<div id="wooPriceHistory-wrapper" class="fluid wrapper-wooPriceHistory">
			<div id="wooPriceHistory-lightbox-overlay">
				<div id="wooPriceHistory-lightbox-container">
					<h1 class="wooPriceHistory-lightbox-headline">
						<img class="wooPriceHistory-lightbox-icon" src="<?php echo $this->the_plugin->cfg['paths']['freamwork_dir_url'];?>images/light-bulb.png">
						<span><?php _e('Details:', 'woo-price-history');?></span>
						<a href="#" class="wooPriceHistory-close-btn" title="Close Lightbox"></a>
					</h1>

					<div class="wooPriceHistory-seo-status-container">
						<div id="wooPriceHistory-lightbox-seo-report-response"></div>
						<div style="clear:both"></div>
					</div>
				</div>
			</div>

			<!-- Main loading box -->
			<div id="wooPriceHistory-main-loading">
				<div id="wooPriceHistory-loading-overlay"></div>
				<div id="wooPriceHistory-loading-box">
					<div class="wooPriceHistory-loading-text"><?php _e('Loading', 'woo-price-history');?></div>
					<div class="wooPriceHistory-meter wooPriceHistory-animate" style="width:86%; margin: 34px 0px 0px 7%;"><span style="width:100%"></span></div>
				</div>
			</div>

			<!-- Header -->
			<div id="wooPriceHistory-header">

				<div id="wooPriceHistory-header-bottom">
					<!-- Container -->
					<div class="wooPriceHistory-container clearfix"></div>
				</div>
			</div>

			<!-- Content -->
			<div id="wooPriceHistory-content">

				<!-- Container -->
				<div class="wooPriceHistory-container clearfix">

					<!-- Main Content Wrapper -->
					<div id="wooPriceHistory-content-wrap" class="clearfix" style="padding-top: 20px;">

						<!-- Content Area -->
						<div id="wooPriceHistory-content-area">
							<div class="wooPriceHistory-grid_4">
	                        	<div class="wooPriceHistory-panel">
	                        		<div class="wooPriceHistory-panel-header">
										<span class="wooPriceHistory-panel-title">
											<img src="<?php echo $this->module_folder;?>/assets/menu_icon.png">
											<?php _e('Drop price subscriber list', 'woo-price-history');?>
										</span>
									</div>
									<div class="wooPriceHistory-panel-content">
										<form class="wooPriceHistory-form" id="1" action="#save_with_ajax">
											<div class="wooPriceHistory-form-row wooPriceHistory-table-ajax-list" id="wooPriceHistory-table-ajax-response">
											<?php
											wooPriceHistoryAjaxListTable::getInstance( $this->the_plugin )
												->setup(array(
													'id' 				=> 'wooPriceHistoryPriceAlert',
													'custom_table'		=> "price_alert",
													'custom_table_force_action' => true,
													//'deleted_field'		=> true,
													'show_header' 		=> true,
													'items_per_page' 	=> '10',
													'post_statuses' 	=> 'all',
													'columns'			=> array(
														'checkbox'	=> array(
															'th'	=>  'checkbox',
															'td'	=>  'checkbox',
														),

														'id'		=> array(
															'th'	=> __('ID', 'woo-price-history'),
															'td'	=> '%id%',
															'width' => '40'
														),
														
														'product_id'		=> array(
															'th'	=> __('Product ID', 'woo-price-history'),
															'td'	=> '%product_id%',
															'width' => '70'
														),
														
														'current_price'		=> array(
															'th'	=> __('Current price', 'woo-price-history'),
															'td'	=> '%current_price%',
															'width' => '70'
														),
														
														'drop_price'		=> array(
															'th'	=> __('Drop price', 'woo-price-history'),
															'td'	=> '%drop_price%',
															'width' => '70'
														),
														
														'notification_send'		=> array(
															'th'	=> __('Sent notifications', 'woo-price-history'),
															'td'	=> '%notification_send%',
															'align' => 'center',
															'width' => '100'
														),

														'email'	=> array(
															'th'	=> __('Email', 'woo-price-history'),
															'td'	=> '%email%',
															'align' => 'left',
														),
														

														'added_date'		=> array(
															'th'	=> __('Date', 'woo-price-history'),
															'td'	=> '%added_date%',
															'align' => 'center',
															'width' => '180'
														),
													),
													'mass_actions' 	=> array(
														'delete_alert_rows' => array(
															'value' => __('Delete selected rows', 'woo-price-history'),
															'action' => 'do_bulk_delete_alert_rows',
															'color' => 'red'
														),
														'export_alert_rows' => array(
															'value' => __('Export e-mail addresses', 'woo-price-history'),
															'action' => 'do_bulk_export_emails_alert_rows',
															'color' => 'green'
														)
													)
												))
												->print_html();
								            ?>
								            </div>
							            </form>
				            		</div>
								</div>
							</div>
							<div class="clear"></div>
						</div>
					</div>
				</div>
			</div>
		</div>

<?php
		}
		
		public function extra_price_html_hook()
		{   
			//add_filter( 'woocommerce_price_html', array( &$this, 'extra_price_html' ));
		}
		
		public function extra_price_html( $html )
		{
			echo $html . '<a href="#view_price_history" class="wooPriceHistory"> View Price History </a>';
		}
		
		public function array_to_csv_download($array, $filename = "export.csv", $delimiter=";") {
			header('Content-Type: application/csv');
			header('Content-Disposition: attachment; filename="'.$filename.'";');

			// open the "output" stream
			// see http://www.php.net/manual/en/wrappers.php.php#refsect2-wrappers.php-unknown-unknown-unknown-descriptioq
			$f = fopen('php://output', 'w');
			
			foreach ($array as $line) {
				fputcsv($f, $line, $delimiter);
			}
		}   
		
		public function request()
		{
			$request = array(
				'subaction' => isset($_REQUEST['subaction']) ? $_REQUEST['subaction'] : '',
				'product'	=> isset($_REQUEST['product']) ? (int)$_REQUEST['product'] : 0,
				'period'	=> isset($_REQUEST['period']) ? (int)$_REQUEST['period'] : 1,
			);
			
			if( $request['product'] > 0 && $request['subaction'] == 'getGraph' && $request['period'] > 0 ){
				$json_array = array();
				
				// get the select from DB
				$results = $this->the_plugin->db->get_results("SELECT * FROM " . $this->db_table . " WHERE 1=1 AND product_id='" . ( $request['product'] ) . "' AND added_date BETWEEN SUBDATE(CURDATE(), INTERVAL " . ( $request['period'] ) . " MONTH) AND NOW();", ARRAY_A);
				 
				if( $results ){
					
					$json_array['cols'] = array(
						array(
							'id' => 'timestamp',
							'label' => 'Date',
							'type' => 'date',
						),
						array(
							'id' => 'price',
							'label' => 'Price',
							'type' => 'number',
						)
					); 
					
					foreach ($results as $key => $value) {
						$date = explode("-", $value['report_day']);
						
						$price_forrmat = strip_tags( wc_price( $value['price'] ) );
						$json_array['rows'][] = array(
							'date' => array(
								'year' => $date[0],
								'month' => $date[1]-1,
								'day' => $date[2]
							),
							'price' => array(
								'value' => $value['price'],
								'text' => $price_forrmat
							)
						);
					}
				}
				
				
				die( json_encode(array(
					'status' => count($json_array) > 0 ? 'valid' : 'invalid',
					'json' => $json_array
				)) ); 
			}
			
			if( $request['product'] > 0 && $request['subaction'] == 'saveAlert' ){
				$email = isset($_REQUEST['email']) ? $_REQUEST['email'] : '';
				$drop_price = isset($_REQUEST['min_price']) ? (float)$_REQUEST['min_price'] : 0;
				
				$this->the_plugin->db->insert(
					$this->the_plugin->db->prefix . 'price_alert',
					array( 
						'product_id' => $request['product'], 
						'drop_price' => $drop_price,
						'email' => $email
					), 
					array( 
						'%d', 
						'%s',
						'%s' 
					) 
				);
				
				die( json_encode(array(
					'status' => 'valid'
				) ) );
			}
			
			if( $request['subaction'] == 'deleteEmailFromDb' ){
				
				$email = $_REQUEST['email'];
				
				if( isset( $email ) ){
					$this->the_plugin->db->delete( $this->the_plugin->db->prefix . 'price_alert', array( 'email' => trim($email) ) );
				}
				
				die( json_encode(array(
					'status' => 'valid'
				) ) );
			}
			
			if( $request['subaction'] == 'deleteAlert' && is_admin() ){
				
				$ids = isset($_REQUEST['id']) ? explode(",", $_REQUEST['id']) : array();
				
				if( count($ids) > 0 ){
					foreach ($ids as $key => $value) {
						$this->the_plugin->db->delete( $this->the_plugin->db->prefix . 'price_alert', array( 'ID' => trim((int) $value) ) );
					}
				}
				
				die( json_encode(array(
					'status' => 'valid'
				) ) );
			}
			
			if( $request['subaction'] == 'exportEmailsAlert' && is_admin() ){
				
				$results = $this->the_plugin->db->get_results( "SELECT email FROM " . $this->the_plugin->db->prefix . "price_alert", ARRAY_A);
				$emails = array();
				foreach ( $results as $result ) {
					$emails[] = $result['email'];
				}
				$emails = array_unique($emails);
				
				$arr_csv = array();
				foreach( $emails as $email ) {
					$arr_csv[] = array($email);
				}
				
				$this->array_to_csv_download($arr_csv,"WooPriceHistoryEmails.csv", ";");	
				
				exit();
			}
			
			
			
			die( json_encode(array(
				'status' => 'invalid'
			) ) );
		}
		
		// save the new price data 
		public function post_save()
		{
			if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) 
    			return $post_id;
			
			// if is not woo products
			$post_type = isset( $_POST["post_type"] ) ? $_POST["post_type"] : '';
			if( !isset($post_type) && $post_type != 'product' ){
				return;
			}
			
			$lowesPrice = isset($_POST["_regular_price"]) && trim($_POST["_regular_price"]) != "" ? $_POST["_regular_price"] : '';
			$lowesPrice = isset($_POST["_sale_price"]) && trim($_POST["_sale_price"]) != "" ? $_POST["_sale_price"] : $lowesPrice;
			
			if( trim($lowesPrice) != "" && (int) $_POST['post_ID'] > 0 ){
				$this->price_update->update_product_price( (int)$_POST['post_ID'], $lowesPrice );
			}
			
			// check if need to send some price alert
			$alerts = $this->the_plugin->db->get_results( "SELECT * from " . $this->the_plugin->db->prefix . "price_alert WHERE 1=1
				AND product_id='" . ( (int)$_POST['post_ID'] ) . "' AND drop_price >=" . ( (int)$lowesPrice ) . " GROUP BY email
			", ARRAY_A  );
			if( $alerts != false && count($alerts) > 0 ){
				foreach ($alerts as $key => $value) {
					$this->send_email_notification( $value, $lowesPrice );
				}
			}
		}

		private function send_email_notification( $alert, $new_price )
		{
			
			// get the email template
			ob_start();
			require_once( $this->the_plugin->cfg['paths']["design_dir_path"] . '/email.html' );
			$output = ob_get_contents();
			ob_end_clean();
			
			// get the product by id
			$product = get_post( $alert['product_id'], ARRAY_A );
			
			// start make the replacements 
			$output = str_replace("{product_excerpt}", @nl2br($product['post_excerpt']), $output);
			$output = str_replace("{product_name}", $product['post_title'], $output);
			$output = str_replace("{subscribe_date}", $alert['added_date'], $output);
			$output = str_replace("{product_url}", get_permalink($product['ID']), $output);
			$output = str_replace("{website_name}", get_bloginfo('name'), $output);
			$output = str_replace("{website_address}", get_bloginfo('url') , $output);
			$output = str_replace("{current_product_price}", wc_price($new_price), $output);
			
			$output = str_replace("{price_drop_notification}", __('Price Drop Notification:', 'woo-price-history'), $output);
			$output = str_replace("{good_news}", __('Good news!', 'woo-price-history'), $output);
			$output = str_replace("{signed_up}", __('You`ve signed up for a price drop notification on the following product:', 'woo-price-history'), $output);
			$output = str_replace("{item_now}", __('The item Price is now:', 'woo-price-history'), $output);
			$output = str_replace("{check_offer}", __('Check the Offer Now!', 'woo-price-history'), $output);
			$output = str_replace("{you_signed}", __('You signed up for price drop alert from', 'woo-price-history'), $output);
			$output = str_replace("{at}", __('at:', 'woo-price-history'), $output);
			
			// product image URL
			$image = wp_get_attachment_image_src( get_post_thumbnail_id( $product['ID'] ), 'large' );
			$output = str_replace("{product_image_url}", $image[0], $output);
			
			add_filter( "wp_mail_content_type", array( $this, "set_html_content_type" ) );
			wp_mail ( $alert['email'], '[' . ( get_bloginfo('name') ) . '] Price Drop Alert', $output );
			
			// update notification sent count
			$this->the_plugin->db->query("UPDATE " . $this->the_plugin->db->prefix . "price_alert" . " SET notification_send = notification_send + 1 WHERE 1=1 and id='" . $alert['id'] . "' ");
		}

		function set_html_content_type() 
		{
			return "text/html";
		}

		/**
	    * Singleton pattern
	    *
	    * @return wooPriceHistoryMainInterface Singleton instance
	    */
	    static public function getInstance()
	    {
	        if (!self::$_instance) {
	            self::$_instance = new self;
	        }

	        return self::$_instance;
	    }
    }
}

// Initialize the wooPriceHistoryMainInterface class
new wooPriceHistoryMainInterface();