/*
Document   :  alert Monitor
Author     :  Andrei Dinca, AA-Team http://codecanyon.net/user/AA-Team
*/

// Initialization and events code for the app
wooPriceHistoryalertMonitor = (function ($) {
    "use strict";

    // public
    var debug_level = 0;
    var maincontainer = null;
    var loading = null;
    var loaded_page = 0;

	// init function, autoload
	(function init() {
		// load the triggers
		$(document).ready(function(){
			maincontainer = $("#wooPriceHistory-wrapper");
			loading = maincontainer.find("#wooPriceHistory-main-loading");

			triggers();
		});
	})();
	
	function delete_alert_rows() {
		var ids = [], __ck = $('.wooPriceHistory-form .wooPriceHistory-table input.wooPriceHistory-item-checkbox:checked');
		__ck.each(function (k, v) {
			ids[k] = $(this).attr('name').replace('wooPriceHistory-item-checkbox-', '');
		});
		ids = ids.join(',');
		if (ids.length<=0) {
			alert('You didn\'t select any rows!');
			return false;
		}

		jQuery.post(ajaxurl, {
			'action' 		: 'wooPriceHistoryAjax',
			'subaction'		: 'deleteAlert',
			'id'			: ids,
			'debug_level'	: debug_level
		}, function(response) {
			loading.hide();
			if( response.status == 'valid' ){
				//refresh page!
				window.location.reload();
				return false;
			}
			alert('Problems occured while trying to delete the selected rows!');
		}, 'json');
	}
	
	function export_emails_alert_rows(){
		document.location.href = ajaxurl + '?action=wooPriceHistoryAjax&subaction=exportEmailsAlert';
	}

	function triggers()
	{
		maincontainer.on('click', '#wooPriceHistory-do_bulk_delete_alert_rows', function(e){
			e.preventDefault();

			if (confirm('Are you sure you want to delete the selected rows?'))
				delete_alert_rows();
		});
		
		maincontainer.on('click', '#wooPriceHistory-do_bulk_export_emails_alert_rows', function(e){
			e.preventDefault();
			export_emails_alert_rows();
		});
		
		//all checkboxes are checked by default!
		$('.wooPriceHistory-form .wooPriceHistory-table input.wooPriceHistory-item-checkbox').attr('checked', 'checked');
		
	}

	// external usage
	return {
    }
})(jQuery);
