<?php
/**
 * Init wooPriceHistoryPricesUpdates
 * http://www.aa-team.com
 * ======================
 *
 * @author		Andrei Dinca, AA-Team
 * @version		1.0
 */
if( !class_exists('wooPriceHistoryPricesUpdates') ){

	class wooPriceHistoryPricesUpdates
	{
		/**
		 * wooPriceHistory
		 *
		 * @var array
		 */
		private $the_plugin = null;
	
		/**
		 * wooPriceHistory
		 *
		 * @var db
		 */
		private $db_table = null;
	
		/**
		 * @params main class object
		 */
		public function __construct($the_plugin)
		{
			$this->the_plugin = $the_plugin;
			
			$this->db_table = $this->the_plugin->db->prefix . 'price_evolution';
		}
		
		public function update_product_price ( $ID=0, $price='' )
		{
			if( $ID > 0 && trim($price) != "" ){
				
				// check if product has price setup for today, if have just overwrite it
				$product = (int) $this->the_plugin->db->get_var("SELECT product_id FROM " . $this->db_table . " WHERE 1=1 and product_id='" . ( $ID ) . "' and DATE(report_day) = CURDATE()");
				
				// add new product
				if( $product == 0 ){
					$this->the_plugin->db->insert(
						$this->db_table, 
						array( 
							'product_id' => $ID, 
							'price' => $price,
							'report_day' => date( 'Y-m-d' )
						), 
						array( 
							'%d', 
							'%s',
							'%s'
						) 
					);
				}
				
				// update the product
				else{
					$this->the_plugin->db->update(
						$this->db_table, 
						array( 
							'price' => $price
						),
						array( 
							'product_id' => $ID,
							'report_day' => date( 'Y-m-d' )
						), 
						array( 
							'%s'
						),
						array( '%d', '%s' ) 
					);
				}
			}
		}
		
		
	}
}