/*
Document   :  Price History Class
Author     :  Andrei Dinca, AA-Team http://codecanyon.net/user/AA-Team
*/
// Initialization and events code for the app
priceHistory = (function ($) {
    "use strict";

    // public
    var debug_level = 0;
    var maincontainer = null;
    var loading = null;
    var lightbox_container = null;
    var ajaxurl = null;
   
	// init function, autoload
	(function init() {
		// load the triggers
		maincontainer = $("#ph_chart_container");
		loading = maincontainer.find('#ajaxLoader');
		
		// load the graph
		google.setOnLoadCallback( drawChart );
		
		lightbox_container = maincontainer.find("#ph_notify_container");
		
		triggers();
	})();
	
	function setAjaxurl( url )
	{
		ajaxurl = url;
	}
	
	function showNotifyBox()
	{
		lightbox_container.fadeIn('fast');
		
		lightbox_container.on('click', 'a.close_btn', function(e){
			e.preventDefault();
			lightbox_container.fadeOut('fast');
		})
	}
	
	function drawChart() 
	{
		var chartWidth = $(".woocommerce-tabs").width();
		loading.show();
		jQuery.post(ajaxurl, {
			'action' : 'wooPriceHistoryAjax',
			'subaction': 'getGraph',
			'product' : maincontainer.data('product'),
			'period' : maincontainer.find('.data-range-selector').val()
		}, function(response) {
			
			
			if( response.status == 'valid' ){
				var data = new google.visualization.DataTable()
				
				response = response.json;
				
				//console.log( response  );
				
				$.each(response.cols, function(key, value){
					data.addColumn( value.type, value.label);
				});
				
				var rows = {};
				$.each(response.rows, function(key, value){
					var price = $('<textarea/>').html(value.price.text ).text();
					console.log( value  );
					//value.price.text = value.price.text.replace("&pound;", "£");
					
					value.price.text = price;
					
					data.addRow([
						new Date( value.date.year, value.date.month, value.date.day ), 
						{
							v: parseFloat(value.price.value), 
							f: value.price.text
						}
					]);
					
					console.log( data  );
				});
				
				const oneDay = (1000 * 60 * 60 * 24);
				let hAxisTicks = [];
				let dateRange = data.getColumnRange(0);
				for (var i = dateRange.min.getTime(); i <= dateRange.max.getTime(); i = i + oneDay) {
				  hAxisTicks.push(new Date(i));
				}
				
				//console.log( hAxisTicks  );
				//return;
				
				
				var options = {
					width: chartWidth - 50,
					height: 300,
					pointSize: 11,
					lineWidth: 1,
					curveType: 'function',
					chartArea: {
						'left': 50,
						'width': chartWidth - 50
					},
					colors: ['#00cb8f'],
					legend: 'none',
					hAxis: {
						format: 'MMM dd YYYY',
						ticks: hAxisTicks
					}
				};
				
				console.log( data  );
		
				var chart = new google.visualization.LineChart(document.getElementById('price_chart'));
				chart.draw(data, options);
			}
			
			loading.hide();
		}, 'json');
		
	}
	
	function checkMail(email)
	{
	    var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
	    if (filter.test(email)) {
	   		return true;
	    }
	    
	    alert('Invalid Email Address');
	    return false;
    }
	
	function isNumber(n) {
		return !isNaN(parseFloat(n)) && isFinite(n);
	}

	function validateDropPrice(drop_price)
	{
		if( !isNumber(drop_price) ){
			alert('Invalid Drop Price');
		}
		
		return true;
	}
	
	function delete_email_from_db(){
		var email = $('#ph_price_alert #email').val();
		
		if( !checkMail(email) ){
			loading.hide();
			return false;
		}
		
		if (confirm("Are you sure you want us to remove your e-mail address from our Price Notification database?")) {
			jQuery.post(ajaxurl, {
				'action' : 'wooPriceHistoryAjax',
				'subaction': 'deleteEmailFromDb',
				'email' : email
			}, function(response) {
				if( response.status == 'valid' ){
					alert('Your e-mail address has been successfully removed from our Price Notification database!');
					loading.hide();
					lightbox_container.fadeOut('fast');
				}
				
			}, 'json');
		}
	}
		
	function save_price_alert( that )
	{
		loading.show();
		
		var min_price = that.find('#price_lower_than').val();
		var email = that.find('#email').val();
		 
		if( !validateDropPrice(min_price) ){
			loading.hide();
			return false;
		}
		
		if( $('#gdpr_compliance:checked').length == 0 ){
			alert('In order to receive price alerts you must agree to store your e-mail address in our database.');
			loading.hide();
			return false;
		}
		
		if( !checkMail(email) ){
			loading.hide();
			return false;
		}
		
		
		jQuery.post(ajaxurl, {
			'action' : 'wooPriceHistoryAjax',
			'subaction': 'saveAlert',
			'product' : maincontainer.data('product'),
			'min_price': min_price,
			'email' : email
		}, function(response) {
			if( response.status == 'valid' ){
				alert('Your details has successfully saved!');
				loading.hide();
				lightbox_container.fadeOut('fast');
			}
			
		}, 'json');
	}
	
	function open_price_history_tab()
	{
		var $tab = $('.wooPriceHistory_price_history_tab a');
		var $tabs_wrapper = $tab.closest('.woocommerce-tabs');

		$('ul.tabs li', $tabs_wrapper).removeClass('active');
		$('div.panel', $tabs_wrapper).hide();
		$('div' + $tab.attr('href'), $tabs_wrapper).show();
		$tab.parent().addClass('active');
		
		var pos = $('.woocommerce-tabs').position();
		$('html, body').stop().animate({
        	scrollTop: pos.top + 150
   		}, 400);
	}
	
	function triggers()
	{
		maincontainer.on('click', '.ph_open_lightbox', function(e){
			e.preventDefault();
			
			showNotifyBox();
		});
		
		maincontainer.on('click', 'button#db_removal', function(e){
			e.preventDefault();
			
			delete_email_from_db();
		});
		
		maincontainer.on('submit', '#ph_price_alert', function(e){
			e.preventDefault();
			
			save_price_alert( $(this) );
		});
		
		maincontainer.on('change', '.data-range-selector', function(e){
			e.preventDefault();
			
			drawChart();
		});
		
		$('body').on('click', 'a.wooPriceHistory', function(e){
			e.preventDefault();
			
			open_price_history_tab();
		});
		
		/*setTimeout( function(){
			$('.ph_open_lightbox,a.wooPriceHistory').click();
		}, 600);*/
	}
	// external usage
	return {
		"setAjaxurl": setAjaxurl
    }
})(jQuery);