<?php
/*
* Define class aaInterfaceTemplates
* Make sure you skip down to the end of this file, as there are a few
* lines of code that are very important.
*/
! defined( 'ABSPATH' ) and exit;

if(class_exists('aaInterfaceTemplates') != true) {

	class aaInterfaceTemplates {

		/*
		* Some required plugin information
		*/
		const VERSION = '1.0';
		
		/*
		* Store some helpers config
		* 
		*/
		public $cfg	= array();

		/*
		* Required __construct() function that initalizes the AA-Team Framework
		*/
		public function __construct($cfg) 
		{
			$this->cfg = $cfg;   
		}
		
		
		/*
		* bildThePage, method
		* -------------------
		*
		* @params $options = array (requiered)
		* @params $alias = string (requiered)
		* this will create you interface via options array elements
		*/
		public function bildThePage ( $options = array(), $alias='', $module=array(), $showForm=true ) 
		{
			global $wooPriceHistory;
			
			// reset as array, this will stock all the html content, and at the end return it
			$html = array();
			
			if(count($options) == 0) {
				return 'Please fill whit some options content first!';
			}
			
			$noRowElements = array('message', 'html', 'app');
			
			foreach ( $options as $theBoxs ) {
				
				// loop the all the boxs
				foreach ( $theBoxs as $box_id => $box ){
					
					$box_id = $alias . "_" . $box_id;
					$settings = array();
					
					// get the values from DB
					$dbValues = get_option($box_id);
					
					// check if isset and string have content
					if(isset($dbValues) && trim($dbValues) != ""){
						$settings = unserialize($dbValues);
					}
					
					// create defalt setup for each header, prevent php notices
					if(!isset($box['header'])) $box['header']= false;
					if(!isset($box['toggler'])) $box['toggler']= false;
					if(!isset($box['buttons'])) $box['buttons']= false;
					if(!isset($box['style'])) $box['style']= 'panel';
					
					// container setup
					$html[] = '<div class="wooPriceHistory-' . ( $box['size'] ) . '">
                        	<div class="wooPriceHistory-' . ( $box['style'] ) . '">';
							
					// hide panel header only if it's requested
					if( $box['header'] == true ) {
						$html[] = '<div class="wooPriceHistory-panel-header">
							<span class="wooPriceHistory-panel-title">
								' . ( isset($box['icon']) ? '<img src="' . ( $box['icon'] ) . '" />' : '' ) . '
								' . ( $box['title'] ) . '
							</span>
							 ' . ( $box['toggler'] == true ? '<span class="wooPriceHistory-panel-toggler"></span>' : '' ) . '
						</div>';
					}
						
					$html[] = '<div class="wooPriceHistory-panel-content">';
					if($showForm){
						$html[] = '<form class="wooPriceHistory-form" id="' . ( $box_id ) . '" action="#save_with_ajax">';
					}
					
					// create a hidden input for sending the prefix
					$html[] = '<input type="hidden" id="box_id" name="box_id" value="' . ( $box_id ) . '" />';
					
					$html[] = '<input type="hidden" id="box_nonce" name="box_nonce" value="' . ( wp_create_nonce( $box_id . '-nonce') ) . '" />';  
					
					// loop the box elements
					if(count($box['elements']) > 0){
					
						// loop the box elements now
						foreach ( $box['elements'] as $elm_id => $value ){

							// some helpers. Reset an each loop, prevent collision
							$val = '';
							$select_value = '';
							$checked = '';
							$option_name = isset($option_name) ? $option_name : '';
							
							// Set default value to $val
							if ( isset( $value['std']) ) {
								$val = $value['std'];
							}
							
							// If the option is already saved, ovveride $val
							if ( ( $value['type'] != 'info' ) ) {
								if ( isset($settings[($elm_id)] ) ) {
										$val = $settings[( $elm_id )];
										
										// Striping slashes of non-array options
										if ( !is_array($val) ) {
											$val = stripslashes( $val );
											if($val == '') $val = true;
										}
								}
							}
							
							// If there is a description save it for labels
							$explain_value = '';
							if ( isset( $value['desc'] ) ) {
								$explain_value = $value['desc'];
							}
							
							if(!in_array( $value['type'], $noRowElements)){
								// the row and the label 
								$html[] = '<div class="wooPriceHistory-form-row">
									   <label for="' . ( $elm_id ) . '">' . ( $value['title'] ) . '</label>
									   <div class="wooPriceHistory-form-item'. ( isset($value['size']) ? " " . $value['size'] : '' ) .'">';
							}
							
							// the element description
							if(isset($value['desc'])) $html[]	= '<span class="formNote">' . ( $value['desc'] ) . '</span>';
							
							switch ( $value['type'] ) {
								
								// Basic text input
								case 'text':
									$html[] = '<input ' . ( isset($value['force_width']) ? "style='width:" . ( $value['force_width'] ) . "px;'" : '' ) . ' id="' . esc_attr( $elm_id ) . '" name="' . esc_attr( $option_name . $elm_id ) . '" type="text" value="' . esc_attr( $val ) . '" />';
								break;
								
								// Basic checkbox input
								case 'checkbox':
									$html[] = '<input ' . ( isset($value['force_width']) ? "style='width:" . ( $value['force_width'] ) . "px;'" : '' ) . ' ' . ( $val == true ? 'checked' : '' ). ' id="' . esc_attr( $elm_id ) . '" name="' . esc_attr( $option_name . $elm_id ) . '" type="checkbox" value="" />';
								break;
								
								// Basic upload_image
								case 'upload_image':
									$html[] = '<table border="0">';
									$html[] = '<tr>';
									$html[] = 	'<td>';
									$html[] = 		'<input class="upload-input-text" name="' . ( $elm_id ) . '" id="' . ( $elm_id ) . '_upload" type="text" value="' . ( $val ) . '" />';
									
									$html[] = 		'<script type="text/javascript">
										jQuery("#' . ( $elm_id ) . '_upload").data({
											"w": ' . ( $value['thumbSize']['w'] ) . ',
											"h": ' . ( $value['thumbSize']['h'] ) . ',
											"zc": ' . ( $value['thumbSize']['zc'] ) . '
										});
									</script>';
									
									$html[] = 	'</td>';
									$html[] = '<td>';
									$html[] = 		'<a href="#" class="button upload_button" id="' . ( $elm_id ) . '">' . ( $value['value'] ) . '</a> ';
									$html[] = 		'<a href="#" class="button reset_button ' . $hide . '" id="reset_' . ( $elm_id ) . '" title="' . ( $elm_id ) . '">Remove</a> ';
									$html[] = '</td>';
									$html[] = '</tr>';
									$html[] = '</table>';
									
									$html[] = '<a class="thickbox" id="uploaded_image_' . ( $elm_id ) . '" href="' . ( $val ) . '" target="_blank">';
									
									if(!empty($val)){
										$imgSrc = $wooPriceHistory->image_resize( $val, $value['thumbSize']['w'], $value['thumbSize']['h'], $value['thumbSize']['zc'] );
										$html[] = '<img style="border: 1px solid #dadada;" id="image_' . ( $elm_id ) . '" src="' . ( $imgSrc ) . '" />';
									}
									$html[] = '</a>';
									
								break;
								
								// Basic textarea
								case 'textarea':
									$cols = "120";
									if(isset($value['cols'])) {
										$cols = $value['cols'];
									}
									$height = "style='height:120px;'";
									if(isset($value['height'])) {
										$height = "style='height:{$value['height']};'";
									}
									
									$html[] = '<textarea id="' . esc_attr( $elm_id ) . '" ' . $height . ' cols="' . ( $cols ) . '" name="' . esc_attr( $option_name . $elm_id ) . '">' . esc_attr( $val ) . '</textarea>';
								break;
								
								// Basic html/text message
								case 'message':
									$html[] = '<div class="wooPriceHistory-message wooPriceHistory-' . ( $value['status'] ) . '">' . ( $value['html'] ) . '</div>';
								break;
								
								// buttons
								case 'buttons':
								
									// buttons for each box
									
									if(count($value['options']) > 0){
										foreach ($value['options'] as $key => $value){
											$html[] = '<input 
												type="' . ( $value['type'] ) . '" 
												style="width:' . ( $value['width'] ) . '" 
												value="' . ( $value['value'] ) . '" 
												class="wooPriceHistory-button ' . ( $value['color'] ) . ' ' . ( $value['pos'] ) . ' ' . ( $value['action'] ) . '" 
											/>';
										}
									}
									
								break;
								
								
								// Basic html/text message
								case 'html':
									$html[] = $value['html'];
								break;
								
								// Basic app, load the path of this file
								case 'app':
									
									$tryLoadInterface = str_replace("{plugin_folder_path}", $module["folder_path"], $value['path']);
									
									if(is_file($tryLoadInterface)) {
										// Turn on output buffering
										ob_start();
										
										require_once( $tryLoadInterface  );
										
										//copy current buffer contents into $message variable and delete current output buffer
										$html[] = ob_get_clean();
									}
								break;
								
								// Select Box
								case 'select':
									$html[] = '<select ' . ( isset($value['force_width']) ? "style='width:" . ( $value['force_width'] ) . "px;'" : '' ) . ' name="' . esc_attr( $elm_id ) . '" id="' . esc_attr( $elm_id ) . '">';
									
									foreach ($value['options'] as $key => $option ) {
										$selected = '';
										if( $val != '' ) {
											if ( $val == $key ) { $selected = ' selected="selected"';} 
										}
										$html[] = '<option'. $selected .' value="' . esc_attr( $key ) . '">' . esc_html( $option ) . '</option>';
									 } 
									$html[] = '</select>';
								break;
								
								// multiselect Box
								case 'multiselect':
									$html[] = '<select multiple="multiple" size="3" name="' . esc_attr( $elm_id ) . '[]" id="' . esc_attr( $elm_id ) . '">';
									
									if(count($option) > 1){
										foreach ($value['options'] as $key => $option ) {
											$selected = '';
											if( $val != '' ) {
												if ( in_array($key, $val) ) { $selected = ' selected="selected"';} 
											}
											$html[] = '<option'. $selected .' value="' . esc_attr( $key ) . '">' . esc_html( $option ) . '</option>';
										} 
									}
									$html[] = '</select>';
								break;
								
							}
							
							if(!in_array( $value['type'], $noRowElements)){
								// close: .wooPriceHistory-form-row
								$html[] = '</div>';
								
								// close: .wooPriceHistory-form-item
								$html[] = '</div>';
							}
							
						}
					}
					
					// wooPriceHistory-message use for status message, default it's hidden
					$html[] = '<div class="wooPriceHistory-message" id="wooPriceHistory-status-box" style="display:none;"></div>';
					
					if( $box['buttons'] == true && !is_array($box['buttons']) ) {
						// buttons for each box
						$html[] = '<div class="wooPriceHistory-button-row">
							<input type="reset" value="Reset to default value" class="wooPriceHistory-button gray left" />
							<input type="submit" value="Save the settings" class="wooPriceHistory-button green wooPriceHistory-saveOptions" />
						</div>';
					}
					elseif( is_array($box['buttons']) ){
						// buttons for each box
						$html[] = '<div class="wooPriceHistory-button-row">';
						
						foreach ( $box['buttons'] as $key => $value ){
							$html[] = '<input type="submit" value="' . ( $value['value'] ) . '" class="wooPriceHistory-button ' . ( $value['color'] ) . ' ' . ( $value['action'] ) . '" />';
						}
						
						$html[] = '</div>';
					}
					
					if($showForm){
						// close: form
						$html[] = '</form>';
					}
					
					// close: box size div
					$html[] = '</div>';
					
					// close: .wooPriceHistory-panel
					$html[] = '</div>';
					
					// close: .wooPriceHistory-panel-content
					$html[] = '</div>';
				}
			}
			
			// return the $html
			return implode("\n", $html);
		}

		/*
		* printBaseInterface, method
		* --------------------------
		*
		* this will add the base DOM code for you options interface
		*/
		public function printBaseInterface() 
		{
?>
		<div id="wooPriceHistory-wrapper" class="fluid wrapper-wooPriceHistory">
    
			<!-- Header -->
			<div id="wooPriceHistory-header">
			
				<!--div id="wooPriceHistory-header-top">
					
					
					<div class="wooPriceHistory-container clearfix">
						
						<div id="wooPriceHistory-logo-wrap">
							<div id="wooPriceHistory-logo">
								<div id="wooPriceHistory-logo-img">
									<a href="#">
										<img src="<?php echo $this->cfg['paths']['plugin_dir_url'] . '/icon_80.png';?>" alt="logo" />
									</a>
								</div>
							</div>
						</div>
					</div>
				</div-->
				
				<div id="wooPriceHistory-header-bottom">
					<!-- Container -->
					<div class="wooPriceHistory-container clearfix"> 
						<!-- Breadcrumbs -->
						<div id="wooPriceHistory-topMenu">
							<ul>
								<?php
								if(count($this->cfg['activate_modules']) > 0) {
									foreach ($this->cfg['menu_order'] as $order => $module_alias){
										// skip if module it's not activated
										if(!in_array($module_alias, array_keys($this->cfg['activate_modules']))) continue;
										
										// update the module with rest of information about modue
										$module = $this->cfg['modules'][$module_alias];
										
										$iconImg = '';
										if( isset($module[$module_alias]['menu']['show_in_menu']) && $module[$module_alias]['menu']['show_in_menu'] === false ) continue;
										if( is_file($module['folder_path'] . $module[$module_alias]['menu']['icon']) ) {
											$iconImg = '<img src="' . ( $module['folder_uri'] . $module[$module_alias]['menu']['icon'] ) . '" />';
										}
										
										if( is_file( $module["folder_path"] . 'options.php' ) ) {
											echo '<li id="wooPriceHistory-nav-' . ( $module_alias ) . '">'. ( $iconImg ) .'<a href="#!/' . ( $module_alias ) . '">' . ( $module[$module_alias]['menu']['title'] ) . '</a></li>';
										}
									}
								} 
								?>
							</ul>
						</div>
						
					</div>
				</div>
			</div>
		
			<!-- Content -->
			<div id="wooPriceHistory-content">
				
				<!-- Container -->
				<div class="wooPriceHistory-container clearfix">
				
					<!-- Main Content Wrapper -->
					<div id="wooPriceHistory-content-wrap" class="clearfix">
					
						<!-- Content Area -->
						<div id="wooPriceHistory-content-area">
							<!-- Content Area -->
							<div id="wooPriceHistory-ajax-response"></div>
							
							<div class="clear"></div>
						</div>
					</div>
				</div>
			</div>
		</div>

<?php
		}
	}
}