/*

    Document   :  wooPriceHistory

    Created on :  August, 2012

    Author     :  Andrei Dinca, AA-Team http://codecanyon.net/user/AA-Team

*/
(function ($) {
	"use strict";
    jQuery.fn.wooPriceHistory = function (options) {
        var defaults = {
            prefix: ''
        };
        var option = jQuery.extend({},
        defaults, options);
		
        return this.each(function () {
            var t = jQuery("div.wrapper-" + option.prefix),
                ajaxBox = t.find('#wooPriceHistory-ajax-response'),
                section = 'dashboard',
                topMenu = t.find('#wooPriceHistory-topMenu');
            var plugin = {
                init: function () { // loading products list
                    if (option.page == 'home') {
                        plugin.request.listProducts();
                    }
                    plugin.triggers();
                    plugin.fixLayoutHeight();
                },
                ajaxLoading: function (status) {
                    var loading = jQuery('<div id="wooPriceHistory-ajaxLoadingBox" class="wooPriceHistory-panel-widget">loading</div>'); // append loading
                    ajaxBox.html(loading);
                },
                makeRequest: function () {
                    plugin.ajaxLoading();
                    var data = {
                        'action': 'wooPriceHistoryLoadSection',
                        'section': section
                    }; // since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
                    jQuery.post(ajaxurl, data, function (response) {
                        if (response.status == 'ok') {
                            ajaxBox.html(response.html);
                            topMenu.find('li.active').removeClass('active');
                            topMenu.find('li#wooPriceHistory-nav-' + section).addClass('active');
                        }
                    },
                    'json');
                },
                installDefaultOptions: function ($btn) {
                    var theForm = $btn.parents('form').eq(0),
                        value = $btn.val(),
                        statusBoxHtml = theForm.find('div.wooPriceHistory-message'); // replace the save button value with loading message
                    $btn.val('installing default settings ...').removeClass('blue').addClass('gray');
                    if (theForm.length > 0) { // serialiaze the form and send to saving data
                        var data = {
                            'action': 'wooPriceHistoryInstallDefaultOptions',
                            'options': theForm.serialize()
                        }; // since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
                        jQuery.post(ajaxurl, data, function (response) {
                            if (response.status == 'ok') {
                                statusBoxHtml.addClass('wooPriceHistory-success').html(response.html).fadeIn().delay(3000).fadeOut();
                                setTimeout(function () {
                                    window.location.reload()
                                },
                                2000);
                            } else {
                                statusBoxHtml.addClass('wooPriceHistory-error').html(response.html).fadeIn().delay(13000).fadeOut();
                            } // replace the save button value with default message
                            $btn.val(value).removeClass('gray').addClass('blue');
                        },
                        'json');
                    }
                },
                saveOptions: function ($btn) {
                    var theForm = $btn.parents('form').eq(0),
                        value = $btn.val(),
                        statusBoxHtml = theForm.find('div#wooPriceHistory-status-box'); // replace the save button value with loading message
                    $btn.val('saving setings ...').removeClass('green').addClass('gray');
                    if (theForm.length > 0) { // serialiaze the form and send to saving data
                        var data = {
                            'action': 'wooPriceHistorySaveOptions',
                            'options': theForm.serialize()
                        }; // since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
                        jQuery.post(ajaxurl, data, function (response) {
                            if (response.status == 'ok') {
                                statusBoxHtml.addClass('wooPriceHistory-success').html(response.html).fadeIn().delay(3000).fadeOut();
                                if (section == 'synchronization') {
                                    plugin.updateCron();
                                }
                            } // replace the save button value with default message
                            $btn.val(value).removeClass('gray').addClass('green');
                        },
                        'json');
                    }
                },
                moduleChangeStatus: function ($btn) {
                    var value = $btn.text(),
                        the_status = $btn.hasClass('activate') ? 'true' : 'false'; // replace the save button value with loading message
                    $btn.text('saving setings ...');
                    var data = {
                        'action': 'wooPriceHistoryModuleChangeStatus',
                        'module': $btn.attr('rel'),
                        'the_status': the_status
                    }; // since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
                    jQuery.post(ajaxurl, data, function (response) {
                        if (response.status == 'ok') {
                            window.location.reload();
                        }
                    },
                    'json');
                },
                updateCron: function () {
                    var data = {
                        'action': 'wooPriceHistorySyncUpdate'
                    }; // since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
                    jQuery.post(ajaxurl, data, function (response) {},
                    'json');
                },
                fixLayoutHeight: function () {
                    var win = jQuery(window),
                        wooPriceHistoryWrapper = jQuery("#wooPriceHistory-wrapper"),
                        minusHeight = 100,
                        winHeight = win.height(); // show the freamwork wrapper and fix the height
                    wooPriceHistoryWrapper.css('min-height', parseInt(winHeight - minusHeight)).show();
                    jQuery("div#wooPriceHistory-ajax-response").css('min-height', parseInt(winHeight - minusHeight - 240)).show();
                },
                activatePlugin: function ($that) {
                    var requestData = {
                        'ipc': jQuery('#productKey').val(),
                        'email': jQuery('#yourEmail').val()
                    };
                    if (requestData.ipc == "") {
                        alert('Please type your Item Purchase Code!');
                        return false;
                    }
                    $that.replaceWith('Validating your IPC <em>( ' + (requestData.ipc) + ' )</em>  and activating plugin. Please be patient! (this action can take about <strong>10 seconds</strong>)');
                    var data = {
                        'action': 'wooPriceHistoryTryActivate',
                        'ipc': requestData.ipc,
                        'email': requestData.email
                    }; // since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
                    jQuery.post(ajaxurl, data, function (response) {
                        if (response.status == 'OK') {
                            window.location.reload();
                        } else {
                            alert(response.msg);
                            return false;
                        }
                    },
                    'json');
                },
                
                ajax_list: function()
				{

					var make_request = function( action, params, callback ){
						var loading = $("#wooPriceHistory-main-loading");
						loading.show();

						// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
						jQuery.post(ajaxurl, {
							'action' 		: 'wooPriceHistoryAjaxList',
							'ajax_id'		: $(".wooPriceHistory-table-ajax-list").find('.wooPriceHistory-ajax-list-table-id').val(),
							'sub_action'	: action,
							'params'		: params
						}, function(response) {

							if( response.status == 'valid' )
							{
								$("#wooPriceHistory-table-ajax-response").html( response.html );

								loading.fadeOut('fast');
							}
						}, 'json');
					}

					$(".wooPriceHistory-table-ajax-list").on('change', 'select[name=wooPriceHistory-post-per-page]', function(e){
						e.preventDefault();

						make_request( 'post_per_page', {
							'post_per_page' : $(this).val()
						} );
					})

					.on('change', 'select[name=wooPriceHistory-filter-post_type]', function(e){
						e.preventDefault();

						make_request( 'post_type', {
							'post_type' : $(this).val()
						} );
					})

					.on('click', 'a.wooPriceHistory-jump-page', function(e){
						e.preventDefault();

						make_request( 'paged', {
							'paged' : $(this).attr('href').replace('#paged=', '')
						} );
					})

					.on('click', '.wooPriceHistory-post_status-list a', function(e){
						e.preventDefault();

						make_request( 'post_status', {
							'post_status' : $(this).attr('href').replace('#post_status=', '')
						} );
					});
				},
				
				amzCheckAWS: function(){
					jQuery('.wooPriceHistoryCheckAmzKeys').on('click', function (e) {
                        e.preventDefault();
                        
                        jQuery.post(ajaxurl, {
							'action' : 'wooPriceHistoryCheckAmzKeys'
						}, function(response) {
								if( response.status == 'valid' ){
									alert('WooCommerce Amazon Affiliates was able to connect to Amazon with the specified AWS Key Pair and Associate ID');
								}
								else{
									alert('WooCommerce Amazon Affiliates was not able to connect to Amazon with the specified AWS Key Pair and Associate ID. Please triple-check your AWS Keys and Associate ID.');
								}
						}, 'json');
                    });
				},
				
                triggers: function () {
                	plugin.amzCheckAWS();
                	
                    jQuery(window).resize(function () {
                        plugin.fixLayoutHeight();
                    });
					
                    jQuery('body').on('click', '.wooPriceHistory_activate_product', function (e) {
						e.preventDefault();
                        plugin.activatePlugin(jQuery(this));
                    });
                    jQuery('body').on('click', '.wooPriceHistory-saveOptions', function (e) {
                        e.preventDefault();
                        plugin.saveOptions(jQuery(this));
                    });
                    jQuery('body').on('click', '.wooPriceHistory-installDefaultOptions', function (e) {
                        e.preventDefault();
                        plugin.installDefaultOptions(jQuery(this));
                    });
                    jQuery('body').on('click', '#' + option.prefix + "-module-manager a", function (e) {
                        e.preventDefault();
                        plugin.moduleChangeStatus(jQuery(this));
                    }); // Bind the event.
                    jQuery(window).hashchange(function () { // Alerts every time the hash changes!
                        if (location.hash != "") {
                            section = location.hash.replace("#!/", '');
                        }
                        plugin.makeRequest();
                    }) // Trigger the event (useful on page load).
                    jQuery(window).hashchange();
                    
                    plugin.ajax_list();
                }
            };
            plugin.init();
        });
    };
} (jQuery));