<?php
/**
 * AA-Team - http://www.aa-team.com
 * ===============================+
 *
 * @package		wooPriceHistoryAjaxListTable
 * @author		Andrei Dinca
 * @version		1.0
 */
! defined( 'ABSPATH' ) and exit;

if(class_exists('wooPriceHistoryAjaxListTable') != true) {
	class wooPriceHistoryAjaxListTable {

		/*
        * Some required plugin information
        */
        const VERSION = '1.0';

		/*
        * Singleton pattern
        */
		static protected $_instance;

		/*
        * Store some helpers
        */
		public $the_plugin = null;

		/*
        * Store some default options
        */
		public $default_options = array(
			'id' => '', /* string, uniq list ID. Use for SESSION filtering / sorting actions */
			'debug_query' => true, /* default is false */
			'show_header' => true, /* boolean, true or flase */
			'list_post_types' => 'all', /* array('post', 'pages' ... etc) or 'all' */
			'items_per_page' => 15, /* number. How many items per page */
			'post_statuses' => 'all',
			'search_box' => true, /* boolean, true or flase */
			'show_statuses_filter' => true, /* boolean, true or flase */
			'show_pagination' => true, /* boolean, true or flase */
			'show_category_filter' => true, /* boolean, true or flase */
			'columns' => array(),
			'custom_table' => '',
			'custom_table_force_action' => false,
			'deleted_field' => false,
			'force_publish_field' => false
		);
		private $items;
		private $items_nr;
		private $args;

		public $opt = array();

        /*
        * Required __construct() function that initalizes the AA-Team Framework
        */
        public function __construct( $parent )
        {
        	$this->the_plugin = $parent;
			add_action('wp_ajax_wooPriceHistoryAjaxList', array( $this, 'request' ));

			if(session_id() == '') {
			    // session isn't started
			    session_start();
			}
        }

		/**
	    * Singleton pattern
	    *
	    * @return class Singleton instance
	    */
	    static public function getInstance( $parent )
	    {
	        if (!self::$_instance) {
	            self::$_instance = new self($parent);
	        }

	        return self::$_instance;
	    }

		/**
	    * Setup
	    *
	    * @return class
	    */
		public function setup( $options=array() )
		{
			$this->opt = array_merge( $this->default_options, $options );

			//unset($_SESSION['wooPriceHistoryListTable']); // debug

			// check if set, if not, reset
			$_SESSION['wooPriceHistoryListTable'][$this->opt['id']] = $options;

			return $this;
		}

		/**
	    * Singleton pattern
	    *
	    * @return class Singleton instance
	    */
		public function request()
		{
			$request = array(
				'sub_action' 	=> isset($_REQUEST['sub_action']) ? $_REQUEST['sub_action'] : '',
				'ajax_id' 		=> isset($_REQUEST['ajax_id']) ? $_REQUEST['ajax_id'] : '',
				'params' 		=> isset($_REQUEST['params']) ? $_REQUEST['params'] : '',
			);

			if( $request['sub_action'] == 'post_per_page' ){
				$new_post_per_page = $request['params']['post_per_page'];

				if( $new_post_per_page == 'all' ){
					$_SESSION['wooPriceHistoryListTable'][$request['ajax_id']]['params']['posts_per_page'] = '-1';
				}
				elseif( (int)$new_post_per_page == 0 ){
					$_SESSION['wooPriceHistoryListTable'][$request['ajax_id']]['params']['posts_per_page'] = $this->opt['items_per_page'];
				}
				else{
					$_SESSION['wooPriceHistoryListTable'][$request['ajax_id']]['params']['posts_per_page'] = $new_post_per_page;
				}

				// reset the paged as well
				$_SESSION['wooPriceHistoryListTable'][$request['ajax_id']]['params']['paged'] = 1;
			}

			if( $request['sub_action'] == 'paged' ){
				$new_paged = $request['params']['paged'];
				if( $new_paged < 1 ){
					$new_paged = 1;
				}

				$_SESSION['wooPriceHistoryListTable'][$request['ajax_id']]['params']['paged'] = $new_paged;
			}

			if( $request['sub_action'] == 'post_type' ){
				$new_post_type = $request['params']['post_type'];
				if( $new_post_type == "" ){
					$new_post_type = "";
				}

				$_SESSION['wooPriceHistoryListTable'][$request['ajax_id']]['params']['post_type'] = $new_post_type;

				// reset the paged as well
				$_SESSION['wooPriceHistoryListTable'][$request['ajax_id']]['params']['paged'] = 1;
			}

			if( $request['sub_action'] == 'post_status' ){
				$new_post_status = $request['params']['post_status'];
				if( $new_post_status == "all" ){
					$new_post_status = "";
				}

				$_SESSION['wooPriceHistoryListTable'][$request['ajax_id']]['params']['post_status'] = $new_post_status;

				// reset the paged as well
				$_SESSION['wooPriceHistoryListTable'][$request['ajax_id']]['params']['paged'] = 1;
			}

			// create return html
			ob_start();

			$this->setup( $_SESSION['wooPriceHistoryListTable'][$request['ajax_id']] );
			$this->print_html();
			$html = ob_get_contents();
			ob_clean();

			die( json_encode(array(
				'status' 	=> 'valid',
				'html'		=> $html
			)) );
		}

		/**
	    * Helper function
	    *
	    * @return object
	    */
		public function get_items()
		{
			global $wpdb;
			
			if( isset( $_SESSION['wooPriceHistoryListTable'][$this->opt['id']]['params'] ) ) {
				$ses = $_SESSION['wooPriceHistoryListTable'][$this->opt['id']]['params'];
			}
			
			$this->args = array(
				'posts_per_page'  	=> ( isset($ses['posts_per_page']) ? $ses['posts_per_page'] : $this->opt['items_per_page'] ),
				'paged'				=> ( isset($ses['paged']) ? $ses['paged'] : 1 ),
				'category'        	=> ( isset($ses['category']) ? $ses['category'] : '' ),
				'orderby'         	=> 'post_date',
				'order'          	=> 'DESC',
				'post_type'       	=> ( isset($ses['post_type']) && trim($ses['post_type']) != "all" ? $ses['post_type'] : array_keys($this->get_list_postTypes()) ),
				'post_status'     	=> ( isset($ses['post_status']) ? $ses['post_status'] : '' ),
				'suppress_filters' 	=> true
			);
			 
			// if custom table, make request in the custom table not in wp_posts
			if( trim($this->opt["custom_table"]) != ""){
				$pages = array();

			    // select all pages and post from DB
			    $myQuery = "SELECT * FROM " . $wpdb->prefix . ( $this->opt["custom_table"] ) . " WHERE 1=1 ";

			    $__limitClause = $this->args['posts_per_page']>0 ? " 1=1 limit " . (($this->args['paged'] - 1) * $this->args['posts_per_page']) . ", " . $this->args['posts_per_page'] : '1=1 ';
				$result_query = str_replace("1=1 ", $__limitClause, $myQuery);

				if( $this->opt["custom_table"] == 'wooPriceHistory_serp_reporter' ) {
					$result_query = str_replace('1=1 limit', " 1=1 ORDER BY focus_keyword desc limit ", $result_query);
			    	if (isset($_SESSION['wooPriceHistory_serp']['search_engine']) && !empty($_SESSION['wooPriceHistory_serp']['search_engine']) && $_SESSION['wooPriceHistory_serp']['search_engine']!='--all--') {
			    		$myQuery = str_replace("1=1 ", " 1=1 and search_engine='".$_SESSION['wooPriceHistory_serp']['search_engine']."' ", $myQuery);
			    		$result_query = str_replace("1=1 ", " 1=1 and search_engine='".$_SESSION['wooPriceHistory_serp']['search_engine']."' ", $result_query);
			    	}
				}
				
				//publish field
			    if ($this->opt["force_publish_field"]) {
			    	$myQuery = str_replace("1=1 ", " 1=1 and publish='Y' ", $myQuery);
			    	$result_query = str_replace("1=1 ", " 1=1 and publish='Y' ", $result_query);
			    }
			    
			    //deleted field
			    if ($this->opt["deleted_field"]) {
			    	$myQuery = str_replace("1=1 ", " 1=1 and deleted=0 ", $myQuery);
			    	$result_query = str_replace("1=1 ", " 1=1 and deleted=0 ", $result_query);
			    }
			    
			    
			    $myQuery .= ";"; $result_query .= ";"; //query end!
				 
			    $query = $wpdb->get_results( $result_query, ARRAY_A);
			    foreach ($query as $key => $myrow){
			    	if( $this->opt["custom_table"] == 'price_alert' ) {
						$pages[$myrow['id']] = array(
							'id' 			=> $myrow['id'],
							'product_id' 	=> $myrow['product_id'],
				    		'drop_price' 	=> $myrow['drop_price'],
				    		'email'			=> $myrow['email'],
				    		'notification_send'	=> $myrow['notification_send'],
				    		'added_date'	=> $myrow['added_date']
						);
					}
			    }
				
				if( $this->opt['debug_query'] == true ){
					echo '<script>console.log("' . $result_query . '");</script>';
				}

				$this->items = $pages;

				$this->items_nr = $wpdb->get_var( str_replace("*", "count(id) as nbRow", $myQuery) );

			}else{

				// remove empty array
				$this->args = array_filter($this->args);

				$this->items = get_posts( $this->args );

				// get all post count
				$nb_args = $this->args;
				$nb_args['posts_per_page'] = '-1';
				$this->items_nr = (int) count(get_posts( $nb_args ));

				if( $this->opt['debug_query'] == true ){
					$query = new WP_Query( $this->args );
					echo '<script>console.log("' . $query->request . '");</script>';
				}
			}

			return $this;
		}

		private function getAvailablePostStatus()
		{

			$ses = $_SESSION['wooPriceHistoryListTable'][$this->opt['id']]['params'];

			$post_type = isset($ses['post_type']) && trim($ses['post_type']) != "" ? $ses['post_type'] : '';

			$sql = "SELECT count(id) as nbRow, post_status, post_type FROM " . ( $this->the_plugin->db->prefix ) . "posts WHERE 1 = 1 " . ( trim($post_types) != "" ? " AND post_type = '" . ( $post_type ) . "' " : '' ) . " group by post_status";
			$sql = preg_replace('~[\r\n]+~', "", $sql);

			return $this->the_plugin->db->get_results( $sql, ARRAY_A );
		}

		private function get_list_postTypes()
		{
			// overwrite wrong post-type value
			if( !isset($this->opt['list_post_types']) ) $this->opt['list_post_types'] = 'all';

			// custom array case
			if( is_array($this->opt['list_post_types']) && count($this->opt['list_post_types']) > 0 ) return $this->opt['list_post_types'];

			// all case
			return get_post_types(array('show_ui' => TRUE, 'show_in_nav_menus' => TRUE), 'objects');
		}

		private function get_pagination()
		{
			$html = array();

			if( isset( $_SESSION['wooPriceHistoryListTable'][$this->opt['id']]['params'] ) ) {
				$ses = $_SESSION['wooPriceHistoryListTable'][$this->opt['id']]['params'];
			}
			$posts_per_page = ( isset($ses['posts_per_page']) ? $ses['posts_per_page'] : $this->opt['items_per_page'] );
			$paged = ( isset($ses['paged']) ? $ses['paged'] : 1 );
			$total_pages = ceil( $this->items_nr / $posts_per_page );

			if( $this->opt['show_pagination'] ){
				$html[] = 	'<div class="wooPriceHistory-list-table-right-col">';


				$html[] = 		'<div class="wooPriceHistory-box-show-per-pages">';
				$html[] = 			'<select name="wooPriceHistory-post-per-page" id="wooPriceHistory-post-per-page" class="wooPriceHistory-post-per-page">';


				$html[] = 				'<option val="1" ' . ( $posts_per_page == 1 ? 'selected' : '' ). '>1</option>';
				foreach( range(5, 50, 5) as $nr => $val ){
					$html[] = 			'<option val="' . ( $val ) . '" ' . ( $posts_per_page == $val ? 'selected' : '' ). '>' . ( $val ) . '</option>';
				}

				$html[] = 				'<option value="all" ' . ($posts_per_page == -1 ? 'selected' : '') . '>';
				$html[] =				__('Show All', 'woo-price-history');
				$html[] = 				'</option>';
				$html[] =			'</select>';
				$html[] = 			'<label for="wooPriceHistory-post-per-page" style="width:57px">' . __('per pages', 'woo-price-history') . '</label>';
				$html[] = 		'</div>';

				$html[] = 		'<div class="wooPriceHistory-list-table-pagination tablenav">';

				$html[] = 			'<div class="tablenav-pages">';
				$html[] = 				'<span class="displaying-num">' . ( $this->items_nr ) . ' items</span>';
				if( $total_pages > 1 ){

					$html[] = 				'<span class="pagination-links"><a class="first-page ' . ( $paged == 1 ? 'disabled' : '' ) . ' wooPriceHistory-jump-page" title="Go to the first page" href="#paged=1">«</a>';
					$html[] = 				'<a class="prev-page ' . ( $paged == 1 ? 'disabled' : '' ) . ' wooPriceHistory-jump-page" title="Go to the previous page" href="#paged=' . ( $paged > 2 ? ($paged - 1) : 1 ) . '">‹</a>';
					$html[] = 				'<span class="paging-input"><input class="current-page" title="Current page" type="text" name="paged" value="' . ( $paged ) . '" size="2" style="width: 45px;"> of <span class="total-pages">' . ( ceil( $this->items_nr / $this->args['posts_per_page'] ) ) . '</span></span>';
					$html[] = 				'<a class="next-page ' . ( ( $paged == ($total_pages)) ? 'disabled' : '' ) . ' wooPriceHistory-jump-page" title="Go to the next page" href="#paged=' . ( $paged < $total_pages ? $paged + 1 : $total_pages ) . '">›</a>';
					$html[] = 				'<a class="last-page ' . ( $paged ==  ($total_pages - 1) ? 'disabled' : '' ) . ' wooPriceHistory-jump-page" title="Go to the last page" href="#paged=' . ( $total_pages ) . '">»</a></span>';
				}
				$html[] = 			'</div>';
				$html[] = 		'</div>';

				$html[] = 	'</div>';
			}

			return implode("\n", $html);
		}

		public function print_header()
		{
			$html = array();
			
			if( isset( $_SESSION['wooPriceHistoryListTable'][$this->opt['id']]['params'] ) ) {
				$ses = $_SESSION['wooPriceHistoryListTable'][$this->opt['id']]['params'];
			}

			$post_type = isset($ses['post_type']) && trim($ses['post_type']) != "" ? $ses['post_type'] : '';

			$html[] = '<div id="wooPriceHistory-list-table-header">';

			if( trim($this->opt["custom_table"]) == ""){
				$html[] = '<div class="wooPriceHistory-list-table-left-col">';
				$html[] = 		'<select name="wooPriceHistory-filter-post_type" class="wooPriceHistory-filter-post_type">';
				$html[] = 			'<option value="all" >';
				$html[] =			__('Show All', 'woo-price-history');
				$html[] = 			'</option>';

	            foreach ( $this->get_list_postTypes() as $name => $postType ){

					$html[] = 		'<option ' . ( $name == $post_type ? 'selected' : '' ) . ' value="' . ( $this->the_plugin->escape($name) ) . '">';
					$html[] = 			( is_object($postType) ? ucfirst($this->the_plugin->escape($name)) : ucfirst($name) );
					$html[] = 		'</option>';
	            }
				$html[] = 		'</select>';


				if( $this->opt['show_statuses_filter'] ){
					$html[] = $this->post_statuses_filter();
				}
				$html[] = 		'</div>';

				if( $this->opt['search_box'] ){
					$html[] = 	'<div class="wooPriceHistory-list-table-right-col">';
					$html[] = 		'<div class="wooPriceHistory-list-table-search-box">';
					$html[] = 			'<input type="text" name="s" value="" >';
					$html[] = 			'<input type="button" name="" class="button" value="Search Posts">';
					$html[] = 		'</div>';
					$html[] = 	'</div>';
				}

				if( $this->opt['show_category_filter'] && 3==4 ){
					$html[] = '<div class="wooPriceHistory-list-table-left-col" >';
					$html[] = 	'<select name="wooPriceHistory-filter-post_type" class="wooPriceHistory-filter-post_type">';
					$html[] = 		'<option value="all" >';
					$html[] =		__('Show All', 'woo-price-history');
					$html[] = 		'</option>';
					$html[] =	'</select>';
					$html[] = '</div>';
				}
			}else{
				$html[] = '<div class="wooPriceHistory-list-table-left-col">&nbsp;</div>';
			}

			$html[] = $this->get_pagination();

			$html[] = '</div>';

            echo implode("\n", $html);

			return $this;
		}

		public function print_main_table( $items )
		{
			$html = array();
			  
			$html[] = '<div id="wooPriceHistory-list-table-posts">';
			$html[] = 	'<table class="wooPriceHistory-table" style="border: none;border-bottom: 1px solid #dadada;">';
			$html[] = 		'<thead>';
			$html[] = 			'<tr>';
			foreach ($this->opt['columns'] as $key => $value){
				if( $value['th'] == 'checkbox' ){
					$html[] = '<th class="checkbox-column" width="20"><input type="checkbox" id="wooPriceHistory-item-check-all" checked></th>';
				}
				else{
					$html[] = '<th' . ( isset($value['width']) && (int)$value['width'] > 0 ? ' width="' . ( $value['width'] ) . '"' : '' ) . '' . ( isset($value['align']) ? ' align="' . ( $value['align'] ) . '"' : '' ) . '>' . ( $value['th'] ) . '</th>';
				}
			}

			$html[] = 			'</tr>';
			$html[] = 		'</thead>';

			$html[] = 		'<tbody>';
 
			foreach ($this->items as $post){

				$html[] = 			'<tr data-itemid="' . ( ( isset($post->ID) ? $post->ID : $post['id'] ) ) . '">';
				foreach ($this->opt['columns'] as $key => $value){

					$html[] = '<td style="'
						. ( isset($value['align']) ? 'text-align:' . ( $value['align'] ) . ';' : '' ) . ''
						. ( isset($value['css']) && count($value['css']) > 0 ? $this->print_css_as_style($value['css']) : '' ) . '">';

					if( $value['td'] == 'checkbox' ){
						$html[] = '<input type="checkbox" class="wooPriceHistory-item-checkbox" name="wooPriceHistory-item-checkbox-' . ( isset($post->ID) ? $post->ID : $post['id'] ) . '" checked>';
					}
					
					elseif( $value['td'] == '%notification_send%' ){
						$html[] = '<i>' . ( $post['notification_send'] ) . '</i>';
					}
					
					elseif( $value['td'] == '%added_date%' ){
						$html[] = '<i>' . ( $post['added_date'] ) . '</i>';
					}
					
					elseif( $value['td'] == '%product_id%' ){
						$html[] = '<i>' . ( $post['product_id'] ) . '</i>';
					}
					
					elseif( $value['td'] == '%id%' ){
						$html[] = '<i>' . ( $post['id'] ) . '</i>';
					}

					elseif( $value['td'] == '%email%' ){
						$html[] = '<i>' . ( $post['email'] ) . '</i>';
					}
					
					elseif( $value['td'] == '%current_price%' ){
						$lowesPrice = get_post_meta($post['product_id'], '_regular_price', true);
						$lowesPrice = trim($lowesPrice) != "" && trim(get_post_meta($post['product_id'], '_sale_price', true)) != "" ? get_post_meta($post['product_id'], '_sale_price', true) : $lowesPrice;
			
						$html[] = wc_price( $lowesPrice );
					}
					
					elseif( $value['td'] == '%drop_price%' ){
						$html[] = wc_price( $post['drop_price'] );
					}

					elseif( $value['td'] == '%product_id%' ){
						$html[] = '<i>' . ( $post['product_id'] ) . '</i>';
					}
					
					else{
						var_dump('<pre>',$value,$post,'</pre>'); die;  
					}
					

					$html[] = '</td>';
				}

				$html[] = 			'</tr>';
			}

			$html[] = 		'</tbody>';

			$html[] = 	'';

			$html[] = 	'</table>';

			if( trim($this->opt["custom_table"]) == "" || $this->opt["custom_table_force_action"]){

				if( isset($this->opt['mass_actions']) && ($this->opt['mass_actions'] === false) ){
					$html[] = '<div class="wooPriceHistory-list-table-left-col" style="padding-top: 5px;">&nbsp;</div>';
				}elseif( isset($this->opt['mass_actions']) && count($this->opt['mass_actions']) > 0 ){
					$html[] = '<div class="wooPriceHistory-list-table-left-col" style="padding-top: 5px;">&nbsp;';

					foreach ($this->opt['mass_actions'] as $key => $value){
						$html[] = 	'<input type="button" value="' . ( $value['value'] ) . '" id="wooPriceHistory-' . ( $value['action'] ) . '" class="wooPriceHistory-button ' . ( $value['color'] ) . '">';
					}
					$html[] = '</div>';
				}else{
					$html[] = '<div class="wooPriceHistory-list-table-left-col" style="padding-top: 5px;">&nbsp;';
					$html[] = 	'<input type="button" value="Auto detect focus keyword for All" id="wooPriceHistory-all-auto-detect-kw" class="wooPriceHistory-button blue">';
					$html[] = 	'<input type="button" value="Optimize All" id="wooPriceHistory-all-optimize" class="wooPriceHistory-button blue">';
					$html[] = '</div>';
				}
			}
			else{
				$html[] = '<div class="wooPriceHistory-list-table-left-col" style="padding-top: 5px;">&nbsp;';
				$html[] = '</div>';
			}

			$html[] = $this->get_pagination();

			$html[] = '</div>';

            echo implode("\n", $html);

			return $this;
		}

		public function post_statuses_filter()
		{
			$html = array();

			$availablePostStatus = $this->getAvailablePostStatus();

			$ses = $_SESSION['wooPriceHistoryListTable'][$this->opt['id']]['params'];

			$curr_post_status = isset($ses['post_status']) && trim($ses['post_status']) != "" ? $ses['post_status'] : 'all';

			if( $this->opt['post_statuses'] == 'all' ){
				$postStatuses = array(
				    'all'   	=> __('All', 'woo-price-history'),
				    'publish'   => __('Published', 'woo-price-history'),
				    'future'    => __('Scheduled', 'woo-price-history'),
				    'private'   => __('Private', 'woo-price-history'),
				    'pending'   => __('Pending Review', 'woo-price-history'),
				    'draft'     => __('Draft', 'woo-price-history'),
				);
			}
			else{
				die('invalid value of <i>post_statuses</i>. Only implemented value is: <i>all</i>!');
			}


			$html[] = 		'<ul class="subsubsub wooPriceHistory-post_status-list">';

			$cc = 0;
			// add into _postStatus array only if have equivalent into query results
			$_postStatus = array();
			$totals = 0;
			foreach ($availablePostStatus as $key => $value){
				if( in_array($value['post_status'], array_keys($postStatuses))){
					$_postStatus[$value['post_status']] = $value['nbRow'];
					$totals = $totals + $value['nbRow'];
				}
			}

			foreach ($postStatuses as $key => $value){
				$cc++;

				if( $key == 'all' || in_array($key, array_keys($_postStatus)) ){
					$html[] = 		'<li class="ocs_post_status">';
					$html[] = 			'<a href="#post_status=' . ( $key ) . '" class="' . ( $curr_post_status == $key ? 'current' : '' ) . '" data-post_status="' . ( $key ) . '">';
					$html[] = 				$value . ' <span class="count">(' . ( ( $key == 'all' ? $totals : $_postStatus[$key] ) ) . ')</span>';
					$html[] = 			'</a>' . ( count($_postStatus) > ($cc) ? ' |' : '');
					$html[] = 		'</li>';
				}
			}

			$html[] = 		'</ul>';

			return implode("\n", $html);
		}

		public function print_html()
		{
			$html = array();

			$this->get_items();

			$html[] = '<input type="hidden" class="wooPriceHistory-ajax-list-table-id" value="' . ( $this->opt['id'] ) . '" />';

			// header
			if( $this->opt['show_header'] === true ) $this->print_header();

			// main table
			$this->print_main_table( $this->items );

			echo implode("\n", $html);

			return $this;
		}

		private function print_css_as_style( $css=array() )
		{
			$style_css = array();
			if( isset($css) && count($css) > 0 ){
				foreach ($css as $key => $value) {
					$style_css[] = $key . ": " . $value;
				}
			}

			return ( count($style_css) > 0 ? implode(";", $style_css) : '' );
		}

	}
}