<?php

class wooPcs {

	public function __construct() {

		//Check if woocommerce plugin is installed.
		add_action( 'admin_notices', array( $this, 'check_required_plugins' ) );

		//Add setting link for the admin settings
		add_filter( "plugin_action_links_".WOOPCS_BASE, array( $this, 'woopcs_settings_link' ) );

		//Add backend settings
		add_filter( 'woocommerce_get_settings_pages', array( $this, 'woopcs_settings_class' ) );

		//Coming soon metabox
		add_action( 'add_meta_boxes', array( $this, 'add_coming_soon_metabox' ) );
		add_action( 'save_post', array( $this, 'save_woo_coming_soon' ) );

		//Woocommerce price html hook
		add_filter( 'woocommerce_get_price_html', array( $this, 'woopcs_price_html' ), 100, 2 );

		//If product is marked as coming soon then make it not purchaseable
		add_filter( 'woocommerce_is_purchasable', array( $this, 'woo_check_purchaseable' ), 10, 2 );

		//Add required js and css files to the site
		add_action( 'wp_enqueue_scripts', array( $this, 'woopcs_scripts' ) );

		add_action( 'admin_enqueue_scripts', array( $this, 'admin_woopcs_scripts') );



		if( get_option('woopcs_badge') == 'yes' ) {
			//Add badge to the products.
			add_action( 'woocommerce_before_shop_loop_item', array( $this, 'woopcs_badge' ) );
			add_action( 'woocommerce_product_thumbnails', array( $this, 'woopcs_badge' ) );
		}


		//If disable review is checked then add the hook
		if ( !empty( get_option('woopcs_disable_review' ) ) && get_option('woopcs_disable_review' ) == 'yes'  )
			add_filter( 'woocommerce_product_tabs', array( $this, 'woopcs_remove_reviews_tab' ), 100 );

		//Add Subscription form
		add_action( 'woocommerce_single_product_summary', array( $this, 'woopcs_dispay_subscribe_form'), 30 );


		//Coming soon email subscription
		add_action( 'wp_ajax_woopcs_subscribe', array( $this, 'woopcs_subscribe' ) );
		add_action( 'wp_ajax_nopriv_woopcs_subscribe', array( $this, 'woopcs_subscribe' ) );

		//make the product live
		add_action( 'wp_ajax_woopcs_remove_coming_soon', array( $this, 'woopcs_remove_coming_soon' ) );
		add_action( 'wp_ajax_nopriv_woopcs_remove_coming_soon', array( $this, 'woopcs_remove_coming_soon' ) );


		//Add subscriptions column for products on admin
		if( is_admin() ) {
			add_filter( 'manage_edit-product_columns', array( $this, 'add_subscription_field' ), 10, 1 );
			add_action( 'manage_product_posts_custom_column', array( $this, 'show_subscription_field' ), 2 );
			add_filter("manage_edit-product_sortable_columns", array( $this, 'sortable_subscription_field' ) );
			add_filter( 'request', array( $this, 'subscriptions_column_orderby' ) );
			add_action( 'wp_ajax_get_subscribers', array( $this, 'get_subscribers' ) );
		}
	}


	public function check_required_plugins() {
		if ( ! is_plugin_active( 'woocommerce/woocommerce.php' ) ) { ?>
			<div id="message" class="error">
				Woo Coming Soon expects WooCommerce to be active. This plugin has been deactivated.
			</div>

			<?php
			deactivate_plugins( '/woo-coming-soon/woo-coming-soon.php' );
		} // if woocommerce

	} // check_required_plugins

	/**
	 * Add new link for the settings under plugin links
	 *
	 * @param array $links an array of existing links.
	 * @return array of links  along with age restricted shopping settings link.
	 *
	 */
	public function woopcs_settings_link($links) {
		$settings_link = '<a href="'.admin_url('admin.php?page=wc-settings&tab=woopcs').'">Settings</a>';
		array_unshift( $links, $settings_link );
		return $links;
	}

	public function admin_woopcs_scripts() {
		wp_enqueue_script( 'timepicker',  plugins_url( 'assets/js/jquery-ui-timepicker-addon.js', WOOPCS_FILE ), array( 'jquery-ui-datepicker' ));
		wp_enqueue_script( 'custom',  plugins_url( 'assets/js/custom.js', WOOPCS_FILE ), array( 'jquery' ), '1.0.0', true );
		wp_enqueue_style ( 'woocs-admin-style', plugins_url( 'assets/css/jquery-ui.css', WOOPCS_FILE ) );
		wp_enqueue_style ( 'woocs-admin-list-style', plugins_url( 'assets/css/woocs-admin.css', WOOPCS_FILE ) );
		wp_enqueue_style ( 'woocs-jquery-timepicker', plugins_url( 'assets/css/jquery-ui-timepicker-addon.css', WOOPCS_FILE ) );
	}

	/**
	 * Add new admin setting page for age restricted shopping settings.
	 *
	 * @param array   $settings an array of existing setting pages.
	 * @return array of setting pages along with age restricted shopping settings page.
	 *
	 */
	public function woopcs_settings_class( $settings ) {
		$settings[] = include 'class-wc-settings-coming-soon.php';
		return $settings;
	}

	public function add_coming_soon_metabox() {
		if( get_option('woopcs_enabled') !== 'yes' )
			return;
		add_meta_box( '', 'Coming Soon', array( $this, 'woo_coming_soon' ), 'product', 'side', 'high' );
	}

	public function woo_coming_soon( $product ) {

		$coming_soon = get_post_meta( $product->ID, 'woo_coming_soon', true ) == '' ? 0 : get_post_meta( $product->ID, 'woo_coming_soon', true );
		$product_available_date = get_post_meta( $product->ID, 'woopcs_product_available', true );

		wp_nonce_field( 'woo_coming_soon_nonce', 'meta_box_nonce' );
?>
	<input type="checkbox" name="woo_coming_soon" id="woo_coming_soon" value="1" <?php checked( $coming_soon, 1 ); ?> /><label for="woo_coming_soon">Enable coming soon mode.</label>
	<div class="product-available-wrap" style="margin-top: 10px;">
		<label for="product_available">When product will be available for sale </label>
		<input type="text" name="woopcs_product_available" id="woopcs_product_available" value="<?php echo $product_available_date; ?>">
	</div>
		<?php
	}

	public function save_woo_coming_soon( $product_id ) {
		// Bail if we're doing an auto save
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;

		// if our nonce isn't there, or we can't verify it, bail
		if ( !isset( $_POST['meta_box_nonce'] ) || !wp_verify_nonce( $_POST['meta_box_nonce'], 'woo_coming_soon_nonce' ) ) return;


		//Saving coming soon field
		$coming_soon = ( isset( $_POST['woo_coming_soon'] ) && $_POST['woo_coming_soon'] ) ? '1' : '0';
		$past_coming_soon = get_post_meta( $product_id, 'woo_coming_soon', true );
		update_post_meta( $product_id, 'woo_coming_soon', $coming_soon );
		if( isset( $_POST['woopcs_product_available'] ) && !empty( $_POST['woopcs_product_available'] ) ) {
			$check_available = get_post_meta( $product_id, 'woopcs_product_available', true );
			update_post_meta( $product_id, 'woopcs_product_available', $_POST['woopcs_product_available'] );
		}
		if( $past_coming_soon == 1 && $coming_soon == 0 ) {
			$this->notify_subscribers( $product_id );
		}
	}

	public function notify_subscribers( $product_id ){
		global $woocommerce;
		$subscriptions = get_post_meta( $product_id, 'woopcs_subscriptions', true );
		if( is_array( $subscriptions )) {
			$product = new WC_Product( $product_id );
			$search = array( '%PRODUCT_NAME%', '%PRODUCT_IMAGE%', '%PRODUCT_LINK%', '%SITE_NAME%', '%SITE_URL%' );
			$replace = array( $product->get_title(), '<a href="'.$product->get_permalink().'">'.$product->get_image( 'shop_single' ).'</a>', '<a href="'.$product->get_permalink().'">'.$product->get_permalink().'</a>', get_bloginfo( 'name' ), get_bloginfo( 'url' ) );
			$subscription_email = get_option('woopcs_subscription_email');
			if( empty($subscription_email) ) {
				$subscription_email = get_option('subscription_email');
			}
			$subject = str_replace( $search, $replace, get_option('woopcs_subscription_email_subject') );
			$body = str_replace( $search, $replace, $subscription_email );

			$headers = array('Content-Type: text/html; charset=UTF-8');
			add_filter('wp_mail_content_type',create_function('', 'return "text/html"; '));
			if ( version_compare( $woocommerce->version, '2.3',  ">=" ) ) {
				$mailer = WC()->mailer();
				foreach ( $subscriptions as $subscription ) {
					$mailer->send( $subscription, $subject, $mailer->wrap_message( $subject, $body ), $headers, '' );
				}
			}
			else{
				foreach ( $subscriptions as $subscription ) {
					wp_mail( $subscription, $subject, wpautop($body) );
				}
			}
			delete_post_meta( $product_id, 'woopcs_subscriptions' );
			delete_post_meta( $product_id, 'woopcs_subscriptions_num' );
		}
	}

	public function woopcs_scripts() {
		
		if( is_woocommerce()  ) {
			//Remove product short description from single page when set from pugin settings

			if( get_option('woopcs_hide_product_description') == 'yes' )
				remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 );

			  remove_action( 'woocommerce_single_variation', 'woocommerce_single_variation_add_to_cart_button', 20 );


			wp_enqueue_style( 'woocs-style', plugins_url( 'assets/css/woopcs.css', WOOPCS_FILE ) );
			wp_enqueue_script( 'woopcs-script',  plugins_url( 'assets/js/woopcs.js', WOOPCS_FILE ), array( 'jquery' ), '1.0.0', true );
			wp_localize_script( 'woopcs-script', 'woopcs', array(
				'ajaxurl' 								=> admin_url( 'admin-ajax.php' ),
				'already_subscribed'			=> get_option('woopcs_already_subscribed_text'),
				'successfully_subscribed' => get_option('woopcs_successfully_subscribed_text'),
				'invalid_email' 					=> get_option('woopcs_invalid_email_text'),
				'timer_type' 							=> get_option('woopcs_countdown_timer_type'),
				'timer_bg_color' 					=> get_option('woopcs_timer_bg_color'),
				'timer_border_color' 			=> get_option('woopcs_timer_border_color'),
				'timer_text_color'				=> get_option('woopcs_timer_text_color'),
				'spiral_border_size'			=> get_option('woopcs_spiral_border_size'),
				'timer_font_size'					=> get_option('woopcs_timer_font_size'),
				'timer_fill_color'				=> get_option('woopcs_timer_fill_color'),
				));

			$custom_css = "
				.woopcs-badge {
					background: ".get_option('woopcs_badge_bg').";
					color: ".get_option('woopcs_badge_text_color').";
				}
				#woopcs-Countdown {
					background: ".get_option('woopcs_timer_bg_color').";
					color: ".get_option('woopcs_timer_text_color').";
					font-size: ".get_option('woopcs_timer_font_size')."px;
					border-color: ".get_option('woopcs_timer_border_color').";
				}
				#woopcs-form .subscribe-submit {
					background-color: ".get_option('woopcs_submit_button_color').";
					font-size: ".get_option('woopcs_subscribe_font_size')."px;
				}
				#woopcs-form .subscribe-submit:hover {
					background-color: ".get_option('woopcs_submit_button_hover_color').";
				}

				";

			
			wp_add_inline_style( 'woocs-style', $custom_css );

			if ( get_option('woopcs_countdown') !== null && get_option('woopcs_countdown') == 'yes'  ) {
				if( get_option('woopcs_countdown_timer_type') == 'normal' ) {
					wp_enqueue_style( 'woocs-countdown-style', plugins_url( 'assets/css/jquery.countdown.css', WOOPCS_FILE ) );
					wp_enqueue_script( 'woocs-custom-script',  plugins_url( 'assets/js/normal-countdown/jquery.plugin.js', WOOPCS_FILE ), array( 'jquery' ), '1.0.0', true );
					wp_enqueue_script( 'woocs-countdown',  plugins_url( 'assets/js/normal-countdown/jquery.countdown.js', WOOPCS_FILE ), array( 'jquery' ), '1.0.0', true );
				}

				if( get_option('woopcs_countdown_timer_type') == 'spiral' ) {
					wp_enqueue_style( 'woocs-countdown-style', plugins_url( 'assets/css/jquery.classycountdown.min.css', WOOPCS_FILE ) );
					wp_enqueue_script( 'woocs-knob',  plugins_url( 'assets/js/spiral-countdown/jquery.knob.js', WOOPCS_FILE ), array( 'jquery' ), '1.0.0', true );
					wp_enqueue_script( 'woocs-throttle',  plugins_url( 'assets/js/spiral-countdown/jquery.throttle.js', WOOPCS_FILE ), array( 'jquery' ), '1.0.0', true );
					wp_enqueue_script( 'woocs-countdown',  plugins_url( 'assets/js/spiral-countdown/jquery.classycountdown.js', WOOPCS_FILE ), array( 'jquery' ), '1.0.0', true );
				}
			}
		}
	}

	public function woopcs_badge() {
		global $product;
		if ( $this->is_coming_soon() )
			echo '<div class="woopcs-badge '.get_option('woopcs_badge_position').'">
		'.get_option('woopcs_badge_text').'</div>';
	}

	public function woopcs_price_html( $price, $product ) {
		$coming_soon = $this->is_coming_soon();

		if( !$coming_soon ) return $price;

		if( is_product() && get_option('woopcs_hide_price') == 'yes' &&
			get_option('woopcs_subscription') == 'yes' && $coming_soon )
			return get_option('woopcs_coming_soon_text');
		if( is_product() && get_option('woopcs_hide_price') != 'yes' &&
			get_option('woopcs_subscription') == 'yes' && $coming_soon )
			return $price.'<br />'.get_option('woopcs_coming_soon_text');
		elseif ( is_product() && get_option('woopcs_hide_price') == 'yes' && $coming_soon )
			return get_option('woopcs_coming_soon_text');
		else if ( $coming_soon && get_option('woopcs_hide_price') != 'yes'  )
			return $price.'<br />'.get_option('woopcs_coming_soon_text');
		else if( $coming_soon )
			return get_option('woopcs_coming_soon_text');
		return $price;
	}

	public function woo_check_purchaseable( $purchaseable, $product ) {
		$this->is_coming_soon();
		if ( $this->is_coming_soon() )
				return false;
		return $purchaseable;
	}



	public function woopcs_dispay_subscribe_form() {
		global $product;
		$id = !empty( get_the_ID() ) ? get_the_ID() : $product->get_id();
		$email = '';

		if( is_user_logged_in() ) {
			$current_user = wp_get_current_user();
			$email = $current_user->user_email;
		}
		if ( $this->is_coming_soon() ) {
			$form_html = '';
			$form_html .= '<section class="subscribe">
											<div class="subscribe-pitch">
												<p>'.get_option('woopcs_subscription_text').'</p>
												<div id="woopcs-msg"></div>
											</div>';
			if( get_option('woopcs_countdown') !== null && get_option('woopcs_countdown') == 'yes' ) {
				$get_available_date = get_post_meta( $id, 'woopcs_product_available', true );
				$form_html .= '<div id="woopcs-Countdown" data-available="'.$get_available_date.'" data-product-id="'.$id.'"></div>';
			}
			if( get_option('woopcs_subscription') !== null && get_option('woopcs_subscription') == 'yes' ) {
				$form_html .= '<form action="" method="post" id="woopcs-form" class="subscribe-form" autocomplete="off">
												<div class="woopcs-overlay"></div>
												<input type="hidden" id="woopcs-product-id" value="'.$id.'">
												<input type="text" id="woopcs-email" name="woopcs-email" value="'.$email.'" class="subscribe-input" placeholder="'.get_option('woopcs_subscription_email_placeholder').'" autofocus>
												<button type="submit" class="subscribe-submit"><span>'.get_option('woopcs_subscription_button_text').'</span></button>
											</form>
										</section>';
			}
			echo $form_html;
		}
	}

	public function woopcs_remove_reviews_tab( $tabs ) {
		global $product;
		if ( $this->is_coming_soon() )
			unset( $tabs['reviews'] );
		return $tabs;
	}

	public function woopcs_remove_coming_soon() {
		$product_id = $_POST['product_id'];
		if( !empty($product_id) ) {
			update_post_meta($product_id, 'woo_coming_soon', 0);
			$this->notify_subscribers( $product_id );
		}
		echo 'success';
		exit;
	}

	public function woopcs_subscribe() {
		$email = $_POST['email'];
		$product_id = $_POST['product_id'];
		$subscriptions = get_post_meta( $product_id, 'woopcs_subscriptions', true );

		if( is_array( $subscriptions )  && in_array( $email, $subscriptions ) ) {
			echo 0;
		}
		else {
			if( $subscriptions == '' )
				$subscriptions = array( $email );
			else if( is_array( $subscriptions ) )
				array_push( $subscriptions, $email );
			update_post_meta( $product_id, 'woopcs_subscriptions', $subscriptions );
			update_post_meta( $product_id, 'woopcs_subscriptions_num', count( $subscriptions ) );
			echo 1;
		}
		exit;
	}

	public function add_subscription_field( $columns ) {
		$new_columns = ( is_array( $columns ) ) ? $columns : array();
		$new_columns['subscriptions'] = '# Subscriptions';
		add_thickbox();
		return $new_columns;
	}

	public function show_subscription_field( $column ) {
		global $post;
		$subscriptions = get_post_meta( $post->ID, 'woopcs_subscriptions', true );
		$count = 0;
		$return = 'No subscribers';
		if( is_array( $subscriptions ) )
			$count = count( $subscriptions );
		if( $count > 0 )
			$return = '<a href="'.admin_url( 'admin-ajax.php' ).'?action=get_subscribers&id='.$post->ID.'&width=300&height=300" class="thickbox">'.$count.' subscriber(s)</a>';
		if( $column == 'subscriptions' )
			echo $return;
	}

	public function sortable_subscription_field( $columns ) {
		 $custom = array(
			'subscriptions'    => 'woopcs_subscriptions_num',
		);
		return wp_parse_args( $custom, $columns );
	}

	public function subscriptions_column_orderby( $vars ) {
		if ( isset( $vars['orderby'] ) && 'woopcs_subscriptions_num' == $vars['orderby'] ) {
			$vars = array_merge( $vars, array(
				'meta_key' => 'woopcs_subscriptions_num',
				'orderby' => 'meta_value'
			) );
		}
		return $vars;
	}

	public function get_subscribers() {
		$id = $_GET['id'];
		$subscriptions = get_post_meta( $id, 'woopcs_subscriptions', true );
		$subscribers = '<h3>'.get_the_title( $id ).' Subscribers</h3>
		<table class="wp-list-table widefat fixed subscribe-list">';
		$subscribers .= '<thead><tr><th class="slno">Sl No.</th><th>Email</th></tr></thead>';
		$i = 1;
		foreach( $subscriptions as $subscription ){
			$class = 'normal';
			if( $i%2 == 0 )
				$class = 'alternate';
			$subscribers .= '<tr class="'.$class.'"><td>'.$i.'</td><td><a href="mailto:'.$subscription.'" style="font-size:16px;">'.$subscription.'</a></td></td>';
			$i++;
		}
		$subscribers .= '</table>';
		echo $subscribers;
		exit;
	}


	public function is_coming_soon(){
		if( get_option('woopcs_enabled') !== 'yes' )
			return;

		global $woocommerce;
		global $product;

		if( empty($product) )
			return;


		$id = !empty( get_the_ID() ) ? get_the_ID() : $product->get_id();

		$coming_soon = get_post_meta( $id, 'woo_coming_soon', true );

		if( $id != '' && $coming_soon == '1' ){
			$coming_date = get_post_meta( $id, get_option('woopcs_product_available'), true );
			$cur_date	 = date_i18n( 'm/d/Y H:i');

			if( ( $coming_date > $cur_date && get_option('woopcs_countdown') == 'yes' && $coming_soon == '1' ) || ( $coming_soon == '1' && get_option('woopcs_countdown') != 'yes' ) ) return true;
			else if( $coming_soon == '1' && $coming_date < $cur_date && get_option('woopcs_countdown') == 'yes' && get_option('woopcs_auto_mail') == 'yes' ){
				update_post_meta( $id, 'woo_coming_soon', '0' );
				$this->notify_subscribers( $id );
			}
		}
		return false;
	}

}