<?php
/**
 * Woo Coming Soon Settings
 *
 * @author 		Magnigenie
 * @category 	Admin
 * @version     2.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if (  class_exists( 'WC_Settings_Page' ) ) :

/**
 * WC_Settings_Accounts
 */

class WC_Settings_WOO_Coming_Soon extends WC_Settings_Page {
	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id    = 'woopcs';
		$this->label = __( 'Coming Soon', 'woopcs' );
		add_filter( 'woocommerce_settings_tabs_array', array( $this, 'add_settings_page' ), 20 );
		add_action( 'woocommerce_settings_' . $this->id, array( $this, 'output' ) );
		add_action( 'woocommerce_settings_save_' . $this->id, array( $this, 'save' ) );
		add_action( 'admin_footer', array( $this, 'woopcs_add_scripts') );
		add_action( 'woocommerce_admin_field_woopcseditor', array( $this, 'woopcs_display_editor' ) );
		add_filter( 'woocommerce_admin_settings_sanitize_option_woopcs_subscription_email', array( $this, 'woopcs_save_editor_val' ), 10, 3 );
		add_action( 'woocommerce_admin_field_uploader', array( $this, 'woopcs_display_uploader' ) );
	}

	/**
	 * Get settings array
	 *
	 * @return array
	 */

	public function get_settings() {

		return apply_filters( 'woocommerce_' . $this->id . '_settings',
			array(
				array(
					'title'	=> __( 'WooCommerce Coming Soon Settings', 'woopcs' ),
					'type' 	=> 'title',
					'desc' 	=> '',
					'id' 		=> 'woopcs_title'
				),
      	array(
					'title' 	=> __( 'Enable', 'woopcs' ),
					'desc' 		=> __( 'Enable woo coming soon.', 'woopcs' ),
					'type' 		=> 'checkbox',
					'id'			=> 'woopcs_enabled',
					'default' => 'no'
				),
        array(
					'title'   => __( 'Coming Soon Text', 'woopcs' ),
					'desc' 	  => __( '.', 'woopcs' ),
					'type' 	  => 'text',
					'id'	  	=> 'woopcs_coming_soon_text',
					'default' => '',
				),
        array(
					'title' 	=> __( 'Hide Price', 'woopcs' ),
					'desc' 		=> __( 'Hide price for coming soon products.', 'woopcs' ),
					'type' 		=> 'checkbox',
					'id'			=> 'woopcs_hide_price',
					'default' => 'yes'
				),
				array(
					'title' 	=> __( 'Disable review', 'woopcs' ),
					'desc' 		=> __( 'Disable review for coming soon products.', 'woopcs' ),
					'type' 		=> 'checkbox',
					'id'			=> 'woopcs_disable_review',
					'default' => 'no'
				),
        array(
					'title' 	=> __( 'Display Badge', 'woopcs' ),
					'desc' 		=> __( 'Display badge on coming soon products.', 'woopcs' ),
					'type' 		=> 'checkbox',
					'id'			=> 'woopcs_badge',
					'default' => 'yes'
				),
        array(
					'title' 	=> __( 'Badge text', 'woopcs' ),
					'desc' 		=> __( 'Badge text for coming soon products.', 'woopcs' ),
					'type' 		=> 'text',
					'id'			=> 'woopcs_badge_text',
					'default' => 'COMING SOON'
				),
        array(
					'title' 	=> __( 'Badge position', 'woopcs' ),
					'desc' 		=> __( '', 'woopcs' ),
					'type' 		=> 'select',
					'id'			=> 'woopcs_badge_position',
					'options'	=> array( 'left' => 'Left', 'right' => 'Right' ),
					'default' => 'right'
				),
				array(
					'title' 	=> __( 'Badge background', 'woopcs' ),
					'desc' 		=> __( '', 'woopcs' ),
					'id' 		  => 'woopcs_badge_bg',
					'type' 		=> 'color',
					'css' 		=> 'width: 125px;',
					'default'	=> '#777777',
				),
				array(
					'title' 	=> __( 'Badge text color', 'woopcs' ),
					'desc' 		=> __( '', 'woopcs' ),
					'id' 		  => 'woopcs_badge_text_color',
					'type' 		=> 'color',
					'css' 		=> 'width: 125px;',
					'default'	=> '#ffffff',
				),
        array(
					'title' 	=> __( 'Enable subscription', 'woopcs' ),
					'desc' 		=> __( 'Enable subscription for coming soon product.', 'woopcs' ),
					'type' 		=> 'checkbox',
					'id'		  => 'woopcs_subscription',
					'default' => 'yes'
				),
       	array(
					'title' 	=> __( 'Enable countdown timer', 'woopcs' ),
					'desc' 		=> __( 'Show coundown timer for the product,when it will be available on the store for purchase', 'woopcs' ),
					'type' 		=> 'checkbox',
					'id'		  => 'woopcs_countdown',
					'default'	=> 'yes'
				),
    		array(
					'title' 	=> __( 'Countdown timer type', 'woopcs' ),
					'desc' 		=> '',
					'type' 		=> 'select',
					'options' => array(
						'normal' => __( 'Normal', 'woopcs' ),
						'spiral' => __( 'Spiral', 'woopcs' ),
					),
					'id'		  => 'woopcs_countdown_timer_type',
					'default' => 'normal'
				),
        array(
					'title' 	=> __( 'Automatically mail subscribers', 'woopcs' ),
					'desc' 		=> __( 'Automatically send emails to all subscribed users & remove the product from coming soon when countdown hits to 0.', 'woopcs' ),
					'type' 		=> 'checkbox',
					'id'			=> 'woopcs_auto_mail',
					'default' => 'yes'
				),
				array(
					'title' 	=> __( 'Timer background color', 'woopcs' ),
					'desc' 		=> __( '', 'woopcs' ),
					'id' 		  => 'woopcs_timer_bg_color',
					'type' 		=> 'color',
					'css' 		=> 'width: 125px;',
					'default'	=> '#111111',
				),
				array(
					'title' 	=> __( 'Timer border color', 'woopcs' ),
					'desc' 		=> __( '', 'woopcs' ),
					'id' 		  => 'woopcs_timer_border_color',
					'type' 		=> 'color',
					'css' 		=> 'width: 125px;',
					'default'	=> '#24bb06',
				),
				array(
					'title' 	=> __( 'Timer text color', 'woopcs' ),
					'desc' 		=> __( '', 'woopcs' ),
					'id' 		  => 'woopcs_timer_text_color',
					'type' 		=> 'color',
					'css' 		=> 'width: 125px;',
					'default'	=> '#ffffff',
				),
				array(
					'title' 	=> __( 'Spiral timer fill color', 'woopcs' ),
					'desc' 		=> __( '', 'woopcs' ),
					'id' 		  => 'woopcs_timer_fill_color',
					'type' 		=> 'color',
					'css' 		=> 'width: 125px;',
					'default'	=> '#ffffff',
				),
				array(
					'title' 	=> __( 'Timer font size (in px)', 'woopcs' ),
					'desc' 		=> __( '', 'woopcs' ),
					'id' 		  => 'woopcs_timer_font_size',
					'type' 		=> 'number',
					'css' 		=> 'width: 65px;',
					'default'	=> '18',
				),
				array(
					'title' 	=> __( 'Spiral timer border size', 'woopcs' ),
					'desc' 		=> __( '', 'woopcs' ),
					'id' 		  => 'woopcs_spiral_border_size',
					'type' 		=> 'number',
					'css' 		=> 'width: 65px;',
					'default' => '0.3',
					'custom_attributes' => array( 'max' => '1', 'min' => '0.1', 'step' => '0.1' )
				),
        array(
					'title' 	=> __( 'Hide product short description', 'woopcs' ),
					'desc' 		=> __( 'Hide product description from the product single page', 'woopcs' ),
					'type' 		=> 'checkbox',
					'id'		  => 'woopcs_hide_product_description',
					'default' => 'yes'
				),
        array(
					'title' 	=> __( 'Already subscribed text', 'woopcs' ),
					'desc' 		=> __( 'Message for already subscribed users', 'woopcs' ),
					'type' 		=> 'textarea',
					'id'		  => 'woopcs_already_subscribed_text',
					'default' => 'You have already subscribed for this product, We will notify once the product is available for sale !',
					'css'		  => 'width:100%',
					'desc_tip'=>  true
				),
        array(
					'title' 	=> __( 'Successfully subscribed text', 'woopcs' ),
					'desc' 		=> __( 'Message will be shown after user has been successfully subscribed', 'woopcs' ),
					'type' 		=> 'textarea',
					'id'		  => 'woopcs_successfully_subscribed_text',
					'default' => 'You have successfully subscribed for this product, We will inform as soon as the product is available for sale !',
					'css'		  => 'width:100%',
					'desc_tip'=>  true
				),
        array(
					'title' 	=> __( 'Invalid email error text', 'woopcs' ),
					'desc' 		=> __( 'Error message for the users who have entered invalid email', 'woopcs' ),
					'type' 		=> 'textarea',
					'id'		  => 'woopcs_invalid_email_text',
					'default' => 'Please enter a valid email address !',
					'css'		  => 'width:100%',
					'desc_tip'=>  true
				),
        array(
					'title' 	=> __( 'Subscription text', 'woopcs' ),
					'desc' 		=> __( 'This will appear before the subscription form.', 'woopcs' ),
					'type' 		=> 'textarea',
					'css'		  => 'width:100%',
					'id'			=> 'woopcs_subscription_text',
					'default' => 'Enter your email below and we will inform you once the product is available.'
				),
				array(
					'title' 	=> __( 'Subscription email subject', 'woopcs' ),
					'desc' 		=> __( '', 'woopcs' ),
					'id' 		  => 'woopcs_subscription_email_subject',
					'type' 		=> 'text',
					'css'		  => 'width:300px',
					'default'	=> '%PRODUCT_NAME% is available for sale.',
					'desc_tip'=>  false
				),
				array(
					'title' 	=> __( 'Email placeholder text', 'woopcs' ),
					'desc' 		=> __( 'Subscribe form email placeholder text', 'woopcs' ),
					'id' 		  => 'woopcs_subscription_email_placeholder',
					'type' 		=> 'text',
					'css'		  => 'width:300px',
					'default'	=> 'Please Enter Email',
					'desc_tip'=>  false
				),
				array(
					'title' 	=> __( 'Submit button text', 'woopcs' ),
					'desc' 		=> __( 'Subscribe form submit button text', 'woopcs' ),
					'id' 		  => 'woopcs_subscription_button_text',
					'type' 		=> 'text',
					'css'		  => 'width:300px',
					'default'	=> 'Subscribe',
					'desc_tip'=>  false
				),
				array(
					'title' 	=> __( 'Button color', 'woopcs' ),
					'desc' 		=> __( 'Subscribe form button color', 'woopcs' ),
					'id' 		  => 'woopcs_submit_button_color',
					'type' 		=> 'color',
					'css' 		=> 'width: 125px;',
					'default'	=> '#5234b5',
					'desc_tip'=>  false
				),
				array(
					'title' 	=> __( 'Button hover color', 'woopcs' ),
					'desc' 		=> __( 'Subscribe form button hover color', 'woopcs' ),
					'id' 		  => 'woopcs_submit_button_hover_color',
					'type' 		=> 'color',
					'css' 		=> 'width: 125px;',
					'default'	=> '#2b246f',
					'desc_tip'=>  false
				),
				array(
					'title' 	=> __( 'Button font size (in px)', 'woopcs' ),
					'desc' 		=> __( 'Subscribe form button font size', 'woopcs' ),
					'id' 		  => 'woopcs_subscribe_font_size',
					'type' 		=> 'number',
					'css' 		=> 'width: 65px;',
					'default' => '17',
					'desc_tip'=>  false
				),
				array(
					'title' 	=> __( 'Email Text', 'woopcs' ),
					'desc' 		=> __( '<code>Available variables: %PRODUCT_NAME% &nbsp; %PRODUCT_LINK% &nbsp; %PRODUCT_IMAGE% &nbsp; %SITE_NAME% &nbsp; %SITE_URL% </code>', 'woopcs' ),
					'id' 		  => 'woopcs_subscription_email',
					'type' 		=> 'woopcseditor',
					'default'	=> '<p>Hi,</p><p>Few days back you subscribed to get notification when %PRODUCT_NAME% is available for sale. The product is available now and you can purchase it by visiting product page. </p><p>%PRODUCT_LINK% </p><p>Cheers<br />- %SITE_NAME%</p>',
					'desc_tip'=>  false
				),
				array( 'type' => 'sectionend', 'id' => 'simple_woopcs_options'),
		)); // End pages settings

	}

	/**
	* Output wordpress editor for email body condent.
	*
	* @param array $value array of settings variables.
	* @return null displays the editor.
	*
	*/

	public function woopcs_display_editor( $value ) {
		$option_value = WC_Admin_Settings::get_option( $value['id'], $value['default'] );
		$option_value = (get_option('woopcs_subscription_email') == "" ? $option_value : get_option('woopcs_subscription_email') );
		?>

		<tr valign="top">
			<th scope="row" class="titledesc">
				<label for="<?php echo esc_attr( $value['id'] ); ?>"><?php echo esc_html( $value['title'] ); ?></label>
			</th>
			<td class="forminp forminp-<?php echo sanitize_title( $value['type'] ) ?>">
				<?php echo $value['desc']; ?>
				<?php wp_editor( $option_value, uniqid(), array( 'textarea_name' => $value['id'] ) ); ?>
			</td>
		</tr>
	<?php
	}

	/**
	* Saves the content for wp_editor.
	*
	* @return null saves the value of the option.
	*
	*/

	public function woopcs_save_editor_val($value, $option, $raw_value) {
		update_option( $option['id'],  $raw_value );
	}

	/**
	* Output wordpress file uploader.
	*
	* @param array $value array of settings variables.
	* @return null displays the editor.
	*
	*/

	public function woopcs_display_uploader( $value ) {
		$option_value = WC_Admin_Settings::get_option( $value['id'], $value['default'] ); ?>
		<tr valign="top">
			<th scope="row" class="titledesc">
				<label for="<?php echo esc_attr( $value['id'] ); ?>"><?php echo esc_html( $value['title'] ); ?></label>
			</th>
			<td class="forminp forminp-<?php echo sanitize_title( $value['type'] ) ?>">
				<div class="uploader">
					<input value="<?php echo $option_value; ?>" id="<?php echo esc_attr( $value['id'] ); ?>" name="<?php echo esc_attr( $value['id'] ); ?>" type="text" />
					<input id="woopcs_button" class="button" type="button" value="Upload" />
					<div class="woopcs_image">
						<?php if($option_value != '') {
							echo '<img src="'.$option_value.'" style="width: 100px;" alt="">';
							} ?>
					</div>
				</div>
			</td>
		</tr>
	<?php
	}

	/**
	* Add the required js needed for the plugin to display the list of products using ajax.
	*
	* @return null outputs the scripts on the footer.
	*
	*/

	public function woopcs_add_scripts() {
	?>
		<script type="text/javascript">
			jQuery(function(){
				// Image uploader js
				 var _custom_media = true;

					jQuery('#woopcs_button').click(function(e) {
						var send_attachment_bkp = wp.media.editor.send.attachment;
						var button = jQuery(this);
						var input_file = button.parent().find('input[type="text"]');
						_custom_media = true;
						wp.media.editor.send.attachment = function(props, attachment){
							if ( _custom_media ) {
								input_file.val(attachment.url);
								button.parent().find('.woopcs_image').html('<img src="'+attachment.url+'" width="100px;">');
							} else {
								return wp.media.editor.send.attachment.apply( this, [props, attachment] );
							};
						}

						wp.media.editor.open(button);
						return false;
					});

				jQuery('.add_media').on('click', function(){
					_custom_media = false;
				});
			});
		</script>
	<?php
	}
}

return new WC_Settings_WOO_Coming_Soon();
endif;