jQuery(function($){

	$('#woopcs-form').submit(function(e){
		e.preventDefault();
		var email = $('#woopcs-email').val(),
		product   =  $('#woopcs-product-id').val(),
		msg = '',
		msgDiv = $('#woopcs-msg');
		msgDiv.removeAttr('class').html('');
		$('.subscribe-pitch p').hide();

		if( email != '' && WooPcsIsEmail(email) ) {
			$('.woopcs-overlay').addClass('show');
			$.post(woopcs.ajaxurl, { action: 'woopcs_subscribe', email: email, product_id: product }, function(data){
				if( data == 0 ){
					msg = '<b>Error:</b>'+woopcs.already_subscribed+'';
					msgDiv.hide().html(msg).addClass('error').slideDown('slow');
				}
				else if( data == 1 ) {
					msg = '<b>Sucess:</b>'+woopcs.successfully_subscribed+'';
					msgDiv.hide().html(msg).addClass('success').slideDown('slow');
				}
				$('.woopcs-overlay').removeClass('show');
			});
		}
		else {
			msg = '<b>Error:</b>'+woopcs.invalid_email+'';
			$('#woopcs-email').focus();
			msgDiv.hide().html(msg).addClass('error').slideDown('slow');
		}
	});

	function WooPcsIsEmail(email) {
		var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
		return regex.test(email);
	}

	if( $('#woopcs-Countdown').length > 0 ) {
		var AvailableDate = $('#woopcs-Countdown').attr('data-available');
		var ProductId = $('#woopcs-Countdown').attr('data-product-id');
		
		if( isNaN(AvailableDate) == true ) {
			var austDay = new Date(AvailableDate);
			if( woopcs.timer_type == 'normal' ) {
				$('#woopcs-Countdown').countdown({
					until: austDay,
					onExpiry: function(){
						$.post(woopcs.ajaxurl, {
							action: 'woopcs_remove_coming_soon',
							product_id: ProductId
						}, function(data) {
							if( data == 'success' ) {
								window.location.reload();
							}
						});
					}
				});
			}
			else {
				var NewTime = new Date(AvailableDate).getTime() - new Date().getTime();
				$('#woopcs-Countdown').ClassyCountdown({
					end: $.now() + NewTime/1000,
					labels: true,
					labelsOptions: {
						style: 'font-size:0.5em; text-transform:uppercase;'
					},
          style: {
          	days: {
            	gauge: {
              	thickness: woopcs.spiral_border_size,
                bgColor: woopcs.timer_border_color,
                fgColor: woopcs.timer_fill_color
              },
            },
            hours: {
            	gauge: {
              	thickness: woopcs.spiral_border_size,
                bgColor: woopcs.timer_border_color,
                fgColor: woopcs.timer_fill_color
              },
            },
            minutes: {
            	gauge: {
              	thickness: woopcs.spiral_border_size,
                bgColor: woopcs.timer_border_color,
                fgColor: woopcs.timer_fill_color
              },
           	},
            seconds: {
            	gauge: {
              	thickness: woopcs.spiral_border_size,
                bgColor: woopcs.timer_border_color,
                fgColor: woopcs.timer_fill_color
              },
            }
          },
          
          onEndCallback: function() {
						$.post(woopcs.ajaxurl, {
							action: 'woopcs_remove_coming_soon',
							product_id: ProductId
						}, function(data){
							if( data == 'success' ) {
								window.location.reload();
							}
						});
					},
				});
			}
		}
	}

});