<?php
/*
Main plugin file for the WeePie Cookie Allow Plugin

@author $Author: Vincent Weber <weepie-plugins@outlook.com> $
@since 1.0

Plugin Name: WeePie Cookie Allow
Plugin URI: http://www.weepie-plugins.com/cookie-allow/
Description: Complete GDPR / AVG / CCPA Cookie Compliance WordPress plugin
Author: WeePie Plugins
Version: 3.4.10
Author URI: http://www.weepie-plugins.com/about-weepie-plugins/
License: GPL v3

WeePie Cookie Allow - A premium WordPress Plugin that makes it possible to
comply with different Cookie Law implementations, e.g. the GDPR, AVG and CCPA.
Copyright (C) 2012 - 2025, Vincent Weber - WeePie Plugins

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

if( ! defined( 'ABSPATH' ) ) exit;

// Composer autoload
require __DIR__ . '/vendor/autoload.php';

try {
	$e = null;
	if( ! defined( 'WPIE_FW_FILE_OLD' ) ) {
		/**
		 * Perform check for WeePie Framework
		 *
		 * @throws \Exception when main weepie-framework.php file is not found
		 * @throws \Exception when an old WeePieFramework version < 2.0 instance is still activated
		 * @throws \Exception when an old WeePieFramework version < 2.0 still exists in the filesystem
		 *
		 * @since 3.2.9
		 */
		require __DIR__ . '/wpiefw-check.php';
	}

	$namespace = 'wpca';
	$args = [
		'namespace' => $namespace,
		'file' => __FILE__,
		'version' => '3.4.10',
		'settings' => [
			'pageTitle' => 'WeePie Cookie Allow',
			'menuTitle' => 'Cookie Allow'
		]
	];

	WeePieFramework::instance( $namespace )->start( $args );
} catch( \WpieFw\Exceptions\WpieExceptionInterface $e ) {
} catch( \Throwable $e ) {
} catch( \Exception $e ) {
} finally {
	if( null !== $e && is_admin() && function_exists( 'wpiefw_check_display_errors' ) ) {
		wpiefw_check_display_errors( $e->getMessage() );
	}
}