<?php

namespace WpieFw\Framework\Patterns\Resolver;

use WpieFw\Framework\Patterns\Definition\WpieDefinition;

if( ! defined( 'ABSPATH' ) ) exit;

class WpieWpOptionsResolver
{
	/**
	 * @var WpieDefinition
	 */
	protected $definitions;

	/**
	 * Constructor
	 *
	 * @param WpieDefinition $defenitions
	 */
	public function __construct( WpieDefinition $definitions )
	{
		$this->definitions = $definitions;
	}

	/**
	 * Get a (definition) index value by shortcut
	 *
	 * Wrapper method for WpieDefinition::getValueForShortcut()
	 *
	 * @param string $shortcut
	 * @param array $replace
	 *
	 * @return string
	 */
	public function getValueForShortcut( $shortcut = '', array $replace = [] )
	{
		return $this->definitions->getValueForShortcut( $shortcut, $replace );
	}

	/**
	 * Gets a WordPress option from the wp_options table
	 *
	 * @param string $name
	 * @param mixed $default
	 *
	 * @uses get_option()
	 *
	 * @return mixed|boolean
	 */
	public function getWpOption( string $name, $default )
	{
		return get_option( $name, $default );
	}

	/**
	 * Sets a WordPress option in the wp_options table
	 *
	 * If the option already exist, the option is updated
	 *
	 * @param string $name
	 * @param mixed $value
	 *
	 * @uses add_option()
	 * @uses self::updateWpOption() if option already exist
	 *
	 * @return boolean
	 */
	public function addWpOption( string $name, $value )
	{
		if( null !== $this->getWpOption( $name, null ) ) {
			return $this->updateWpOption( $name, $value );
		} else {
			return add_option( $name, $value );
		}
	}

	/**
	 * Updates a WordPress option in the wp_options table
	 *
	 * @param string $name
	 * @param mixed $value
	 *
	 * @uses update_option()
	 *
	 * @return boolean
	 */
	public function updateWpOption( string $name, $value )
	{
		return update_option( $name, $value );
	}

	/**
	 * Deletes a WordPress option in the wp_options table
	 *
	 * @param string $name
	 *
	 * @uses delete_option()
	 *
	 * @return boolean
	 */
	public function deleteWpOption( $name = '' )
	{
		return delete_option( $name );
	}
}