<?php

namespace WpieFw\Files;

if( ! defined( 'ABSPATH' ) ) exit;

interface WpieFileInterface
{
	/**
	 * Get the file prefix
	 *
	 * @return string
	 */
	public function getPrefix();

	/**
	 * Returns the content of the file.
	 *
	 * @copyright Fabien Potencier <fabien@symfony.com>
	 *
	 * @throws WpieFw\Exceptions\WpieRuntimeException;
	 *
	 * @return string the content of the file
	 */

	public function getContent();

	/**
	 * Get filename index based on pattern
	 *
	 * For example find "bar" from {namespace}-foo-bar.php
	 *
	 * @return string|bool
	 */
	public function getIndex();
}