<?php

namespace WpieFw\Files;

use WpieFw\Exceptions\WpieInvalidArgumentException;
use WpieFw\Framework\Patterns\Iterator\WpieCollection;

if( ! defined( 'ABSPATH' ) ) exit;

class WpieFileCollection extends WpieCollection
{
	/**
	 * Constructor
	 *
	 * @param array $collection
	 * @param string $relativeSeparator
	 */
	public function __construct( array $collection = [], string $relativeSeparator = '' )
	{
		if( is_string( $relativeSeparator ) && '' !== $relativeSeparator ) {
			foreach ( $collection as $idx => $path ) {
				if( preg_match( "#^$relativeSeparator#", $path ) ) {
				    $collection[$idx] = dirname(WP_CONTENT_DIR).'/'.$path;
				}
			}
		}

		parent::__construct( $collection );
	}

	/**
	 * @param string $offset
	 * @param string $value
	 */
	public function offsetSet( $offset, $value ): void
	{
		if( '' === trim( $offset ) ) {
			throw new WpieInvalidArgumentException( 'Cannot add file to collection. Index is empty.' );
		}

		$this->collection[$offset] = new WpieFile( $value );
	}
}