<!-- Master-Detail settings -->
<div role="tabpanel" class="tab-pane" id="master-detail-settings">
    <!-- .row -->
    <div class="row">
        <!-- Master-detail checkbox-->
        <div class="col-sm-4 m-b-16 wdt-md-toggle-master-detail-block">
            <h4 class="c-title-color m-b-4 m-t-0">
                <?php esc_html_e('Master-detail', 'wpdatatables'); ?>
                <i class="wpdt-icon-info-circle-thin" data-toggle="tooltip" data-placement="right"
                   title="<?php esc_attr_e('Enable this to turn the master-detail functionality on for this table.', 'wpdatatables'); ?>"></i>
            </h4>
            <div class="toggle-switch" data-ts-color="blue">
                <input id="wdt-md-toggle-master-detail" type="checkbox" hidden="hidden">
                <label for="wdt-md-toggle-master-detail"
                       class="ts-label"><?php esc_html_e('Enable master-detail functionality', 'wpdatatables'); ?></label>
            </div>
        </div>
        <!-- /Master-Detail checkbox-->

        <!-- Master-Detail Click Event Logic-->
        <div class="col-sm-4 wdt-md-click-event-logic-block hidden">
            <div class="form-group">
                <div class="fg-line">
                    <div class="select">
                        <label for="wdt-md-click-event-logic" class="c-title-color m-b-4">
                            <?php esc_html_e('Open details on:', 'wpdatatables'); ?>
                            <i class="wpdt-icon-info-circle-thin" data-toggle="tooltip" data-placement="right"
                               title="<?php esc_attr_e('If the “Row click” is selected, users will be able to access details for a row by clicking it. If the “Button click” is selected, a new column will be added to the table, where each row would get a button opening the details for it.', 'wpdatatables'); ?>"></i>
                        </label>
                        <select class="form-control selectpicker" id="wdt-md-click-event-logic">
                            <option value="row"><?php esc_html_e('Row click', 'wpdatatables'); ?></option>
                            <option value="button"><?php esc_html_e('Button click', 'wpdatatables'); ?></option>
                        </select>
                    </div>
                </div>
            </div>

        </div>
        <!-- /Master-Detail Click Event Logic-->

        <!-- Master-Detail Render data in-->
        <div class="col-sm-4 wdt-md-render-data-in-block hidden">
            <div class="form-group">
                <div class="fg-line">
                    <div class="select">
                        <label for="wdt-md-render-data-in" class="c-title-color m-b-4">
                            <?php esc_html_e('Show details in:', 'wpdatatables'); ?>
                            <i class="wpdt-icon-info-circle-thin" data-toggle="tooltip" data-placement="right"
                               title="<?php esc_attr_e('If the “popup” option is selected, the details for the selected row will appear in a popup dialog on the same page. If you choose on of the the “Post” or “Page” options, users will be redirected to the chosen post or page (picked in a separate setting), which will be used as a template to render the details. Please note that you need to create the template post or page and fill it in with placeholders first, so that you could select it here', 'wpdatatables'); ?>"></i>
                        </label>
                        <select class="form-control selectpicker" id="wdt-md-render-data-in">
                            <option value="popup"><?php esc_html_e('Popup', 'wpdatatables'); ?></option>
                            <option value="wdtNewPage"><?php esc_html_e('Page', 'wpdatatables'); ?></option>
                            <option value="wdtNewPost"><?php esc_html_e('Post', 'wpdatatables'); ?></option>
                        </select>
                    </div>
                </div>
            </div>

        </div>
        <!-- /Master-Detail Render data in-->
    </div>
    <!-- /.row -->

    <!-- .row -->
    <div class="row">
        <!-- Master-Detail Render page-->
        <div class="col-sm-4 wdt-md-render-page-block hidden">
            <div class="form-group">
                <div class="fg-line">
                    <div class="select">
                        <label for="wdt-md-render-page" class="c-title-color m-b-4">
                            <?php esc_html_e('Template page', 'wpdatatables'); ?>
                            <i class="wpdt-icon-info-circle-thin" data-toggle="tooltip" data-placement="right"
                               title="<?php esc_attr_e('Choose which page will be used to showing the row details', 'wpdatatables'); ?>"></i>
                        </label>
                        <select class="form-control selectpicker" id="wdt-md-render-page">
                            <?php foreach (WDTMasterDetail\Plugin::getAllPages() as $page) { ?>
                                <option value="<?php echo get_permalink($page['ID']); ?>"><?php echo esc_html($page['post_title']); ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
            </div>

        </div>
        <!-- /Master-Detail Render page -->

        <!-- Master-Detail Render post-->
        <div class="col-sm-4 wdt-md-render-post-block hidden">

            <div class="form-group">
                <div class="fg-line">
                    <div class="select">
                        <label for="wdt-md-render-post" class="c-title-color m-b-4">
                            <?php esc_html_e('Template post', 'wpdatatables'); ?>
                            <i class="wpdt-icon-info-circle-thin" data-toggle="tooltip" data-placement="right"
                               title="<?php esc_attr_e('Choose which post will be used to showing the row details', 'wpdatatables'); ?>"></i>
                        </label>
                        <select class="form-control selectpicker" id="wdt-md-render-post">
                            <?php foreach (WDTMasterDetail\Plugin::getAllPosts() as $post) { ?>
                                <option value="<?php echo get_permalink($post['ID']); ?>"><?php echo esc_html($post['post_title']); ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
            </div>

        </div>
        <!-- /Master-Detail Render post -->

        <!-- Master-Detail Popup Title -->
        <div class="col-sm-4 wdt-md-popup-title-block hidden">
            <div class="form-group">
                <div class="fg-line">
                    <div class="row">
                        <div class="col-sm-12">
                            <label for="wdt-md-popup-title" class="c-title-color m-b-4">
                                <?php esc_html_e('Popup Title', 'wpdatatables'); ?>
                                <i class="wpdt-icon-info-circle-thin" data-toggle="tooltip" data-placement="right"
                                   title="<?php esc_attr_e('Enter a title for the popup with row details. If you leave the field blank, the default title is “Row details”', 'wpdatatables'); ?>"></i>
                            </label>
                            <input type="text" name="wdt-md-popup-title" id="wdt-md-popup-title"
                                                                           class="form-control input-sm" placeholder="Enter a title for Popup modal"
                                                                           value=""/>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /Master-Detail Popup Title -->

        <!-- Master-detail Link Target Attribute-->
        <div class="col-sm-4 m-b-16 wdt-md-toggle-link-target-attribute-block hidden">
            <h4 class="c-title-color m-b-4 m-t-0">
                <?php esc_html_e('Link target attribute', 'wpdatatables'); ?>
                <i class="wpdt-icon-info-circle-thin" data-toggle="tooltip" data-placement="right"
                   title="<?php esc_attr_e('Set how to open post or page. By default option is turned off and it is opening post/page in new tab.', 'wpdatatables'); ?>"></i>
            </h4>
            <div class="toggle-switch" data-ts-color="blue">
                <input id="wdt-md-toggle-link-target-attribute" type="checkbox" hidden="hidden">
                <label for="wdt-md-toggle-link-target-attribute"
                       class="ts-label"><?php esc_html_e('Open page/post in the same tab', 'wpdatatables'); ?></label>
            </div>
        </div>
        <!-- /Master-Detail Link Target Attribute-->
    </div>
    <!-- /.row -->
</div>
<!-- /Master-Detail settings -->