var removed_rules = [];
jQuery( document ).ready(
	function ($) {
		$( '.multi_input_holder' ).each(
			function () {
				var multi_input_holder = $( this );
				addMultiInputProperty( multi_input_holder );
			}
		);

		function addMultiInputProperty(multi_input_holder)
		{
			var multi_input_limit = multi_input_holder.data( 'limit' );
			if (typeof multi_input_limit == 'undefined') {
					  multi_input_limit = -1;
			}

			if (multi_input_holder.children( '.multi_input_block' ).length == 1) {
				multi_input_holder.children( '.multi_input_block' ).children( '.remove_multi_input_block' ).css( 'display', 'none' );
			}

			if (multi_input_holder.children( '.multi_input_block' ).length == multi_input_limit) {
				multi_input_holder.find( '.add_multi_input_block' ).hide();
			} else {
				multi_input_holder.find( '.add_multi_input_block' ).show();
			}

			multi_input_holder.children( '.multi_input_block' ).each(
				function () {
					if ($( this )[0] != multi_input_holder.children( '.multi_input_block:last' )[0]) {
						$( this ).children( '.add_multi_input_block' ).remove();
					}
				}
			);

			multi_input_holder.children( '.multi_input_block' ).children( '.add_multi_input_block' ).off( 'click' ).on(
				'click',
				function () {
					var holder_id              = multi_input_holder.attr( 'id' );
					var holder_name            = multi_input_holder.data( 'name' );
					var multi_input_blockCount = multi_input_holder.data( 'length' );
					multi_input_blockCount++;
					var multi_input_blockEle = multi_input_holder.children( '.multi_input_block:first' ).clone( false );

					multi_input_blockEle.find( 'textarea,input:not(input[type=button],input[type=submit],input[type=checkbox],input[type=radio])' ).val( '' );
					multi_input_blockEle.find( 'input[type=checkbox]' ).attr( 'checked', false );
					multi_input_blockEle.children( '.wcfm-wp-fields-uploader,.multi_input_block_element:not(.multi_input_holder)' ).each(
						function () {
							  var ele      = $( this );
							  var ele_name = ele.data( 'name' );
							  ele.attr( 'name', holder_name + '[' + multi_input_blockCount + '][' + ele_name + ']' );
							  ele.attr( 'id', holder_id + '_' + ele_name + '_' + multi_input_blockCount );

							if (ele.hasClass( 'wcfm_datepicker' )) {
								ele.removeClass( 'hasDatepicker' ).datepicker(
									{
										dateFormat: ele.data( 'date_format' ),
										closeText: wcfm_datepicker_params.closeText,
										currentText: wcfm_datepicker_params.currentText,
										monthNames: wcfm_datepicker_params.monthNames,
										monthNamesShort: wcfm_datepicker_params.monthNamesShort,
										dayNames: wcfm_datepicker_params.dayNames,
										dayNamesShort: wcfm_datepicker_params.dayNamesShort,
										dayNamesMin: wcfm_datepicker_params.dayNamesMin,
										firstDay: wcfm_datepicker_params.firstDay,
										isRTL: wcfm_datepicker_params.isRTL,
										changeMonth: true,
										changeYear: true
									}
								);
							} else if (ele.hasClass( 'time_picker' )) {
								$( '.time_picker' ).timepicker( 'remove' ).timepicker( { 'step': 15 } );
								ele.timepicker( 'remove' ).timepicker( { 'step': 15 } );
							}//end if
						}
					);

					// Nested multi-input block property
					multi_input_blockEle.children( '.multi_input_holder' ).each(
						function () {
							 setNestedMultiInputIndex( $( this ), holder_id, holder_name, multi_input_blockCount );
						}
					);

					multi_input_blockEle.children( '.remove_multi_input_block' ).off( 'click' ).on(
						'click',
						function () {
							 var rconfirm = confirm( wcfm_dashboard_messages.multiblock_delete_confirm );
							if (rconfirm) {
								var remove_ele_parent = $( this ).parent().parent();
								var addEle            = remove_ele_parent.children( '.multi_input_block' ).children( '.add_multi_input_block' ).clone( true );
								$( this ).parent().remove();
								remove_ele_parent.children( '.multi_input_block' ).children( '.add_multi_input_block' ).remove();
								remove_ele_parent.children( '.multi_input_block:last' ).append( addEle );
								if (remove_ele_parent.children( '.multi_input_block' ).length == multi_input_limit) {
												remove_ele_parent.find( '.add_multi_input_block' ).hide();
								} else {
									   remove_ele_parent.find( '.add_multi_input_block' ).show();
								}

								if (remove_ele_parent.children( '.multi_input_block' ).length == 1) {
									 remove_ele_parent.children( '.multi_input_block' ).children( '.remove_multi_input_block' ).css( 'display', 'none' );
								}
							}
						}
					);

					multi_input_blockEle.children( '.add_multi_input_block' ).remove();
					multi_input_holder.append( multi_input_blockEle );
					multi_input_holder.children( '.multi_input_block:last' ).append( $( this ) );
					if (multi_input_holder.children( '.multi_input_block' ).length > 1) {
						 multi_input_holder.children( '.multi_input_block' ).children( '.remove_multi_input_block' ).css( 'display', 'block' );
					}

					if (multi_input_holder.children( '.multi_input_block' ).length == multi_input_limit) {
						multi_input_holder.find( '.add_multi_input_block' ).hide();
					} else {
						multi_input_holder.find( '.add_multi_input_block' ).show();
					}

					multi_input_holder.data( 'length', multi_input_blockCount );
				}
			);

			if ( ! multi_input_holder.hasClass( 'multi_input_block_element' )) {
				   // multi_input_holder.children('.multi_input_block').css('padding-bottom', '40px');
			}

			if (multi_input_holder.children( '.multi_input_block' ).children( '.multi_input_holder' ).length > 0) {
				// multi_input_holder.children('.multi_input_block').css('padding-bottom', '40px');
			}

			multi_input_holder.children( '.multi_input_block' ).children( '.remove_multi_input_block' ).off( 'click' ).on(
				'click',
				function () {
					var rconfirm = confirm( wcfm_dashboard_messages.multiblock_delete_confirm );
					if (rconfirm) {
						var remove_ele_parent = $( this ).parent().parent();
						var addEle            = remove_ele_parent.children( '.multi_input_block' ).children( '.add_multi_input_block' ).clone( true );
						$( this ).parent().remove();
						remove_ele_parent.children( '.multi_input_block' ).children( '.add_multi_input_block' ).remove();
						remove_ele_parent.children( '.multi_input_block:last' ).append( addEle );
						if (remove_ele_parent.children( '.multi_input_block' ).length == 1) {
							remove_ele_parent.children( '.multi_input_block' ).children( '.remove_multi_input_block' ).css( 'display', 'none' );
						}

						if (remove_ele_parent.children( '.multi_input_block' ).length == multi_input_limit) {
							remove_ele_parent.find( '.add_multi_input_block' ).hide();
						} else {
							remove_ele_parent.find( '.add_multi_input_block' ).show();
						}
					}
				}
			);
		}

		function resetMultiInputIndex(multi_input_holder)
		{
			var holder_id              = multi_input_holder.attr( 'id' );
			var holder_name            = multi_input_holder.data( 'name' );
			var multi_input_blockCount = 0;

			multi_input_holder.find( '.multi_input_block' ).each(
				function () {
					$( this ).children( '.wcfm-wp-fields-uploader,.multi_input_block_element:not(.multi_input_holder)' ).each(
						function () {
							var ele      = $( this );
							var ele_name = ele.data( 'name' );
							var multiple = ele.attr( 'multiple' );
							if (typeof multiple !== typeof undefined && multiple !== false) {
								ele.attr( 'name', holder_name + '[' + multi_input_blockCount + '][' + ele_name + '][]' );
							} else {
								ele.attr( 'name', holder_name + '[' + multi_input_blockCount + '][' + ele_name + ']' );
							}

							ele.attr( 'id', holder_id + '_' + ele_name + '_' + multi_input_blockCount );
						}
					);
					multi_input_blockCount++;
				}
			);
		}

		function setNestedMultiInputIndex(nested_multi_input, holder_id, holder_name, multi_input_blockCount)
		{
			nested_multi_input.children( '.multi_input_block:not(:last)' ).remove();
			var multi_input_id         = nested_multi_input.attr( 'id' );
			multi_input_id             = multi_input_id.replace( holder_id + '_', '' );
			var multi_input_id_splited = multi_input_id.split( '_' );
			var multi_input_name       = '';
			for (var i = 0; i < (multi_input_id_splited.length - 1); i++) {
				if (multi_input_name != '') {
					multi_input_name += '_';
				}

				multi_input_name += multi_input_id_splited[i];
			}

			nested_multi_input.attr( 'data-name', holder_name + '[' + multi_input_blockCount + '][' + multi_input_name + ']' );
			nested_multi_input.attr( 'id', holder_id + '_' + multi_input_name + '_' + multi_input_blockCount );
			nested_multi_input.children( '.multi_input_block' ).children( '.wcfm-wp-fields-uploader,.multi_input_block_element:not(.multi_input_holder)' ).each(
				function () {
					var ele      = $( this );
					var ele_name = ele.data( 'name' );
					var multiple = ele.attr( 'multiple' );
					if (typeof multiple !== typeof undefined && multiple !== false) {
						ele.attr( 'name', holder_name + '[' + multi_input_blockCount + '][' + multi_input_name + '][0][' + ele_name + '][]' );
					} else {
						ele.attr( 'name', holder_name + '[' + multi_input_blockCount + '][' + multi_input_name + '][0][' + ele_name + ']' );
					}

					ele.attr( 'id', holder_id + '_' + multi_input_name + '_' + multi_input_blockCount + '_' + ele_name + '_0' );

					if (ele.hasClass( 'wcfm_datepicker' )) {
						ele.removeClass( 'hasDatepicker' ).datepicker(
							{
								dateFormat: ele.data( 'date_format' ),
								closeText: wcfm_datepicker_params.closeText,
								currentText: wcfm_datepicker_params.currentText,
								monthNames: wcfm_datepicker_params.monthNames,
								monthNamesShort: wcfm_datepicker_params.monthNamesShort,
								dayNames: wcfm_datepicker_params.dayNames,
								dayNamesShort: wcfm_datepicker_params.dayNamesShort,
								dayNamesMin: wcfm_datepicker_params.dayNamesMin,
								firstDay: wcfm_datepicker_params.firstDay,
								isRTL: wcfm_datepicker_params.isRTL,
								changeMonth: true,
								changeYear: true
							}
						);
					} else if (ele.hasClass( 'time_picker' )) {
						$( '.time_picker' ).timepicker( 'remove' ).timepicker( { 'step': 15 } );
						ele.timepicker( 'remove' ).timepicker( { 'step': 15 } );
					}//end if
				}
			);

			addMultiInputProperty( nested_multi_input );

			if (nested_multi_input.children( '.multi_input_block' ).children( '.multi_input_holder' ).length > 0) {
				nested_multi_input.children( '.multi_input_block' ).css( 'padding-bottom', '40px' );
			}

			nested_multi_input.children( '.multi_input_block' ).children( '.multi_input_holder' ).each(
				function () {
					setNestedMultiInputIndex( $( this ), holder_id + '_' + multi_input_name + '_0', holder_name + '[' + multi_input_blockCount + '][' + multi_input_name + ']', 0 );
				}
			);
		}

		// Availability rules type
		function availabilityRules()
		{
			$( '#wc_global_appointment_availability' ).find( '.multi_input_block' ).each(
				function () {
					$( this ).find( '.avail_range_type' ).change(
						function () {
							$avail_range_type = $( this ).val();
							$( this ).parent().find( '.avail_rule_field' ).addClass( 'wcfm_ele_hide' );
							if ($avail_range_type == 'custom' || $avail_range_type == 'months' || $avail_range_type == 'weeks' || $avail_range_type == 'days') {
								$( this ).parent().find( '.avail_rule_' + $avail_range_type ).removeClass( 'wcfm_ele_hide' );
							} else if (( $avail_range_type == 'time:range' ) || ( $avail_range_type == 'custom:daterange' )) {
								$( this ).parent().find( '.avail_rule_custom' ).removeClass( 'wcfm_ele_hide' );
								$( this ).parent().find( '.avail_rule_time' ).removeClass( 'wcfm_ele_hide' );
							} else {
								$( this ).parent().find( '.avail_rule_time' ).removeClass( 'wcfm_ele_hide' );
							}
						}
					).change();
				}
			);
		}
		availabilityRules();
		$( '#wc_global_appointment_availability' ).find( '.add_multi_input_block' ).click(
			function () {
				availabilityRules();
			}
		);

		   // Track Deleting Rules
		$( '#wc_global_appointment_availability' ).children( '.multi_input_block' ).children( '.remove_multi_input_block' ).click(
			function () {
				removed_rules.push( $( this ).parent().find( '.avail_id' ).val() );
			}
		);

		   // Submit Staff
		$( '#wcfm_wcappointments_settings_submit_button' ).click(
			function (event) {
				event.preventDefault();

				// Validations
				$is_valid = true;

				if ($is_valid) {
					$( '#wcfm-content' ).block(
						{
							message: null,
							overlayCSS: {
								background: '#fff',
								opacity: 0.6
							}
							}
					);
						   var data = {
								action: 'wcfm_ajax_controller',
								controller: 'wcfm-appointments-settings',
								wcfm_wcappointments_settings_form: $( '#wcfm_wcappointments_settings_form' ).serialize(),
								removed_rules: removed_rules,
								status: 'submit',
								wcfm_ajax_nonce: wcfm_params.wcfm_ajax_nonce
					}
					$.post(
						wcfm_params.ajax_url,
						data,
						function (response) {
							if (response) {
								$response_json = $.parseJSON( response );
								if ($response_json.status) {
										audio.play();
										$( '#wcfm_wcappointments_settings_form .wcfm-message' ).html( '<span class="wcicon-status-completed"></span>' + $response_json.message ).addClass( 'wcfm-success' ).slideDown();
										window.location = window.location.href
								} else {
									audio.play();
									$( '.wcfm-message' ).html( '' ).removeClass( 'wcfm-success' ).slideUp();
									$( '#wcfm_wcappointments_settings_form .wcfm-message' ).html( '<span class="wcicon-status-cancelled"></span>' + $response_json.message ).addClass( 'wcfm-error' ).slideDown();
								}

								$( '#wcfm-content' ).unblock();
							}
						}
					);
				}//end if
			}
		);
	}
);
