<?php
/**
 * Plugin Name: Wallet for WooCommerce
 * Description: Wallet for WooCommerce helps your users to quickly complete a purchase by adding funds to the site and using them for future purchases.
 * Version: 5.1.0
 * Author: Flintop
 * Author URI: https://woo.com/vendor/flintop/
 * Text Domain: wallet-for-woocommerce
 * Domain Path: /languages
 * Woo: 8251784:70fd804ff45b1cc08dbb75a992c9072a
 * Requires Plugins: woocommerce
 * Tested up to: 6.8.2
 * WC tested up to: 10.1.1
 * WC requires at least: 3.5.0
 * Copyright: © 2020 Flintop
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 *
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

/**
 * Include once will help to avoid fatal error by load the files when you call init hook 
 */
include_once ABSPATH . 'wp-admin/includes/plugin.php' ;

// Include main class file.
if (!class_exists('FP_Wallet')) {
	include_once 'inc/class-wallet.php' ;
}

if (!function_exists('wal_is_plugin_active')) {

	/**
	 * Is plugin active?
	 * 
	 * @return bool
	 */
	function wal_is_plugin_active() {
		if (wal_is_valid_wordpress_version() && wal_is_woocommerce_active() && wal_is_valid_woocommerce_version()) {
			return true;
		}

		add_action('admin_notices', 'wal_display_warning_message');

		return false;
	}

}

if (!function_exists('wal_is_woocommerce_active')) {

	/**
	 * Function to check whether WooCommerce is active or not.
	 * 
	 * @return bool
	 */
	function wal_is_woocommerce_active() {
		$return = true;
		// This condition is for multi site installation.
		if (is_multisite() && !is_plugin_active_for_network('woocommerce/woocommerce.php') && !is_plugin_active('woocommerce/woocommerce.php')) {
			$return = false;
			// This condition is for single site installation.
		} elseif (!is_plugin_active('woocommerce/woocommerce.php')) {
			$return = false;
		}

		return $return;
	}

}

if (!function_exists('wal_is_valid_wordpress_version')) {

	/**
	 * Is valid WordPress version?
	 * 
	 * @return bool
	 */
	function wal_is_valid_wordpress_version() {
		if (version_compare(get_bloginfo('version'), FP_Wallet::$wp_minimum_version, '<')) {
			return false;
		}

		return true;
	}

}

if (!function_exists('wal_is_valid_woocommerce_version')) {

	/**
	 * Is valid WooCommerce version?
	 * 
	 * @return bool
	 */
	function wal_is_valid_woocommerce_version() {
		if (version_compare(get_option('woocommerce_version'), FP_Wallet::$wc_minimum_version, '<')) {
			return false;
		}

		return true;
	}

}

if (!function_exists('wal_display_warning_message')) {

	/**
	 * Display the WooCommere is not active warning message.
	 */
	function wal_display_warning_message() {
		$notice = '';

		if (!wal_is_valid_wordpress_version()) {
			$notice = sprintf('This version of Wallet for WooCommerce requires WordPress %1s or newer.', FP_Wallet::$wp_minimum_version);
		} elseif (!wal_is_woocommerce_active()) {
			$notice = 'Wallet for WooCommerce Plugin will not work until WooCommerce Plugin is Activated. Please Activate the WooCommerce Plugin.';
		} elseif (!wal_is_valid_woocommerce_version()) {
			$notice = sprintf('This version of Wallet for WooCommerce requires WooCommerce %1s or newer.', FP_Wallet::$wc_minimum_version);
		}

		if ($notice) {
			echo '<div class="error">';
			echo '<p>' . wp_kses_post($notice) . '</p>';
			echo '</div>';
		}
	}

}

// Return if the plugin is not active.
if (!wal_is_plugin_active()) {
	return;
}
// Define constant.
if (!defined('WAL_PLUGIN_FILE')) {
	define('WAL_PLUGIN_FILE', __FILE__);
}

// Return Wallet class object.
if (!function_exists('WAL')) {

	function WAL() {
		return FP_Wallet::instance();
	}

}

// Initialize the plugin.
WAL();
