<?php
/**
 * This template displays the top up form.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/topup-form.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

/**
 * This hook is used to display the extra content before top-up form wrapper.
 * 
 * @since 1.0
 */
do_action( 'wal_before_topup_form_wrapper' ) ;
$incrementor = get_option('wal_general_topup_amount_incrementor');
$step_value = empty($incrementor) ? wal_number_field_step_value() : $incrementor ;
?>
<div class="wal-topup-form-wrapper wal-form-wrapper">

	<div class="wal-dashboard-notices-wrapper">
		<?php wal_print_dashboard_notices() ; ?>
	</div>

	<?php if ( $show ) : ?>
		<form method="POST" action="" class="wal-topup-form">
			<p class="wal-topup-form-title">
				<?php echo wp_kses_post( wal_get_topup_title_label() ) ; ?>
			</p>

			<div class="wal-topup-form-content">
				<?php
				$predefined_buttons = wal_topup_predefined_buttons() ;                                
				if ( wal_check_is_array( $predefined_buttons ) ) :
					?>
					<div class="wal-topup-form-predefined-buttons">
						<?php foreach ( $predefined_buttons as $button_value ) : ?>
							<button type="button" class="wal-topup-predefined-button" data-fund="<?php echo esc_attr(wal_convert_price($button_value) ) ; ?>"><?php echo wp_kses_post( wal_convert_price_by_currency( $button_value ) ) ; ?></button>
						<?php endforeach ; ?>
					</div>
				<?php endif ; ?>

				<div class="wal-topup-form-actions">
				<span class="wal-topup-form-currency"><?php echo esc_attr(get_woocommerce_currency_symbol()) ; ?>
				<input type="number" step="<?php echo esc_attr($step_value); ?>" min="0" 
						   class="wal-number-field wal-topup-form-amount" placeholder="<?php echo esc_attr( wal_get_topup_placeholder_label() ) ; ?>"
						   name="wal-topup-form-amount"/>
						   </span>
					<input type='submit' class="wal-topup-form-btn wal-form-btn" value="<?php echo esc_html( wal_get_topup_button_label() ) ; ?>" >
					<input type="hidden" name="wal-topup-action" value="topup" />
					<input type="hidden" name="wal-topup-nonce" value="<?php echo esc_attr( wp_create_nonce( 'wal-topup' ) ) ; ?>" />
				</div>
			</div>
		</form>
	<?php endif ; ?>
</div>
<?php
/**
 * This hook is used to display the extra content after top-up form wrapper.
 * 
 * @since 1.0
 */
do_action( 'wal_after_topup_form_wrapper' ) ;
