<?php
/**
 * This template is used for displaying the pagination.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/pagination.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
/**
 * This hook is used to display the extra before dashboard content.
 * 
 * @since 3.4.0
 */
do_action('wal_before_dashboard_content');
$start_page = isset($pagination['current_page']) ? $pagination['current_page'] : 1;
$end_page = $start_page + $pagination['pagination_range'] - 1;
?>
<nav class='pagination pagination-centered woocommerce-pagination'>	
	<ul>
		<?php if (1 !== $pagination['current_page']) : ?>
			<li><a href='#' class='wal-pagination wal-first-pagination' data-page='1'><<</a>
			<li><a href='#' class='wal-pagination wal-prev-pagination' data-page='<?php echo esc_attr($pagination['prev_page_count']); ?>'><</a></li>  
		<?php endif; ?>        
		<?php if ($pagination['pagination_range'] + 1 <= $pagination['current_page']) : ?>
			<li><a href='#' class='wal-pagination wal-prev-pagination-dot' data-page='<?php echo esc_attr($pagination['prev_page_row']); ?>'>...</a></li> 
			<?php
		endif;
		for ($start = $start_page; $start <= $end_page; $start++) :
			$page_no = wal_get_pagination_number($start, $pagination['page_count'], $pagination['current_page']);
			if ($page_no >= $pagination['page_count']) {
				break;
			}
			?>
						
			<li>
				<a href='#' class='<?php echo esc_attr(implode(' ', wal_get_pagination_classes($start, $pagination['current_page']))); ?>'
				   data-page='<?php echo esc_attr($page_no); ?>'>
					   <?php echo esc_html($page_no); ?>
				</a>
			</li>                       
			<?php
		endfor;
		if (( $pagination['page_count'] - 1 ) != $pagination['current_page'] && $pagination['page_count'] != $pagination['current_page'] && $pagination['current_page'] <= $pagination['page_count'] - $pagination['pagination_range']) :
			?>
			<li><a href='#' class='wal-pagination wal-next-pagination-dot' data-page='<?php echo esc_attr($pagination['next_page_row']); ?>'>...</a></li> 
			<?php
		endif;

		if ($pagination['page_count'] != $pagination['current_page']) :         
			?>
			<li><a href='#' class='wal-pagination wal-next-pagination' data-page='<?php echo esc_attr($pagination['next_page_count']); ?>'>></a></li>
			<li><a href='#' class='wal-pagination wal-last-pagination' data-page='<?php echo esc_attr($pagination['page_count']); ?>'>>></a></li>
		<?php endif; ?>    
	</ul>
</nav>
<?php
/**
 * This hook is used to display the extra after dashboard content.
 * 
 * @since 3.4.0
 */
do_action('wal_after_dashboard_content');
