<?php
/**
 * This template displays the wallet details.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/myaccount/wallet-details.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
?>
<div class="wal-myaccount-wallet-details-wrapper">
	<?php
	/**
	 * This hook is used to display the extra content before myaccount wallet content.
	 * 
	 * @since 1.0
	 */
	do_action( 'wal_before_myaccount_wallet_content' ) ;
	?>
	<div class="wal-myaccount-wallet-details-content">
		<h2 class="wal-myaccount-wallet-balance-content">
			<label><?php echo wp_kses_post( wal_myaccount_wallet_balance_label() ) ; ?></label>
			<span class="wal-myaccount-wallet-balance"><?php echo wp_kses_post( wal_convert_price_by_currency( WAL_Current_User_Wallet::get_balance() ) ) ; ?></span>
		</h2>

		<table class="wal-myaccount-wallet-details-table">
			<?php
			$wallet_details = wal_myaccount_wallet_details() ;
			if ( wal_check_is_array( $wallet_details ) ) :
				?>
				<tbody>
					<?php foreach ( $wallet_details as $details ) : ?>
						<tr>
							<td class="wal-myaccount-wallet-label"><?php echo wp_kses_post( $details[ 'label' ] ) ; ?></td>
							<td class="wal-myaccount-wallet-value"><?php echo wp_kses_post( $details[ 'value' ] ) ; ?></td>
						</tr>
					<?php endforeach ; ?>
				</tbody>
			<?php endif ; ?>
		</table>
	</div>

	<?php
	/**
	 * This hook is used to display the extra content after myaccount wallet content.
	 * 
	 * @since 1.0
	 */
	do_action( 'wal_after_myaccount_wallet_content' ) ;
	?>
	<p class="wal-myaccount-wallet-dashboard-view-link">
		<?php
		/* translators: %s: dashboard page link */
		printf( esc_html__( 'To see more details, %s', 'wallet-for-woocommerce' ), '<a target="__blank" href="' . esc_url( wc_get_page_permalink( 'wal_dashboard' ) ) . '">' . esc_html__( 'View Dashboard', 'wallet-for-woocommerce' ) . '</a>' ) ;
		?>
	</p>

</div>
<?php
