<?php
/**
 * This template is used for displaying the withdrawal request form in the dashboard.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/modules/wallet-withdrawal/withdrawal-request-form.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
?>
<div class="wal-withdrawal-request-form-wrapper">

	<div class="wal-dashboard-notices-wrapper">
		<?php wal_print_dashboard_notices() ; ?>
	</div>

	<?php if ( $show ) : ?>
		<form method="POST" action="" class="wal-frontend-form wal-withdrawal-request-form" enctype="multipart/form-data">

			<div class='wal-withdrawal-request-form-content'>
				<p class="form-row wal-form-row">
					<label><?php echo esc_html( wal_get_withdrawal_request_user_balance_label() ) ; ?></label>
					<span class='wal-form-row-value wal-withdrawal-request-available-amount'><?php echo wp_kses_post( wal_convert_price_by_currency( WAL_Current_User_Wallet::get_balance() ) ) ; ?></span>
				</p>

				<p class="form-row wal-form-row">
					<label><?php echo esc_html( wal_get_withdrawal_request_amount_label() ) ; ?><span class="required">*</span></label>
					<span class="wal-withdrawal-request-amount-currency"><?php echo esc_attr(get_woocommerce_currency_symbol()) ; ?>
					<input type='number' step="<?php echo esc_attr( wal_number_field_step_value() ) ; ?>" min='0' 
						   name='wal_withdrawal_request_amount' class='wal-form-row-value wal-withdrawal-request-amount' 
						   placeholder="<?php echo esc_attr( wal_get_withdrawal_request_amount_placeholder_label() ) ; ?>"/>
					</span>
				</p>

				<?php
				/**
				 * This hook is used to display the extra content before fields.
				 * 
				 * @since 1.8
				 */
				do_action( 'wal_wallet_withdrawal_before_fields' ) ;
				?>

				<p class="form-row wal-form-row">
					<label><?php echo esc_html( wal_get_withdrawal_request_payment_gateway_selection_label() ) ; ?><span class="required">*</span></label>
					<select name="wal_withdrawal_payment_gateway" class="wal-form-row-value wal-withdrawal-payment-gateway">
						<?php foreach ( wal_get_wallet_withdrawal_payment_gateways_options() as $gateway_id => $gateway_name ) : ?>
							<option value="<?php echo esc_attr( $gateway_id ) ; ?>"<?php selected( $gateway_id, WAL_Current_User_Wallet::get_withdrawal_payment_gateway() ) ; ?>>
								<?php echo esc_html( $gateway_name ) ; ?>
							</option>
						<?php endforeach ; ?>
					</select>
				</p>

				<?php
				/**
				 * This hook is used to display the extra content after fields.
				 * 
				 * @since 1.8
				 */
				do_action( 'wal_wallet_withdrawal_after_fields' ) ;
				?>

				<p class="form-row wal-form-row">
					<input type='submit' class="wal-withdrawal-request-button wal-form-button" value="<?php echo esc_attr( wal_get_withdrawal_request_button_label() ) ; ?>" >
					<input type="hidden" name="wal-action" value="wallet-withdrawal" />
					<input type="hidden" name="wal-wallet-withdrawal-nonce" value="<?php echo esc_attr( wp_create_nonce( 'wal-wallet-withdrawal' ) ) ; ?>" />
				</p>
			</div>
		</form>
	<?php endif ; ?>
</div>
<?php
