<?php
/**
 * This template is used for displaying the wallet withdrawal request confirmation form in the dashboard.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/modules/wallet-withdrawal/withdrawal-request-confirmation.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
?>

<div class="wal-withdrawal-request-form-wrapper">

	<div class="wal-dashboard-notices-wrapper">
		<?php wal_print_dashboard_notices() ; ?>
	</div>

	<form method="POST" action="" class="wal-frontend-form wal-withdrawal-request-form" enctype="multipart/form-data">

		<div class='wal-withdrawal-request-form-content'>

			<p class="form-row wal-form-row">
				<label><?php echo esc_html( wal_get_withdrawal_request_user_balance_label() ) ; ?></label>
				<span class='wal-form-row-value wal-withdrawal-request-available-amount'><?php echo wp_kses_post( wal_convert_price_by_currency( WAL_Current_User_Wallet::get_balance() ) ) ; ?></span>
			</p>

			<p class="form-row wal-form-row">
				<label><?php echo esc_html( wal_get_withdrawal_request_amount_label() ) ; ?></label>
				<span class='wal-form-row-value wal-withdrawal-request-amount'><?php echo wp_kses_post( wal_price($amount)) ; ?></span>
				<input type="hidden" name="wal_withdrawal_request_amount" value="<?php echo esc_attr( $amount ) ; ?>" />
			</p>

			<p class="form-row wal-form-row">
				<label><?php echo esc_html( wal_get_withdrawal_request_fee_label() ) ; ?></label>
				<span class='wal-form-row-value wal-withdrawal-request-fee'><?php echo wp_kses_post( wal_convert_price_by_currency( $fee ) ) ; ?></span>
			</p>

			<p class="form-row wal-form-row">
				<label><?php echo esc_html( wal_get_withdrawal_request_payment_gateway_selection_label() ) ; ?></label>
				<span class='wal-form-row-value wal-withdrawal-request-payment-gateway'><?php echo wp_kses_post( wal_wallet_withdrawal_gateway_title_by_id( $gateway_id ) ) ; ?></span>
				<input type="hidden" name="wal_withdrawal_payment_gateway" value="<?php echo esc_attr( $gateway_id ) ; ?>" />
			</p>

			<?php foreach ( $credential_details as $credential_id => $credential ) : ?>
				<p class="form-row wal-form-row">
					<label><?php echo esc_html( $credential[ 'label' ] ) ; ?></label>
					<span class='wal-form-row-value wal-withdrawal-request-credential-'.<?php echo esc_attr( $credential_id ); ?>><?php echo wp_kses_post( $credential[ 'value' ] ) ; ?></span>
				</p>
			<?php endforeach ; ?>

			<?php if ( wal_wallet_withdrawal_otp_enabled() ) : ?>
				<p class="form-row wal-form-row">
					<label><?php echo esc_html( wal_get_withdrawal_request_otp_label() ) ; ?><span class="required">*</span></label>
					<input type='text' name='wal_withdrawal_request_verify_otp' class='wal-form-row-value wal-withdrawal-request-verify-otp' />
				</p>
			<?php endif ; ?>

			<p class="form-row wal-form-row">
				<input type='submit' class="wal-withdrawal-request-confirm-button wal-form-button" value="<?php echo esc_attr( wal_get_withdrawal_request_confirm_button_label() ) ; ?>" >
				<input type="hidden" name="wal-action" value="confirm" />
				<input type="hidden" name="wal-wallet-withdrawal-nonce" value="<?php echo esc_attr( wp_create_nonce( 'wal-wallet-withdrawal' ) ) ; ?>" />
			</p>
		</div>
	</form>
</div>
<?php
