<?php
/**
 * This template is used for displaying the dashboard wallet withdrawal transactions.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/modules/wallet-withdrawal/transactions.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

$columns = wal_wallet_withdrawal_transactions_columns();
foreach ($withdrawal_ids as $withdrawal_id) :

	$wallet_withdrawal = wal_get_wallet_withdrawal($withdrawal_id);
	if (!$wallet_withdrawal->exists()) {
		continue;
	}
	?>
	<tr>
		<?php foreach ($columns as $column_key => $column_name) : ?>
			<td data-title="<?php echo esc_attr($column_name); ?>">
				<?php
				switch ($column_key) :

					case 'amount':
						echo wp_kses_post(wal_convert_price_by_currency($wallet_withdrawal->get_amount()));
						break;

					case 'fee':
						echo wp_kses_post(wal_convert_price_by_currency($wallet_withdrawal->get_fee()));
						break;

					case 'payment_method':
						echo wp_kses_post($wallet_withdrawal->get_payment_gateway_title());
						break;

					case 'status':
						echo wp_kses_post(wal_display_post_status($wallet_withdrawal->get_status()));
						if ('wal_cancelled' === $wallet_withdrawal->get_status() && !empty($wallet_withdrawal->get_cancelled_reason())) {
							printf('<a class="wal-user-withdrawal-cancelled-reason button" data-id=%s>%s</a>', absint($withdrawal_id), esc_html__('Reason', 'wallet-for-woocommerce'));
						}
						break;

					case 'created_date':
						echo wp_kses_post($wallet_withdrawal->get_formatted_created_date());
						break;

					default:
						/**
						 * This hook is used to display the content for wallet withdrawal transaction custom column.
						 * 
						 * @since 1.8
						 */
						do_action('wal_dashboard_wallet_withdrawal_transaction_column_' . $column_key, $column_key, $wallet_withdrawal);
						break;
				endswitch;
				?>
			</td>

		<?php endforeach; ?>
	</tr>
	<?php
endforeach;
?>
<div class="wal-hide wal-popup" data-popup="#wal-wallet-cancelled-reason-popup">
	<div id="wal-wallet-cancelled-reason-popup"></div>
</div>   
