<?php
/**
 * This template displays the cancelled reason.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/modules/wallet-withdrawal/cancelled-reason.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
?>
<div class="wal-user-withdrawal-cancelled-reason-wrapper">
	<h1>
		<?php
		/* translators: %s - ID */
		echo wp_kses_post(sprintf(__('Withdrawal ID - #%s', 'wallet-for-woocommerce'), absint($wallet_withdrawal->get_id())));
		?>
	</h1>
	<div class="wal-wallet-withdrawal-cancelled-popup-content">
		<h4><b><?php esc_html_e('Canceled Reason', 'wallet-for-woocommerce'); ?></b></h4>	
		<?php echo wp_kses_post(wpautop($wallet_withdrawal->get_cancelled_reason())); ?>
	</div>
</div>
<?php
