<?php
/**
 * This template is used for displaying the bank gateway fields in the wallet withdrawal settings form.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/modules/wallet-withdrawal/bank-gateway-fields.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
?>
<p class="form-row wal-form-row">
	<label><?php echo esc_html( wal_get_withdrawal_bank_gateway_account_name_label() ) ; ?><span class="required">*</span></label>
	<input name="wal_bank_gateway_account_name" class="wal-form-row-value wal-withdrawal-gateway-fields wal-bank-gateway-account-name wal-bank-gateway-fields" value="<?php echo esc_attr( $account_name ) ; ?>"/>
</p>
<p class="form-row wal-form-row">
	<label><?php echo esc_html( wal_get_withdrawal_bank_gateway_account_number_label() ) ; ?><span class="required">*</span></label>
	<input name="wal_bank_gateway_account_number" class="wal-form-row-value wal-withdrawal-gateway-fields wal-bank-gateway-account-number wal-bank-gateway-fields" value="<?php echo esc_attr( $account_number ) ; ?>"/>
</p>
<p class="form-row wal-form-row">
	<label><?php echo esc_html( wal_get_withdrawal_bank_gateway_ifsc_code_label() ) ; ?><span class="required">*</span></label>
	<input name="wal_bank_gateway_ifsc_code" class="wal-form-row-value wal-withdrawal-gateway-fields wal-bank-gateway-ifsc-code wal-bank-gateway-fields" value="<?php echo esc_attr( $ifsc_code ) ; ?>"/>
</p>
<p class="form-row wal-form-row">
	<label><?php echo esc_html( wal_get_withdrawal_bank_gateway_bank_name_label() ) ; ?></label>
	<input name="wal_bank_gateway_bank_name" class="wal-form-row-value wal-withdrawal-gateway-fields wal-bank-gateway-bank-name wal-bank-gateway-fields" value="<?php echo esc_attr( $bank_name ) ; ?>"/>
</p>
<p class="form-row wal-form-row">
	<label><?php echo esc_html( wal_get_withdrawal_bank_gateway_routing_number_label() ) ; ?></label>
	<input name="wal_bank_gateway_routing_number" class="wal-form-row-value wal-withdrawal-gateway-fields wal-bank-gateway-routing-number wal-bank-gateway-fields" value="<?php echo esc_attr( $routing_number ) ; ?>"/>
</p>
<p class="form-row wal-form-row">
	<label><?php echo esc_html( wal_get_withdrawal_bank_gateway_iban_number_label() ) ; ?></label>
	<input name="wal_bank_gateway_iban_number" class="wal-form-row-value wal-withdrawal-gateway-fields wal-bank-gateway-iban-number wal-bank-gateway-fields" value="<?php echo esc_attr( $iban_number ) ; ?>"/>
</p>
<p class="form-row wal-form-row">
	<label><?php echo esc_html( wal_get_withdrawal_bank_gateway_swift_code_label() ) ; ?></label>
	<input name="wal_bank_gateway_swift_code" class="wal-form-row-value wal-withdrawal-gateway-fields wal-bank-gateway-swift-code wal-bank-gateway-fields" value="<?php echo esc_attr( $swift_code ) ; ?>"/>
</p>
<?php
