<?php
/**
 * This template is used for displaying the products purchase fund details.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/modules/product-purchase/product-purchase-fund-details.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 * 
 * @var array $product_purchase_funds
 * @var int $product_id
 * @var object $product
 * @var float $fund
 * 
 * @since 3.1.0
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
/**
 * This hook is used to do extra before product purchase fund details.
 *  
 * @since 3.1.0
 */
do_action('wal_before_email_product_purchase_fund_details');
?>
<table class='wal-product-purchase-fund-details'>
	<tr class='wal-product-purchase-fund-details-row'>
		<th class='wal-product-purchase-fund-details-head'><?php esc_html_e('Product Name', 'wallet-for-woocommerce'); ?></th>
		<th class='wal-product-purchase-fund-details-head'><?php esc_html_e('Product Price', 'wallet-for-woocommerce'); ?></th>		
		<th class='wal-product-purchase-fund-details-head'><?php esc_html_e('Funds Earned', 'wallet-for-woocommerce'); ?></th>
	</tr>
	<?php
	$product_purchase_funds = $order->get_meta('wal_product_purchase_details');
	if (!wal_check_is_array($product_purchase_funds)) {
		return;
	}
	foreach ($product_purchase_funds as $product_id => $fund) {
		$product = wc_get_product($product_id);
		if (!is_object($product)) {
			continue;
		}
		?>
		<tr class='wal-product-purchase-fund-details-row'>
			<td class='wal-product-purchase-fund-details-data'> <?php esc_html_e($product->get_name()); ?> </td>
			<td class='wal-product-purchase-fund-details-data'> <?php echo wp_kses_post(wal_convert_price_by_currency($product->get_price())); ?> </td>			
			<td class='wal-product-purchase-fund-details-data'> <?php echo wp_kses_post(wal_convert_price_by_currency($fund)); ?> </td>
		</tr> 
	<?php } ?>
</table>
<br>
<?php
/**
 * This hook is used to do extra after product purchase fund details.
 *  
 * @since 3.1.0
 */
do_action('wal_after_email_product_purchase_fund_details');
