<?php
/**
 * This template is used for displaying the dashboard redeem form.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/modules/gift-voucher/redeem-form.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
?>
<div class="wal-dashboard-redeem-gift-voucher-content-wrapper wal-dashboard-content-wrapper">
	<div class="wal-redeem-gift-voucher-form-wrapper wal-form-wrapper">

		<div class="wal-dashboard-notices-wrapper">
			<?php wal_print_dashboard_notices() ; ?>
		</div>

		<?php if ($show) : ?>    
		<form method="POST" action="" class="wal-redeem-gift-voucher-form">
			<p class="wal-redeem-gift-voucher-form-title">
				<?php echo wp_kses_post( wal_get_gift_voucher_title_label() ) ; ?>
			</p>

			<div class="wal-redeem-gift-voucher-form-content">
				<input type="text" class="wal-redeem-gift-voucher-code" 
					   placeholder="<?php echo esc_attr( wal_get_gift_voucher_placeholder_label() ) ; ?>"
					   name="wal_redeem_gift_voucher_code"/>

				<input type='submit' class="wal-redeem-gift-voucher-form-btn wal-form-btn" value="<?php echo esc_html( wal_get_gift_voucher_button_label() ) ; ?>" >
				<input type="hidden" name="wal_redeem_gift_voucher_action" value="redeem-gift-voucher" />
				<input type="hidden" name="wal_redeem_gift_voucher_nonce" value="<?php echo esc_attr( wp_create_nonce( 'wal-redeem-gift-voucher' ) ) ; ?>" />
			</div>
		</form>
		<?php endif; ?>
	</div>
<?php
