<?php
/**
 * This template is used for displaying the dashboard fund transfer view transaction.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/modules/fund-transfer/view-transaction.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
?>
<div class="wal-dashboard-view-transactions-content-wrapper wal-dashboard-content-wrapper">
	<?php if ( $fund_transfer->exists() ) : ?>
		<?php if ( is_object($fund_transfer->get_receiver())) : ?>
		<div class="wal-fund-transfer-transaction-user-info wal-view-transaction-logs-header">
			<h3>
				<?php echo esc_html( $fund_transfer->get_receiver()->display_name ) ; ?>
				<i><?php echo esc_html( $fund_transfer->get_receiver()->user_email ) ; ?><i/>
			</h3>
		</div>
		<?php endif; ?>

		<div class="wal-view-transaction-logs-content">
			<?php
			if ( wal_check_is_array( $transaction_log_ids ) ) :
				foreach ( $transaction_log_ids as $transaction_log_id ) :
					$transaction_log = wal_get_fund_transfer_log( $transaction_log_id ) ;
					$classes         = array( 'wal-fund-transfer-transaction-logs' ) ;
					$classes[]       = ( 'yes' == $transaction_log->get_sent_by() ) ? 'wal-sender-transfer-log' : 'wal-receiver-transfer-log' ;
					?>
					<div class="<?php echo esc_attr( implode( ' ' , $classes ) ) ; ?>">
						<?php
						wal_get_template(
								'modules/fund-transfer/transaction-details.php' , array(
							'transaction_log' => $transaction_log,
								)
						) ;
						?>
					</div>
					<?php
				endforeach ;
			endif ;
			?>
		</div>

		<div class="wal-view-transaction-logs-footer">
			<?php if ( wal_user_id_exists( $fund_transfer->get_receiver_id() ) ) : ?>
				<?php if ( wal_fund_transfer_enabled() ) : ?>
					<a href="<?php echo esc_url( add_query_arg( array( 'wal_receiver_id' => $fund_transfer->get_receiver_id() ) , wal_dashboard_menu_endpoint_url( 'fund_transfer' ) ) ) ; ?>"><?php esc_html_e( 'Transfer' , 'wallet-for-woocommerce' ) ; ?></a>
				<?php endif ; ?>

				<?php if ( wal_fund_request_enabled() ) : ?>
					<a href="<?php echo esc_url( add_query_arg( array( 'wal_receiver_id' => $fund_transfer->get_receiver_id() ) , wal_dashboard_menu_endpoint_url( 'fund_request' ) ) ) ; ?>"><?php esc_html_e( 'Request' , 'wallet-for-woocommerce' ) ; ?></a>
				<?php endif ; ?>
			<?php else : ?>
				<?php esc_html_e( 'Current user has been not exists.' , 'wallet-for-woocommerce' ) ; ?>
			<?php endif ; ?>
		</div>
		<?php
	else :
		?>
		<div class="woocommerce-error"><?php esc_html_e( 'Invalid fund transfer ID' , 'wallet-for-woocommerce' ) ; ?></div>
		<?php
	endif ;
	?>
</div>
<?php
