<?php
/**
 * This template is used for displaying the dashboard fund transfer transaction.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/modules/fund-transfer/transaction.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

foreach ( $fund_transfer_ids as $fund_transfer_id ) :

	$fund_transfer = wal_get_fund_transfer( $fund_transfer_id ) ;
	if ( ! $fund_transfer->exists() ) {
		continue ;
	}
	?>
	<tr>
		<?php foreach ( $columns as $column_key => $column_name ) : ?>
			<td data-title="<?php echo esc_attr( $column_name ) ; ?>">
				<?php
				switch ( $column_key ) :

					case 'user_name':
						echo wp_kses_post( $fund_transfer->get_receiver_user_name() ) ;
						break ;

					case 'status':
						echo wp_kses_post( wal_display_post_status( $fund_transfer->get_status() ) ) ;
						break ;

					case 'transfered_total':
						echo wp_kses_post( wal_convert_price_by_currency( $fund_transfer->get_transfered_total())) ;
						break ;

					case 'received_total':
						echo wp_kses_post( wal_convert_price_by_currency( $fund_transfer->get_received_total())) ;
						break ;

					case 'last_activity_date':
						echo wp_kses_post( $fund_transfer->get_formatted_last_activity_date() ) ;
						break ;

					case 'actions':
						$url = add_query_arg( array( 'wal_view_transfer' => $fund_transfer->get_id() ), wal_dashboard_menu_endpoint_url( 'transactions' ) ) ;
						echo '<a href=' . esc_url( $url ) . ' class="wal-fund-transfer-view-action">' . esc_html__( 'View Details', 'wallet-for-woocommerce' ) . '</a>' ;
						break ;

					default:
						/**
						 * This hook is used to display the content for fund transfer transaction custom column.
						 * 
						 * @since 1.0
						 */
						do_action( 'wal_dashboard_fund_transfer_transaction_column_' . $column_key, $column_key, $fund_transfer ) ;
						break ;
				endswitch ;
				?>
			</td>

		<?php endforeach ; ?>
	</tr>
	<?php
endforeach ;
