<?php
/**
 * This template is used for displaying the dashboard fund transfer transaction wrapper.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/dashboard/modules/fund-transfer/transaction-wrapper.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

$columns = wal_fund_transfer_transaction_columns() ;
?>
<div class="wal-dashboard-fund-transfer-transaction-content-wrapper wal-dashboard-content-wrapper" data-table_name='fund_transfer'>
	<table class = "wal-frontend-table wal-dashboard-fund-transfer-transaction-table">

		<thead>
			<tr>
				<?php foreach ( $columns as $column_name ) : ?>
					<th><?php echo esc_html( $column_name ) ; ?></th>
				<?php endforeach ; ?>
			</tr>
		</thead>

		<tbody>

			<?php
			if ( wal_check_is_array( $fund_transfer_ids ) ) :
				wal_get_template(
						'modules/fund-transfer/transaction.php' , array(
					'fund_transfer_ids' => $fund_transfer_ids,
					'columns'           => $columns,
						)
				) ;
			else :
				?>
				<tr>
					<td colspan="<?php echo esc_attr( count( $columns ) ) ; ?>">
						<?php esc_html_e( 'No activity found.' , 'wallet-for-woocommerce' ) ; ?>
					</td>
				<tr>
				<?php
				endif ;
			?>
		</tbody>

		<?php if ( $pagination[ 'page_count' ] > 1 ) : ?>
			<tfoot>
				<tr>
					<td colspan="<?php echo esc_attr( count( $columns ) ) ; ?>" class="footable-visible">
						<?php wal_get_template( 'pagination.php' , array( 'pagination'=>$pagination ) ) ; ?>
					</td>
				</tr>
			</tfoot>
		<?php endif ; ?>
	</table> 
</div>
<?php
