<?php
/**
 * This template is used for displaying the dashboard fund transfer transaction details.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/modules/fund-transfer/transaction-details.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
?>
<div class="wal-view-transaction-log-content">      
	<p class="wal-transfered-amount"><?php echo wp_kses_post( wal_convert_price($transaction_log->get_amount())); ?></p>
	<p class="wal-transfered-reason"><?php echo esc_html($transaction_log->get_reason()); ?></p>
	<p class="wal-transfered-status"><?php echo wp_kses_post(wal_format_fund_transfer_log_status($transaction_log)); ?></p>

	<?php if ($transaction_log->has_status(array( 'wal_requested', 'wal_request_received' ))) : ?>
		<p>
			<input type="hidden" class="wal-fund-transfer-transaction-id" value="<?php echo esc_attr($transaction_log->get_id()); ?>"/>
			<?php if ($transaction_log->get_sent_by() != 'yes') : ?>
				<input type="button" class="wal-accept-fund-request wal-fund-transfer-transaction-button" value="<?php esc_html_e('Transfer', 'wallet-for-woocommerce'); ?>"/>
				<input type="button" class="wal-decline-fund-request wal-fund-transfer-transaction-button" value="<?php esc_html_e('Decline', 'wallet-for-woocommerce'); ?>"/>
			<?php else : ?>
				<input type="button" class="wal-cancel-fund-request wal-fund-transfer-transaction-button" value="<?php esc_html_e('Cancel', 'wallet-for-woocommerce'); ?>"/>
			<?php endif; ?>
		</p>
	<?php endif; ?>
</div>
<?php
