<?php
/**
 * This template is used for displaying the dashboard fund transfer form.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/modules/fund-transfer/fund-transfer-form.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
?>
<div class="wal-fund-transfer-form-wrapper">

	<div class="wal-dashboard-notices-wrapper">
		<?php wal_print_dashboard_notices() ; ?>
	</div>

	<?php if ( $show ) : ?>
		<form method="POST" action="" class="wal-frontend-form wal-fund-transfer-form" enctype="multipart/form-data">

			<div class='wal-fund-transfer-form-content'>

				<p class="form-row wal-form-row">
					<?php
					if ( $show_user_search ) :
						?>
						<label><?php echo esc_html( wal_get_fund_transfer_user_selection_label() ) ; ?><span class="required">*</span></label>
						<input class="wal-form-row-value wal-fund-transfer-user-name" type="text" placeholder="<?php echo esc_attr(wal_get_fund_transfer_user_selection_placeholder_label()); ?>" />
						<input type="hidden" class="wal-fund-transfer-user-id" name="wal_fund_transfer_receiver_id[]" value="<?php echo esc_attr( $user_id ) ; ?>" />
						<?php
					else :
						?>
						<label><?php echo esc_html( wal_get_fund_transfer_user_name_label() ) ; ?></label>
						<span class="wal-form-row-value wal-fund-transfer-user-name"><?php echo esc_html( get_userdata( $user_id )->display_name ) ; ?></span>
						<input type="hidden" name="wal_fund_transfer_receiver_id[]" value="<?php echo esc_attr( $user_id ) ; ?>" />
					<?php endif ; ?>
				</p>

				<p class="form-row wal-form-row">
					<label><?php echo esc_html( wal_get_fund_transfer_user_balance_label() ) ; ?></label>
					<span class='wal-form-row-value wal-fund-transfer-available-amount'><?php echo wp_kses_post( wal_convert_price_by_currency( WAL_Current_User_Wallet::get_balance() ) ) ; ?></span>
				</p>

				<p class="form-row wal-form-row">
					<label><?php echo esc_html( wal_get_fund_transfer_amount_label() ) ; ?><span class="required">*</span></label>
					<input type='number' step="<?php echo esc_attr( wal_number_field_step_value() ) ; ?>" min='0' 
						   name='wal_fund_transfer_amount' class='wal-form-row-value wal-fund-transfer-amount' 
						   placeholder="<?php echo esc_attr( wal_get_fund_transfer_amount_placeholder_label() ) ; ?>" value="<?php echo esc_attr( wal_convert_price_by_currency($amount) ) ; ?>" />
				</p>

				<?php if ( wal_fund_transfer_fee_enabled() ) : ?>
					<p class="form-row wal-form-row">
						<label><?php echo esc_html( wal_get_fund_transfer_fee_label() ) ; ?></label>
						<span class='wal-form-row-value wal-fund-transfer-fee'><?php echo wp_kses_post( wal_convert_price_by_currency($fee) ) ; ?></span>
					</p>
				<?php endif ; ?>

				<p class="form-row wal-form-row">
					<label><?php echo esc_html( wal_get_fund_transfer_reason_label() ) ; ?></label>
					<textarea name='wal_fund_transfer_reason' class='wal-form-row-value wal-fund-transfer-reason' placeholder="<?php echo esc_attr( wal_get_fund_transfer_reason_placeholder_label() ) ; ?>"><?php echo esc_html( $reason ) ; ?></textarea>
				</p>

				<p class="form-row wal-form-row">
					<input type='submit' class="wal-fund-transfer-button wal-form-button" value="<?php echo esc_attr( wal_get_fund_transfer_button_label() ) ; ?>" >
					<input type="hidden" name="wal-action" value="fund_transfer" />
					<input type="hidden" name="wal-fund-transfer-nonce" value="<?php echo esc_attr( wp_create_nonce( 'wal-fund-transfer' ) ) ; ?>" />
				</p>
			</div>
		</form>
	<?php endif ; ?>

</div>
<?php
