<?php
/**
 * This template is used for displaying the dashboard fund transfer confirmation form.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/modules/fund-transfer/fund-transfer-confirmation.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
?>

<div class="wal-fund-transfer-form-wrapper">

	<div class="wal-dashboard-notices-wrapper">
		<?php wal_print_dashboard_notices() ; ?>
	</div>

	<form method="POST" action="" class="wal-frontend-form wal-fund-transfer-form" enctype="multipart/form-data">

		<div class='wal-fund-transfer-form-content'>
			<p class="form-row wal-form-row">
				<label><?php echo esc_html( wal_get_fund_transfer_user_name_label() ) ; ?></label>
				<span class="wal-form-row-value wal-fund-transfer-user-name"><?php echo esc_html( get_userdata($user_id)->display_name ) ; ?></span>
				<input type="hidden" name="wal_fund_transfer_receiver_id[]" value="<?php echo esc_attr( $user_id ) ; ?>" />
			</p>

			<p class="form-row wal-form-row">
				<label><?php echo esc_html( wal_get_fund_transfer_user_balance_label() ) ; ?></label>
				<span class='wal-form-row-value wal-fund-transfer-available-amount'><?php echo wp_kses_post( wal_convert_price_by_currency( WAL_Current_User_Wallet::get_balance() ) ) ; ?></span>
			</p>

			<p class="form-row wal-form-row">
				<label><?php echo esc_html( wal_get_fund_transfer_amount_label() ) ; ?></label>
				<span class='wal-form-row-value wal-fund-transfer-amount'><?php echo wp_kses_post( wal_price($amount) ) ; ?></span>
				<input type="hidden" name="wal_fund_transfer_amount" value="<?php echo esc_attr( $amount ) ; ?>" />
			</p>

			<?php if ( wal_fund_transfer_fee_enabled() ) : ?>
				<p class="form-row wal-form-row">
					<label><?php echo esc_html( wal_get_fund_transfer_fee_label() ) ; ?></label>
					<span class='wal-form-row-value wal-fund-transfer-fee'><?php echo wp_kses_post( wal_convert_price_by_currency($fee) ) ; ?></span>
				</p>
			<?php endif ; ?>

			<p class="form-row wal-form-row">
				<label><?php echo esc_html( wal_get_fund_transfer_reason_label() ) ; ?></label>
				<span class='wal-form-row-value wal-fund-transfer-reason'><?php echo wp_kses_post( $reason ) ; ?></span>
				<input type="hidden" name="wal_fund_transfer_reason" value="<?php echo esc_attr( $reason ) ; ?>" />
			</p>

			<?php if ( wal_fund_transfer_otp_enabled() ) : ?>
				<p class="form-row wal-form-row">
					<label><?php echo esc_html( wal_get_fund_transfer_otp_label() ) ; ?><span class="required">*</span></label>
					<input type='text' name='wal_fund_transfer_verify_otp' class='wal-form-row-value wal-fund-transfer-verify-otp' />
				</p>
			<?php endif ; ?>

			<p class="form-row wal-form-row">
				<input type='submit' class="wal-fund-transfer-confirm-button wal-form-button" value="<?php echo esc_attr( wal_get_fund_transfer_confirm_button_label() ) ; ?>" >
				<input type="hidden" class="wal-action" name="wal-action" value="confirm" />
				<input type="hidden" name="wal-fund-transfer-nonce" value="<?php echo esc_attr( wp_create_nonce( 'wal-fund-transfer' ) ) ; ?>" />
			</p>
		</div>
	</form>
</div>
<?php
